/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.fluentvalidator.interceptor;

import com.baidu.unbiz.fluentvalidator.ComplexResult;
import com.baidu.unbiz.fluentvalidator.DefaultValidateCallback;
import com.baidu.unbiz.fluentvalidator.FluentValidator;
import com.baidu.unbiz.fluentvalidator.ResultCollectors;
import com.baidu.unbiz.fluentvalidator.ValidateCallback;
import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorChain;
import com.baidu.unbiz.fluentvalidator.annotation.FluentValid;
import com.baidu.unbiz.fluentvalidator.exception.RuntimeValidateException;
import com.baidu.unbiz.fluentvalidator.jsr303.HibernateSupportedValidator;
import com.baidu.unbiz.fluentvalidator.registry.Registry;
import com.baidu.unbiz.fluentvalidator.registry.impl.SpringApplicationContextRegistry;
import com.baidu.unbiz.fluentvalidator.support.FluentValidatorPostProcessor;
import com.baidu.unbiz.fluentvalidator.util.ArrayUtil;
import com.baidu.unbiz.fluentvalidator.util.CollectionUtil;
import com.baidu.unbiz.fluentvalidator.util.LocaleUtil;
import com.baidu.unbiz.fluentvalidator.util.Preconditions;
import com.baidu.unbiz.fluentvalidator.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FluentValidateInterceptor
implements MethodInterceptor,
InitializingBean,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(FluentValidateInterceptor.class);
    private ApplicationContext applicationContext;
    private ValidateCallback callback = new DefaultValidateCallback();
    private SpringApplicationContextRegistry registry;
    private FluentValidatorPostProcessor fluentValidatorPostProcessor;
    private javax.validation.Validator validator;
    private String locale;
    private int hibernateDefaultErrorCode;

    public void afterPropertiesSet() throws Exception {
        this.registry = new SpringApplicationContextRegistry();
        this.registry.setApplicationContext(this.applicationContext);
        if (this.validator == null) {
            if (this.locale != null) {
                Locale.setDefault(LocaleUtil.parseLocale(this.locale));
            }
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            this.validator = factory.getValidator();
        }
        LOGGER.info("Place " + this.getClass().getSimpleName() + " as an interceptor");
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class targetClass = invocation.getThis() != null ? AopUtils.getTargetClass((Object)invocation.getThis()) : null;
        Preconditions.checkState((targetClass != null ? 1 : 0) != 0, (Object)"Target class should NOT be NULL!");
        try {
            Object[] arguments = invocation.getArguments();
            Class[] parameterTypes = invocation.getMethod().getParameterTypes();
            Method implMethod = ReflectionUtil.getMethod((Class)targetClass, (String)invocation.getMethod().getName(), (Class[])parameterTypes);
            Annotation[][] paramAnnotations = implMethod.getParameterAnnotations();
            if (paramAnnotations != null) {
                block3: for (int i = 0; i < paramAnnotations.length; ++i) {
                    Object[] paramAnnotation = paramAnnotations[i];
                    if (ArrayUtil.isEmpty((Object[])paramAnnotation)) continue;
                    for (int j = 0; j < paramAnnotation.length; ++j) {
                        ComplexResult result;
                        if (paramAnnotation[j].annotationType() != FluentValid.class) continue;
                        LOGGER.debug("Find @FluentValid annotation on index[" + i + "] parameter and ready to " + "validate for method " + implMethod);
                        ValidatorChain addOnValidatorChain = this.getAddOnValidatorChain((FluentValid)paramAnnotation[j]);
                        Class[] groups = ((FluentValid)paramAnnotation[j]).groups();
                        Class[] excludeGroups = ((FluentValid)paramAnnotation[j]).excludeGroups();
                        boolean isFailFast = ((FluentValid)paramAnnotation[j]).isFailFast();
                        FluentValidator fluentValidator = FluentValidator.checkAll((Class[])groups).setExcludeGroups(excludeGroups).configure((Registry)this.registry).setIsFailFast(isFailFast);
                        if (this.fluentValidatorPostProcessor != null) {
                            this.fluentValidatorPostProcessor.postProcessBeforeDoValidate(fluentValidator, invocation);
                        }
                        if ((result = Collection.class.isAssignableFrom(parameterTypes[i]) ? (ComplexResult)fluentValidator.on(arguments[i], addOnValidatorChain).onEach((Collection)arguments[i], (Validator)new HibernateSupportedValidator().setHibernateDefaultErrorCode(this.hibernateDefaultErrorCode).setHiberanteValidator(this.validator)).when(arguments[i] != null).onEach((Collection)arguments[i]).doValidate(this.callback).result(ResultCollectors.toComplex()) : (parameterTypes[i].isArray() ? (ComplexResult)fluentValidator.on(arguments[i], addOnValidatorChain).onEach(ArrayUtil.toWrapperIfPrimitive((Object)arguments[i]), (Validator)new HibernateSupportedValidator().setHibernateDefaultErrorCode(this.hibernateDefaultErrorCode).setHiberanteValidator(this.validator)).when(arguments[i] != null).onEach(ArrayUtil.toWrapperIfPrimitive((Object)arguments[i])).doValidate(this.callback).result(ResultCollectors.toComplex()) : (ComplexResult)fluentValidator.on(arguments[i], addOnValidatorChain).on(arguments[i], (Validator)new HibernateSupportedValidator().setHibernateDefaultErrorCode(this.hibernateDefaultErrorCode).setHiberanteValidator(this.validator)).when(arguments[i] != null).on(arguments[i]).doValidate(this.callback).result(ResultCollectors.toComplex()))) == null) continue block3;
                        LOGGER.debug(result.toString());
                        continue block3;
                    }
                }
            }
            return invocation.proceed();
        }
        catch (RuntimeValidateException e) {
            throw e.getCause();
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    private ValidatorChain getAddOnValidatorChain(FluentValid fluentValid) {
        ValidatorChain chain = new ValidatorChain();
        chain.setValidators(this.getAddOnValidators(fluentValid));
        return chain;
    }

    private List<Validator> getAddOnValidators(FluentValid fluentValid) {
        ArrayList addOnValidators = null;
        if (!ArrayUtil.isEmpty((Object[])fluentValid.value())) {
            LOGGER.debug(String.format("{} additional validators found", new Object[0]), (Object)fluentValid.value().length);
            Class[] addOnValidatorClasses = fluentValid.value();
            addOnValidators = CollectionUtil.createArrayList((int)fluentValid.value().length);
            for (Class addOnValidatorClass : addOnValidatorClasses) {
                List beans = this.registry.findByType(addOnValidatorClass);
                if (CollectionUtil.isEmpty(beans)) continue;
                addOnValidators.add((Validator)beans.get(0));
            }
        }
        return addOnValidators;
    }

    public void setCallback(ValidateCallback callback) {
        this.callback = callback;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setValidator(javax.validation.Validator validator) {
        this.validator = validator;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setHibernateDefaultErrorCode(int hibernateDefaultErrorCode) {
        this.hibernateDefaultErrorCode = hibernateDefaultErrorCode;
    }

    public void setFluentValidatorPostProcessor(FluentValidatorPostProcessor fluentValidatorPostProcessor) {
        this.fluentValidatorPostProcessor = fluentValidatorPostProcessor;
    }
}

