/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.fluentvalidator.support;

import com.baidu.unbiz.fluentvalidator.util.LocaleUtil;
import com.baidu.unbiz.fluentvalidator.util.Preconditions;
import java.util.Locale;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

public class MessageSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageSupport.class);
    private static MessageSource messageSource;
    private static String locale;
    private static Locale localeContext;

    @PostConstruct
    public void prepare() {
        Preconditions.checkNotNull((Object)messageSource, (Object)"MessageSource should not be null");
        LOGGER.info(this.getClass().getSimpleName() + " has been initialized properly");
        localeContext = LocaleUtil.parseLocale(locale);
    }

    public static String getText(String code) {
        return MessageSupport.getText(code, null);
    }

    public static String getText(String code, Object ... args) {
        return MessageSupport.getText(code, args, localeContext);
    }

    public static String getText(String code, Object[] args, Locale locale) {
        Preconditions.checkState((messageSource != null ? 1 : 0) != 0, (Object)"If i18n is enabled, please make sure MessageSource is properly set as a member in MessageSupport");
        return messageSource.getMessage(code, args, locale);
    }

    public void setMessageSource(MessageSource messageSource) {
        MessageSupport.messageSource = messageSource;
    }

    public void setLocale(String locale) {
        MessageSupport.locale = locale;
    }
}

