/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.fluentvalidator.util;

import com.baidu.unbiz.fluentvalidator.exception.ClassInstantiationException;
import java.util.HashMap;
import java.util.Map;

public class ClassUtil {
    private static final Map<String, PrimitiveInfo<?>> PRIMITIVES = new HashMap(13);

    public static <T> T newInstance(Class<T> clazz) throws ClassInstantiationException {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ClassInstantiationException("Failed to instantiate class: " + clazz.getName(), e);
        }
    }

    public static <T> Class<T> getWrapperTypeIfPrimitive(Class<T> type) {
        if (type == null) {
            return null;
        }
        if (type.isPrimitive()) {
            return ClassUtil.PRIMITIVES.get((Object)type.getName()).wrapperType;
        }
        return type;
    }

    private static <T> void addPrimitive(Class<T> type, String typeCode, Class<T> wrapperType, String unwrapMethod, T defaultValue, T maxValue, T minValue) {
        PrimitiveInfo<T> info = new PrimitiveInfo<T>(type, typeCode, wrapperType, unwrapMethod, defaultValue, maxValue, minValue);
        PRIMITIVES.put(type.getName(), info);
        PRIMITIVES.put(wrapperType.getName(), info);
    }

    static {
        ClassUtil.addPrimitive(Boolean.TYPE, "Z", Boolean.class, "booleanValue", false, Boolean.FALSE, Boolean.TRUE);
        ClassUtil.addPrimitive(Short.TYPE, "S", Short.class, "shortValue", (short)0, (short)Short.MAX_VALUE, (short)Short.MIN_VALUE);
        ClassUtil.addPrimitive(Integer.TYPE, "I", Integer.class, "intValue", 0, Integer.MAX_VALUE, Integer.MIN_VALUE);
        ClassUtil.addPrimitive(Long.TYPE, "J", Long.class, "longValue", 0L, Long.MAX_VALUE, Long.MIN_VALUE);
        ClassUtil.addPrimitive(Float.TYPE, "F", Float.class, "floatValue", Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE));
        ClassUtil.addPrimitive(Double.TYPE, "D", Double.class, "doubleValue", 0.0, Double.MAX_VALUE, Double.MIN_VALUE);
        ClassUtil.addPrimitive(Character.TYPE, "C", Character.class, "charValue", Character.valueOf('\u0000'), Character.valueOf('\uffff'), Character.valueOf('\u0000'));
        ClassUtil.addPrimitive(Byte.TYPE, "B", Byte.class, "byteValue", (byte)0, (byte)127, (byte)-128);
        ClassUtil.addPrimitive(Void.TYPE, "V", Void.class, null, null, null, null);
    }

    private static class PrimitiveInfo<T> {
        final Class<T> type;
        final String typeCode;
        final Class<T> wrapperType;
        final String unwrapMethod;
        final T defaultValue;
        final T maxValue;
        final T minValue;

        public PrimitiveInfo(Class<T> type, String typeCode, Class<T> wrapperType, String unwrapMethod, T defaultValue, T maxValue, T minValue) {
            this.type = type;
            this.typeCode = typeCode;
            this.wrapperType = wrapperType;
            this.unwrapMethod = unwrapMethod;
            this.defaultValue = defaultValue;
            this.maxValue = maxValue;
            this.minValue = minValue;
        }
    }
}

