/*
 * Copyright (C) 2020 Baidu, Inc. All Rights Reserved.
 */
package com.baidubce.http.handler;

import com.baidubce.http.BceHttpResponse;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.model.ApiExplorerResponseMetadata;

/**
 * HTTP response handler for API Explorer responses. Provides all headers.
 */
public class ApiExplorerMetaResponseHandler implements HttpResponseHandler {

    @Override
    public boolean handle(BceHttpResponse httpResponse, AbstractBceResponse response) {
        if (response.getMetadata() instanceof ApiExplorerResponseMetadata) {
            ApiExplorerResponseMetadata metadata = (ApiExplorerResponseMetadata) response.getMetadata();
            metadata.setHeaders(httpResponse.getHeaders());
        }
        return false;
    }
}
