/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;

public class ApiExplorerRequest {
    private InternalRequest internalRequest;

    public ApiExplorerRequest(HttpMethodName httpMethodName, String path) {
        URI uri = URI.create(path);
        this.internalRequest = new InternalRequest(httpMethodName, uri);
    }

    public InternalRequest getInternalRequest() {
        return this.internalRequest;
    }

    public void setInternalRequest(InternalRequest internalRequest) {
        this.internalRequest = internalRequest;
    }

    public void setCredentials(String accessKey, String secretKey) {
        DefaultBceCredentials credentials = new DefaultBceCredentials(accessKey, secretKey);
        this.internalRequest.setCredentials((BceCredentials)credentials);
    }

    public void addQueryParameter(String key, String value) {
        this.internalRequest.addParameter(key, value);
    }

    public void addHeaderParameter(String key, String value) {
        this.internalRequest.addHeader(key, value);
    }

    public void setJsonBody(String jsonBody) {
        if (this.internalRequest.getHttpMethod() == HttpMethodName.POST || this.internalRequest.getHttpMethod() == HttpMethodName.PUT || this.internalRequest.getHttpMethod() == HttpMethodName.PATCH) {
            byte[] requestJson = jsonBody.getBytes(StandardCharsets.UTF_8);
            this.internalRequest.setContent(RestartableInputStream.wrap((byte[])requestJson));
        }
    }
}

