/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.appbuilder.console.knowledgebase;

import com.baidubce.appbuilder.base.component.Component;
import com.baidubce.appbuilder.base.exception.AppBuilderServerException;
import com.baidubce.appbuilder.base.utils.http.HttpResponse;
import com.baidubce.appbuilder.base.utils.json.JsonUtils;
import com.baidubce.appbuilder.model.knowledgebase.ChunkCreateRequest;
import com.baidubce.appbuilder.model.knowledgebase.ChunkCreateResponse;
import com.baidubce.appbuilder.model.knowledgebase.ChunkDeleteRequest;
import com.baidubce.appbuilder.model.knowledgebase.ChunkDescribeRequest;
import com.baidubce.appbuilder.model.knowledgebase.ChunkDescribeResponse;
import com.baidubce.appbuilder.model.knowledgebase.ChunkModifyRequest;
import com.baidubce.appbuilder.model.knowledgebase.ChunksDescribeRequest;
import com.baidubce.appbuilder.model.knowledgebase.ChunksDescribeResponse;
import com.baidubce.appbuilder.model.knowledgebase.Document;
import com.baidubce.appbuilder.model.knowledgebase.DocumentAddRequest;
import com.baidubce.appbuilder.model.knowledgebase.DocumentAddResponse;
import com.baidubce.appbuilder.model.knowledgebase.DocumentDeleteRequest;
import com.baidubce.appbuilder.model.knowledgebase.DocumentDeleteResponse;
import com.baidubce.appbuilder.model.knowledgebase.DocumentListRequest;
import com.baidubce.appbuilder.model.knowledgebase.DocumentListResponse;
import com.baidubce.appbuilder.model.knowledgebase.DocumentsCreateRequest;
import com.baidubce.appbuilder.model.knowledgebase.FileUploadResponse;
import com.baidubce.appbuilder.model.knowledgebase.KnowledgeBaseDetail;
import com.baidubce.appbuilder.model.knowledgebase.KnowledgeBaseDetailRequest;
import com.baidubce.appbuilder.model.knowledgebase.KnowledgeBaseListRequest;
import com.baidubce.appbuilder.model.knowledgebase.KnowledgeBaseListResponse;
import com.baidubce.appbuilder.model.knowledgebase.KnowledgeBaseModifyRequest;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class Knowledgebase
extends Component {
    public Knowledgebase() {
    }

    public Knowledgebase(String SecretKey) {
        super(SecretKey);
    }

    public String uploadFile(String filePath) throws IOException, AppBuilderServerException {
        String url = "/file";
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.LEGACY).setCharset(StandardCharsets.UTF_8);
        builder.addBinaryBody("file", new File(filePath));
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, builder.build());
        HttpResponse response = this.httpClient.execute(postRequest, (Type)((Object)FileUploadResponse.class));
        FileUploadResponse respBody = (FileUploadResponse)response.getBody();
        if (respBody.getCode() != null) {
            throw new AppBuilderServerException(response.getRequestId(), response.getCode(), response.getMessage(), respBody.toString());
        }
        return respBody.getId();
    }

    public String[] addDocument(DocumentAddRequest req) throws IOException, AppBuilderServerException {
        String url = "/knowledge_base/document";
        String jsonBody = JsonUtils.serialize(req);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        HttpResponse response = this.httpClient.execute(postRequest, (Type)((Object)DocumentAddResponse.class));
        DocumentAddResponse respBody = (DocumentAddResponse)response.getBody();
        if (respBody.getCode() != null) {
            throw new AppBuilderServerException(response.getRequestId(), response.getCode(), response.getMessage(), respBody.toString());
        }
        return respBody.getDocumentIds();
    }

    public Document[] getDocumentList(DocumentListRequest request) throws IOException, AppBuilderServerException {
        String url = "/knowledge_base/documents";
        ClassicHttpRequest getRequest = this.httpClient.createGetRequestV2(url, request.toMap());
        getRequest.setHeader("Content-Type", (Object)"application/json");
        HttpResponse response = this.httpClient.execute(getRequest, (Type)((Object)DocumentListResponse.class));
        DocumentListResponse respBody = (DocumentListResponse)response.getBody();
        return respBody.getData();
    }

    public void deleteDocument(DocumentDeleteRequest request) throws IOException, AppBuilderServerException {
        String url = "/knowledge_base/document";
        ClassicHttpRequest getRequest = this.httpClient.createDeleteRequestV2(url, request.toMap());
        getRequest.setHeader("Content-Type", (Object)"application/json");
        HttpResponse response = this.httpClient.execute(getRequest, (Type)((Object)DocumentDeleteResponse.class));
        DocumentDeleteResponse respBody = (DocumentDeleteResponse)response.getBody();
        if (respBody.getCode() != null) {
            throw new AppBuilderServerException(response.getRequestId(), response.getCode(), response.getMessage(), respBody.toString());
        }
    }

    public KnowledgeBaseDetail createKnowledgeBase(KnowledgeBaseDetail request) throws IOException, AppBuilderServerException {
        String url = "/knowledgeBase?Action=CreateKnowledgeBase";
        String jsonBody = JsonUtils.serialize(request);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        HttpResponse response = this.httpClient.execute(postRequest, (Type)((Object)KnowledgeBaseDetail.class));
        KnowledgeBaseDetail respBody = (KnowledgeBaseDetail)response.getBody();
        return respBody;
    }

    public KnowledgeBaseDetail getKnowledgeBaseDetail(String knowledgeBaseId) throws IOException, AppBuilderServerException {
        String url = "/knowledgeBase?Action=DescribeKnowledgeBase";
        KnowledgeBaseDetailRequest request = new KnowledgeBaseDetailRequest();
        request.setKnowledgeBaseId(knowledgeBaseId);
        String jsonBody = JsonUtils.serialize(request);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        HttpResponse response = this.httpClient.execute(postRequest, (Type)((Object)KnowledgeBaseDetail.class));
        KnowledgeBaseDetail respBody = (KnowledgeBaseDetail)response.getBody();
        return respBody;
    }

    public void deleteKnowledgeBase(String knowledgeBaseId) throws IOException, AppBuilderServerException {
        String url = "/knowledgeBase?Action=DeleteKnowledgeBase";
        KnowledgeBaseDetailRequest request = new KnowledgeBaseDetailRequest();
        request.setKnowledgeBaseId(knowledgeBaseId);
        String jsonBody = JsonUtils.serialize(request);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        this.httpClient.execute(postRequest, null);
    }

    public void modifyKnowledgeBase(KnowledgeBaseModifyRequest request) throws IOException, AppBuilderServerException {
        String url = "/knowledgeBase?Action=ModifyKnowledgeBase";
        String jsonBody = JsonUtils.serialize(request);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        this.httpClient.execute(postRequest, null);
    }

    public KnowledgeBaseListResponse getKnowledgeBaseList(KnowledgeBaseListRequest request) throws IOException, AppBuilderServerException {
        String url = "/knowledgeBase?Action=DescribeKnowledgeBases";
        String jsonBody = JsonUtils.serialize(request);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        HttpResponse response = this.httpClient.execute(postRequest, (Type)((Object)KnowledgeBaseListResponse.class));
        KnowledgeBaseListResponse respBody = (KnowledgeBaseListResponse)response.getBody();
        return respBody;
    }

    public void createDocuments(DocumentsCreateRequest request) throws IOException, AppBuilderServerException {
        String url = "/knowledgeBase?Action=CreateDocuments";
        String jsonBody = JsonUtils.serialize(request);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        this.httpClient.execute(postRequest, null);
    }

    public void uploadDocuments(String filePath, DocumentsCreateRequest request) throws IOException, AppBuilderServerException {
        String url = "/knowledgeBase?Action=UploadDocuments";
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.LEGACY).setCharset(StandardCharsets.UTF_8);
        builder.addBinaryBody("file", new File(filePath));
        String jsonBody = JsonUtils.serialize(request);
        builder.addTextBody("payload", jsonBody);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, builder.build());
        this.httpClient.execute(postRequest, null);
    }

    public String createChunk(String documentId, String content) throws IOException, AppBuilderServerException {
        String url = "/knowledgeBase?Action=CreateChunk";
        ChunkCreateRequest request = new ChunkCreateRequest(documentId, content);
        String jsonBody = JsonUtils.serialize(request);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        HttpResponse response = this.httpClient.execute(postRequest, (Type)((Object)ChunkCreateResponse.class));
        ChunkCreateResponse respBody = (ChunkCreateResponse)response.getBody();
        return respBody.getChunkId();
    }

    public void modifyChunk(String chunkId, String content, boolean enable) throws IOException, AppBuilderServerException {
        String url = "/knowledgeBase?Action=ModifyChunk";
        ChunkModifyRequest request = new ChunkModifyRequest(chunkId, content, enable);
        String jsonBody = JsonUtils.serialize(request);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        this.httpClient.execute(postRequest, (Type)((Object)ChunkCreateResponse.class));
    }

    public void deleteChunk(String chunkId) throws IOException, AppBuilderServerException {
        String url = "/knowledgeBase?Action=DeleteChunk";
        ChunkDeleteRequest request = new ChunkDeleteRequest();
        request.setChunkId(chunkId);
        String jsonBody = JsonUtils.serialize(request);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        this.httpClient.execute(postRequest, (Type)((Object)ChunkCreateResponse.class));
    }

    public ChunkDescribeResponse describeChunk(String chunkId) throws IOException, AppBuilderServerException {
        String url = "/knowledgeBase?Action=DescribeChunk";
        ChunkDescribeRequest request = new ChunkDescribeRequest();
        request.setChunkId(chunkId);
        String jsonBody = JsonUtils.serialize(request);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        HttpResponse response = this.httpClient.execute(postRequest, (Type)((Object)ChunkDescribeResponse.class));
        ChunkDescribeResponse respBody = (ChunkDescribeResponse)response.getBody();
        return respBody;
    }

    public ChunksDescribeResponse describeChunks(String documentId, String marker, Integer maxKeys, String type) throws IOException, AppBuilderServerException {
        String url = "/knowledgeBase?Action=DescribeChunks";
        ChunksDescribeRequest request = new ChunksDescribeRequest(documentId, marker, maxKeys, type);
        String jsonBody = JsonUtils.serialize(request);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        HttpResponse response = this.httpClient.execute(postRequest, (Type)((Object)ChunksDescribeResponse.class));
        ChunksDescribeResponse respBody = (ChunksDescribeResponse)response.getBody();
        return respBody;
    }
}

