/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.appbuilder.console.agentbuilder;

import com.baidubce.appbuilder.base.component.Component;
import com.baidubce.appbuilder.base.exception.AppBuilderServerException;
import com.baidubce.appbuilder.base.utils.http.HttpResponse;
import com.baidubce.appbuilder.base.utils.json.JsonUtils;
import com.baidubce.appbuilder.model.agentbuilder.AgentBuilderIterator;
import com.baidubce.appbuilder.model.agentbuilder.AgentBuilderResponse;
import com.baidubce.appbuilder.model.agentbuilder.ConversationResponse;
import com.baidubce.appbuilder.model.agentbuilder.FileUploadResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class AgentBuilder
extends Component {
    public String appID;

    @Deprecated
    public AgentBuilder(String appID) {
        this.appID = appID;
    }

    @Deprecated
    public AgentBuilder(String appID, String secretKey) {
        super(secretKey);
        this.appID = appID;
    }

    @Deprecated
    public AgentBuilder(String appID, String secretKey, String gateway) {
        super(secretKey, gateway);
        this.appID = appID;
    }

    public String createConversation() throws IOException, AppBuilderServerException {
        String url = "/app/conversation";
        if (this.appID == null || this.appID.isEmpty()) {
            throw new RuntimeException("Param 'appID' is required!");
        }
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("app_id", this.appID);
        String jsonBody = JsonUtils.serialize(requestBody);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        HttpResponse response = this.httpClient.execute(postRequest, (Type)((Object)ConversationResponse.class));
        ConversationResponse respBody = (ConversationResponse)response.getBody();
        return respBody.getConversationId();
    }

    public String uploadLocalFile(String conversationId, String filePath) throws IOException, AppBuilderServerException {
        String url = "/app/conversation/file/upload";
        if (this.appID == null || this.appID.isEmpty()) {
            throw new RuntimeException("Param 'appID' is required!");
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.LEGACY).setCharset(StandardCharsets.UTF_8);
        builder.addBinaryBody("file", new File(filePath));
        builder.addTextBody("app_id", this.appID);
        builder.addTextBody("conversation_id", conversationId);
        builder.addTextBody("scenario", "assistant");
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, builder.build());
        HttpResponse response = this.httpClient.execute(postRequest, (Type)((Object)FileUploadResponse.class));
        FileUploadResponse respBody = (FileUploadResponse)response.getBody();
        return respBody.getFileId();
    }

    public AgentBuilderIterator run(String query, String conversationId, String[] fileIds, boolean stream) throws IOException, AppBuilderServerException {
        String url = "/app/conversation/runs";
        if (this.appID == null || this.appID.isEmpty()) {
            throw new RuntimeException("Param 'appID' is required!");
        }
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("app_id", this.appID);
        requestBody.put("query", query);
        requestBody.put("conversation_id", conversationId);
        requestBody.put("file_ids", fileIds);
        requestBody.put("stream", stream);
        String jsonBody = JsonUtils.serialize(requestBody);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(url, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        HttpResponse response = this.httpClient.executeSSE(postRequest, (Type)((Object)AgentBuilderResponse.class));
        return new AgentBuilderIterator(response.getBody());
    }
}

