/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.appbuilder.console.rag;

import com.baidubce.appbuilder.base.component.Component;
import com.baidubce.appbuilder.base.exception.AppBuilderServerException;
import com.baidubce.appbuilder.base.utils.http.HttpResponse;
import com.baidubce.appbuilder.base.utils.json.JsonUtils;
import com.baidubce.appbuilder.model.rag.RAGIterator;
import com.baidubce.appbuilder.model.rag.RAGResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class RAG
extends Component {
    public String appID;

    public RAG(String appID) {
        this.appID = appID;
    }

    public RAG(String appID, String secretKey) {
        super(secretKey);
        this.appID = appID;
    }

    public RAG(String appID, String secretKey, String gateway) {
        super(secretKey, gateway);
        this.appID = appID;
    }

    public RAGIterator run(String query, String conversationId, boolean stream) throws IOException, AppBuilderServerException {
        String url = "/api/v1/ai_engine/agi_platform/v1/instance/integrated";
        if (this.appID == null || this.appID.isEmpty()) {
            throw new RuntimeException("Param 'appID' is required!");
        }
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("app_id", this.appID);
        requestBody.put("query", query);
        requestBody.put("conversation_id", conversationId);
        requestBody.put("response_mode", stream ? "streaming" : "blocking");
        String jsonBody = JsonUtils.serialize(requestBody);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequest(url, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        HttpResponse<Iterator<RAGResponse>> response = this.httpClient.executeSSE(postRequest, (Type)((Object)RAGResponse.class));
        return new RAGIterator(response);
    }
}

