/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.appbuilder.base.utils.http;

import com.baidubce.appbuilder.base.component.Component;
import com.baidubce.appbuilder.base.exception.AppBuilderServerException;
import com.baidubce.appbuilder.base.utils.http.HttpResponse;
import com.baidubce.appbuilder.base.utils.iterator.StreamIterator;
import com.baidubce.appbuilder.base.utils.json.JsonUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class HttpClient {
    public String SecretKey;
    public String Gateway;
    public String GatewayV2;
    public String ConsoleOpenAPIVersion;
    public String ConsoleOpenAPIPrefix;
    private final CloseableHttpClient client;
    private static final Logger LOGGER = Logger.getLogger(Component.class.getName());

    public HttpClient(String secretKey, String gateway, String gatewayV2) {
        RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout(300L, TimeUnit.SECONDS).build();
        this.client = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
        this.SecretKey = secretKey;
        this.Gateway = gateway;
        this.GatewayV2 = gatewayV2;
        ConsoleHandler handler = new ConsoleHandler();
        String systemLogLevel = System.getProperty("APPBUILDER_LOGLEVEL");
        if (systemLogLevel == null || systemLogLevel.isEmpty()) {
            systemLogLevel = System.getenv("APPBUILDER_LOGLEVEL");
        }
        if (systemLogLevel == null || systemLogLevel.isEmpty()) {
            LOGGER.setLevel(Level.INFO);
            handler.setLevel(Level.INFO);
        } else {
            switch (systemLogLevel.toLowerCase()) {
                case "debug": {
                    LOGGER.setLevel(Level.FINE);
                    handler.setLevel(Level.FINE);
                    break;
                }
                case "warning": {
                    LOGGER.setLevel(Level.WARNING);
                    handler.setLevel(Level.WARNING);
                    break;
                }
                case "error": {
                    LOGGER.setLevel(Level.SEVERE);
                    handler.setLevel(Level.SEVERE);
                    break;
                }
                default: {
                    LOGGER.setLevel(Level.INFO);
                    handler.setLevel(Level.INFO);
                }
            }
        }
        LOGGER.addHandler(handler);
        String systemLogFile = System.getProperty("APPBUILDER_LOGFILE");
        if (systemLogFile == null || systemLogFile.isEmpty()) {
            systemLogFile = System.getenv("APPBUILDER_LOGFILE");
        }
        if (systemLogFile != null && !systemLogFile.isEmpty()) {
            try {
                FileHandler fileHandler = new FileHandler(systemLogFile);
                LOGGER.addHandler(fileHandler);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create log file: " + systemLogFile, e);
            }
        }
    }

    public ClassicHttpRequest createPostRequest(String url, HttpEntity entity) {
        String requestURL = this.Gateway + url;
        LOGGER.log(Level.FINE, "requestURL: " + requestURL);
        HttpPost httpPost = new HttpPost(requestURL);
        httpPost.setHeader("X-Appbuilder-Authorization", (Object)this.SecretKey);
        httpPost.setHeader("X-Appbuilder-Origin", (Object)"appbuilder_sdk");
        String platform = System.getenv("APPBUILDER_SDK_PLATFORM") != null ? System.getenv("APPBUILDER_SDK_PLATFORM") : "unknown";
        httpPost.setHeader("X-Appbuilder-Sdk-Config", (Object)("{\"appbuilder_sdk_version\":\"0.9.5\",\"appbuilder_sdk_language\":\"java\",\"appbuilder_sdk_platform\":\"" + platform + "\"}"));
        httpPost.setHeader("X-Appbuilder-Request-Id", (Object)UUID.randomUUID().toString());
        httpPost.setEntity(entity);
        String headers = "headers: \n";
        for (Header header : httpPost.getHeaders()) {
            headers = headers + header + "\n";
        }
        LOGGER.log(Level.FINE, "\n" + headers);
        return httpPost;
    }

    public ClassicHttpRequest createPostRequestV2(String url, HttpEntity entity) {
        String requestURL = this.GatewayV2 + this.ConsoleOpenAPIPrefix + this.ConsoleOpenAPIVersion + url;
        LOGGER.log(Level.FINE, "requestURL: " + requestURL);
        HttpPost httpPost = new HttpPost(requestURL);
        httpPost.setHeader("Authorization", (Object)this.SecretKey);
        httpPost.setHeader("X-Appbuilder-Origin", (Object)"appbuilder_sdk");
        String platform = System.getenv("APPBUILDER_SDK_PLATFORM") != null ? System.getenv("APPBUILDER_SDK_PLATFORM") : "unknown";
        httpPost.setHeader("X-Appbuilder-Sdk-Config", (Object)("{\"appbuilder_sdk_version\":\"0.9.5\",\"appbuilder_sdk_language\":\"java\",\"appbuilder_sdk_platform\":\"" + platform + "\"}"));
        httpPost.setHeader("X-Appbuilder-Request-Id", (Object)UUID.randomUUID().toString());
        httpPost.setEntity(entity);
        String headers = "headers: \n";
        for (Header header : httpPost.getHeaders()) {
            headers = headers + header + "\n";
        }
        LOGGER.log(Level.FINE, "\n" + headers);
        return httpPost;
    }

    public ClassicHttpRequest createGetRequestV2(String url, Map<String, Object> map) {
        String urlParams = this.toQueryString(map);
        String requestURL = this.GatewayV2 + this.ConsoleOpenAPIPrefix + this.ConsoleOpenAPIVersion + url + "?" + urlParams;
        LOGGER.log(Level.FINE, "requestURL: " + requestURL);
        HttpGet httpGet = new HttpGet(requestURL);
        httpGet.setHeader("Authorization", (Object)this.SecretKey);
        httpGet.setHeader("X-Appbuilder-Origin", (Object)"appbuilder_sdk");
        String platform = System.getenv("APPBUILDER_SDK_PLATFORM") != null ? System.getenv("APPBUILDER_SDK_PLATFORM") : "unknown";
        httpGet.setHeader("X-Appbuilder-Sdk-Config", (Object)("{\"appbuilder_sdk_version\":\"0.9.5\",\"appbuilder_sdk_language\":\"java\",\"appbuilder_sdk_platform\":\"" + platform + "\"}"));
        httpGet.setHeader("X-Appbuilder-Request-Id", (Object)UUID.randomUUID().toString());
        String headers = "headers: \n";
        for (Header header : httpGet.getHeaders()) {
            headers = headers + header + "\n";
        }
        LOGGER.log(Level.FINE, "\n" + headers);
        return httpGet;
    }

    public ClassicHttpRequest createDeleteRequestV2(String url, Map<String, Object> map) {
        String urlParams = this.toQueryString(map);
        String requestURL = this.GatewayV2 + this.ConsoleOpenAPIPrefix + this.ConsoleOpenAPIVersion + url + (url.contains("?") ? "&" : "?") + urlParams;
        LOGGER.log(Level.FINE, "requestURL: " + requestURL);
        HttpDelete httpDelete = new HttpDelete(requestURL);
        httpDelete.setHeader("Authorization", (Object)this.SecretKey);
        httpDelete.setHeader("X-Appbuilder-Origin", (Object)"appbuilder_sdk");
        String platform = System.getenv("APPBUILDER_SDK_PLATFORM") != null ? System.getenv("APPBUILDER_SDK_PLATFORM") : "unknown";
        httpDelete.setHeader("X-Appbuilder-Sdk-Config", (Object)("{\"appbuilder_sdk_version\":\"0.9.5\",\"appbuilder_sdk_language\":\"java\",\"appbuilder_sdk_platform\":\"" + platform + "\"}"));
        httpDelete.setHeader("X-Appbuilder-Request-Id", (Object)UUID.randomUUID().toString());
        String headers = "headers: \n";
        for (Header header : httpDelete.getHeaders()) {
            headers = headers + header + "\n";
        }
        LOGGER.log(Level.FINE, "\n" + headers);
        return httpDelete;
    }

    public <T> HttpResponse<T> execute(ClassicHttpRequest request, Type bodyType) throws IOException, AppBuilderServerException {
        HttpResponse httpResponse;
        if (LOGGER.getLevel() == Level.FINE) {
            this.buildCurlCommand(request);
        }
        if ((httpResponse = (HttpResponse)this.client.execute(request, resp -> {
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            for (Header header : resp.getHeaders()) {
                headers.put(header.getName(), header.getValue());
            }
            String requestId = (String)headers.get("X-Appbuilder-Request-Id");
            String stringBody = EntityUtils.toString((HttpEntity)resp.getEntity());
            HttpResponse response = new HttpResponse().setCode(resp.getCode()).setMessage(resp.getReasonPhrase()).setRequestId(requestId).setHeaders(headers).setStringBody(stringBody);
            if (resp.getCode() == 200 && bodyType != null) {
                response.setBody(JsonUtils.deserialize(stringBody, bodyType));
            }
            return response;
        })).getCode() != 200) {
            throw new AppBuilderServerException(httpResponse.getRequestId(), httpResponse.getCode(), httpResponse.getMessage(), httpResponse.getStringBody());
        }
        return httpResponse;
    }

    public <T> HttpResponse<Iterator<T>> executeSSE(ClassicHttpRequest request, Type bodyType) throws IOException, AppBuilderServerException {
        if (LOGGER.getLevel() == Level.FINE) {
            this.buildCurlCommand(request);
        }
        CloseableHttpResponse resp = this.client.execute(request);
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        for (Header header : resp.getHeaders()) {
            headers.put(header.getName(), header.getValue());
        }
        String requestId = (String)headers.get("X-Appbuilder-Request-Id");
        if (resp.getCode() != 200) {
            String stringBody = "";
            try {
                stringBody = EntityUtils.toString((HttpEntity)resp.getEntity());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            throw new AppBuilderServerException(requestId, resp.getCode(), resp.getReasonPhrase(), stringBody);
        }
        return new HttpResponse().setCode(resp.getCode()).setMessage(resp.getReasonPhrase()).setRequestId(requestId).setHeaders(headers).setBody(new StreamIterator(resp, bodyType));
    }

    private String toQueryString(Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append('&');
            }
            try {
                stringBuilder.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                stringBuilder.append('=');
                stringBuilder.append(URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
            }
            catch (Exception exception) {}
        }
        return stringBuilder.toString();
    }

    private void buildCurlCommand(ClassicHttpRequest request) {
        HttpEntity entity;
        StringBuilder curlCmd = new StringBuilder("curl");
        curlCmd.append(" -X ").append(request.getMethod());
        curlCmd.append(" -L");
        try {
            curlCmd.append(" ").append("'").append(request.getUri()).append("'").append(" \\\n");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Invalid URL: ", e);
        }
        for (Header header : request.getHeaders()) {
            curlCmd.append("-H '").append(header.getName()).append(": ").append(header.getValue()).append("'");
            curlCmd.append(" \\\n");
        }
        if ("GET".equals(request.getMethod()) || "DELETE".equals(request.getMethod())) {
            curlCmd = new StringBuilder(curlCmd.toString().replaceAll(" \\\\\n$", ""));
        }
        if ((entity = request.getEntity()) != null && entity.isRepeatable()) {
            try {
                String body = EntityUtils.toString((HttpEntity)entity);
                curlCmd.append(" -d '").append(body).append("'");
            }
            catch (IOException | ParseException throwable) {
                // empty catch block
            }
        }
        LOGGER.log(Level.FINE, "Curl Command: \n" + curlCmd.toString() + "\n");
    }
}

