/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientException;
import com.baidubce.BceServiceException;
import com.baidubce.auth.BceV1Signer;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableFileInputStream;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.internal.RestartableMultiByteArrayInputStream;
import com.baidubce.internal.RestartableNonResettableInputStream;
import com.baidubce.internal.RestartableResettableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.User;
import com.baidubce.services.bos.BosClientConfiguration;
import com.baidubce.services.bos.BosMetadataResponseHandler;
import com.baidubce.services.bos.BosObjectInputStream;
import com.baidubce.services.bos.BosObjectResponseHandler;
import com.baidubce.services.bos.model.AbortMultipartUploadRequest;
import com.baidubce.services.bos.model.AllowedMethods;
import com.baidubce.services.bos.model.AppendObjectRequest;
import com.baidubce.services.bos.model.AppendObjectResponse;
import com.baidubce.services.bos.model.BosObject;
import com.baidubce.services.bos.model.BosObjectSummary;
import com.baidubce.services.bos.model.BosResponse;
import com.baidubce.services.bos.model.BucketEncryption;
import com.baidubce.services.bos.model.CannedAccessControlList;
import com.baidubce.services.bos.model.CompleteMultipartUploadRequest;
import com.baidubce.services.bos.model.CompleteMultipartUploadResponse;
import com.baidubce.services.bos.model.CopyObjectRequest;
import com.baidubce.services.bos.model.CopyObjectResponse;
import com.baidubce.services.bos.model.CopyObjectResponseWithExceptionInfo;
import com.baidubce.services.bos.model.CorsConfiguration;
import com.baidubce.services.bos.model.CreateBucketRequest;
import com.baidubce.services.bos.model.CreateBucketResponse;
import com.baidubce.services.bos.model.DeleteBucketCopyrightProtectionRequest;
import com.baidubce.services.bos.model.DeleteBucketCorsRequest;
import com.baidubce.services.bos.model.DeleteBucketEncryptionRequest;
import com.baidubce.services.bos.model.DeleteBucketLifecycleRequest;
import com.baidubce.services.bos.model.DeleteBucketLoggingRequest;
import com.baidubce.services.bos.model.DeleteBucketRequest;
import com.baidubce.services.bos.model.DeleteBucketStaticWebsiteRequest;
import com.baidubce.services.bos.model.DeleteMultipleObjectsRequest;
import com.baidubce.services.bos.model.DeleteMultipleObjectsResponse;
import com.baidubce.services.bos.model.DeleteObjectAclRequest;
import com.baidubce.services.bos.model.DeleteObjectRequest;
import com.baidubce.services.bos.model.DoesBucketExistRequest;
import com.baidubce.services.bos.model.FetchObjectRequest;
import com.baidubce.services.bos.model.FetchObjectResponse;
import com.baidubce.services.bos.model.GeneratePresignedUrlRequest;
import com.baidubce.services.bos.model.GenericBucketRequest;
import com.baidubce.services.bos.model.GenericObjectRequest;
import com.baidubce.services.bos.model.GetBosAccountOwnerRequest;
import com.baidubce.services.bos.model.GetBucketAclRequest;
import com.baidubce.services.bos.model.GetBucketAclResponse;
import com.baidubce.services.bos.model.GetBucketCopyrightProtectionRequest;
import com.baidubce.services.bos.model.GetBucketCopyrightProtectionResponse;
import com.baidubce.services.bos.model.GetBucketCorsRequest;
import com.baidubce.services.bos.model.GetBucketCorsResponse;
import com.baidubce.services.bos.model.GetBucketEncryptionRequest;
import com.baidubce.services.bos.model.GetBucketEncryptionResponse;
import com.baidubce.services.bos.model.GetBucketLifecycleRequest;
import com.baidubce.services.bos.model.GetBucketLifecycleResponse;
import com.baidubce.services.bos.model.GetBucketLocationRequest;
import com.baidubce.services.bos.model.GetBucketLocationResponse;
import com.baidubce.services.bos.model.GetBucketLoggingRequest;
import com.baidubce.services.bos.model.GetBucketLoggingResponse;
import com.baidubce.services.bos.model.GetBucketStaticWebsiteRequest;
import com.baidubce.services.bos.model.GetBucketStaticWebsiteResponse;
import com.baidubce.services.bos.model.GetObjectAclRequest;
import com.baidubce.services.bos.model.GetObjectAclResponse;
import com.baidubce.services.bos.model.GetObjectMetadataRequest;
import com.baidubce.services.bos.model.GetObjectRequest;
import com.baidubce.services.bos.model.GetObjectResponse;
import com.baidubce.services.bos.model.Grant;
import com.baidubce.services.bos.model.Grantee;
import com.baidubce.services.bos.model.InitiateMultipartUploadRequest;
import com.baidubce.services.bos.model.InitiateMultipartUploadResponse;
import com.baidubce.services.bos.model.ListBucketsRequest;
import com.baidubce.services.bos.model.ListBucketsResponse;
import com.baidubce.services.bos.model.ListMultipartUploadsRequest;
import com.baidubce.services.bos.model.ListMultipartUploadsResponse;
import com.baidubce.services.bos.model.ListObjectsRequest;
import com.baidubce.services.bos.model.ListObjectsResponse;
import com.baidubce.services.bos.model.ListPartsRequest;
import com.baidubce.services.bos.model.ListPartsResponse;
import com.baidubce.services.bos.model.ObjectMetadata;
import com.baidubce.services.bos.model.PartETag;
import com.baidubce.services.bos.model.Permission;
import com.baidubce.services.bos.model.PutObjectRequest;
import com.baidubce.services.bos.model.PutObjectResponse;
import com.baidubce.services.bos.model.PutSuperObjectRequest;
import com.baidubce.services.bos.model.ResponseHeaderOverrides;
import com.baidubce.services.bos.model.RestoreObjectRequest;
import com.baidubce.services.bos.model.Rule;
import com.baidubce.services.bos.model.SetBucketAclRequest;
import com.baidubce.services.bos.model.SetBucketCopyrightProtectionRequest;
import com.baidubce.services.bos.model.SetBucketCorsRequest;
import com.baidubce.services.bos.model.SetBucketEncryptionRequest;
import com.baidubce.services.bos.model.SetBucketLifecycleRequest;
import com.baidubce.services.bos.model.SetBucketLoggingRequest;
import com.baidubce.services.bos.model.SetBucketStaticWebsiteRequest;
import com.baidubce.services.bos.model.SetObjectAclRequest;
import com.baidubce.services.bos.model.UploadPartCopyRequest;
import com.baidubce.services.bos.model.UploadPartCopyResponse;
import com.baidubce.services.bos.model.UploadPartRequest;
import com.baidubce.services.bos.model.UploadPartResponse;
import com.baidubce.util.HashUtils;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.MD5DigestCalculatingInputStream;
import com.baidubce.util.Mimetypes;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BosClient
extends AbstractBceClient {
    private static Logger logger = LoggerFactory.getLogger(BosClient.class);
    private static final HttpResponseHandler[] bos_handlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BosMetadataResponseHandler(), new BceErrorResponseHandler(), new BosObjectResponseHandler(), new BceJsonResponseHandler()};
    public static final String STORAGE_CLASS_STANDARD = "STANDARD";
    public static final String STORAGE_CLASS_STANDARD_IA = "STANDARD_IA";
    public static final String STORAGE_CLASS_COLD = "COLD";
    public static final String STORAGE_CLASS_ARCHIVE = "ARCHIVE";
    public static final String RESTORE_TIER_STANDARD = "Standard";
    public static final String RESTORE_TIER_EXPEDITED = "Expedited";
    private static final String[] HEADERS_TO_SIGN = new String[]{"Host"};
    private static final long CHUNK_SIZE = 0x500000L;

    public BosClient() {
        this(new BosClientConfiguration());
    }

    public BosClient(BosClientConfiguration clientConfiguration) {
        super(clientConfiguration, bos_handlers, clientConfiguration.isEnableHttpAsyncPut());
    }

    public User getBosAccountOwner() {
        return this.getBosAccountOwner(new GetBosAccountOwnerRequest());
    }

    public User getBosAccountOwner(GetBosAccountOwnerRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        return this.invokeHttpClient(this.createRequest(request, HttpMethodName.GET), ListBucketsResponse.class).getOwner();
    }

    public ListBucketsResponse listBuckets() {
        return this.listBuckets(new ListBucketsRequest());
    }

    public ListBucketsResponse listBuckets(ListBucketsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        return this.invokeHttpClient(this.createRequest(request, HttpMethodName.GET), ListBucketsResponse.class);
    }

    public CreateBucketResponse createBucket(String bucketName) {
        return this.createBucket(new CreateBucketRequest(bucketName));
    }

    public CreateBucketResponse createBucket(CreateBucketRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT);
        this.setZeroContentLength(internalRequest);
        BosResponse response = this.invokeHttpClient(internalRequest, BosResponse.class);
        CreateBucketResponse result = new CreateBucketResponse();
        result.setName(request.getBucketName());
        result.setLocation(response.getMetadata().getLocation());
        return result;
    }

    public boolean doesBucketExist(String bucketName) {
        return this.doesBucketExist(new DoesBucketExistRequest(bucketName));
    }

    public boolean doesBucketExist(DoesBucketExistRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        try {
            this.invokeHttpClient(this.createRequest(request, HttpMethodName.HEAD), BosResponse.class);
            return true;
        }
        catch (BceServiceException e) {
            if (e.getStatusCode() == 403) {
                return true;
            }
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    public GetBucketAclResponse getBucketAcl(String bucketName) {
        return this.getBucketAcl(new GetBucketAclRequest(bucketName));
    }

    public GetBucketAclResponse getBucketAcl(GetBucketAclRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET);
        internalRequest.addParameter("acl", null);
        GetBucketAclResponse response = this.invokeHttpClient(internalRequest, GetBucketAclResponse.class);
        if (response.getVersion() > 1) {
            throw new BceClientException("Unsupported acl version.");
        }
        return response;
    }

    public GetBucketLocationResponse getBucketLocation(String bucketName) {
        return this.getBucketLocation(new GetBucketLocationRequest(bucketName));
    }

    public GetBucketLocationResponse getBucketLocation(GetBucketLocationRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET);
        internalRequest.addParameter("location", null);
        GetBucketLocationResponse response = this.invokeHttpClient(internalRequest, GetBucketLocationResponse.class);
        return response;
    }

    public void setBucketAcl(String bucketName, String jsonAcl) {
        this.setBucketAcl(new SetBucketAclRequest(bucketName, jsonAcl));
    }

    public void setBucketAcl(String bucketName, CannedAccessControlList acl) {
        this.setBucketAcl(new SetBucketAclRequest(bucketName, acl));
    }

    public void setBucketAcl(SetBucketAclRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT);
        internalRequest.addParameter("acl", null);
        if (request.getCannedAcl() != null) {
            internalRequest.addHeader("x-bce-acl", request.getCannedAcl().toString());
            this.setZeroContentLength(internalRequest);
        } else if (request.getAccessControlList() != null) {
            byte[] json = null;
            List<Grant> grants = request.getAccessControlList();
            StringWriter writer = new StringWriter();
            try {
                JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
                jsonGenerator.writeStartObject();
                jsonGenerator.writeArrayFieldStart("accessControlList");
                for (Grant grant : grants) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeArrayFieldStart("grantee");
                    for (Grantee grantee : grant.getGrantee()) {
                        jsonGenerator.writeStartObject();
                        jsonGenerator.writeStringField("id", grantee.getId());
                        jsonGenerator.writeEndObject();
                    }
                    jsonGenerator.writeEndArray();
                    jsonGenerator.writeArrayFieldStart("permission");
                    for (Permission permission : grant.getPermission()) {
                        jsonGenerator.writeString(permission.toString());
                    }
                    jsonGenerator.writeEndArray();
                    if (grant.getResource() != null) {
                        jsonGenerator.writeArrayFieldStart("resource");
                        for (String resource : grant.getResource()) {
                            jsonGenerator.writeString(resource);
                        }
                        jsonGenerator.writeEndArray();
                    }
                    if (grant.getNotResource() != null) {
                        jsonGenerator.writeArrayFieldStart("notResource");
                        for (String notResource : grant.getNotResource()) {
                            jsonGenerator.writeString(notResource);
                        }
                        jsonGenerator.writeEndArray();
                    }
                    if (grant.getCondition() != null && grant.getCondition().getReferer() != null && (grant.getCondition().getReferer().getStringLike() != null || grant.getCondition().getReferer().getStringEquals() != null)) {
                        jsonGenerator.writeObjectFieldStart("condition");
                        jsonGenerator.writeObjectFieldStart("referer");
                        if (grant.getCondition().getReferer().getStringLike() != null) {
                            jsonGenerator.writeArrayFieldStart("stringLike");
                            for (String stringLike : grant.getCondition().getReferer().getStringLike()) {
                                jsonGenerator.writeString(stringLike);
                            }
                            jsonGenerator.writeEndArray();
                        }
                        if (grant.getCondition().getReferer().getStringEquals() != null) {
                            jsonGenerator.writeArrayFieldStart("stringEquals");
                            for (String stringEquals : grant.getCondition().getReferer().getStringEquals()) {
                                jsonGenerator.writeString(stringEquals);
                            }
                            jsonGenerator.writeEndArray();
                        }
                        jsonGenerator.writeEndObject();
                        if (grant.getCondition().getIpAddress() != null) {
                            jsonGenerator.writeArrayFieldStart("ipAddress");
                            for (String ipAddress : grant.getCondition().getIpAddress()) {
                                jsonGenerator.writeString(ipAddress);
                            }
                            jsonGenerator.writeEndArray();
                        }
                        jsonGenerator.writeBooleanField("secureTransport", grant.getCondition().isSecureTransport());
                        jsonGenerator.writeEndObject();
                    }
                    if (grant.getCondition() != null && grant.getCondition().getReferer() == null && grant.getCondition().getIpAddress() != null) {
                        jsonGenerator.writeObjectFieldStart("condition");
                        jsonGenerator.writeArrayFieldStart("ipAddress");
                        for (String ipAddress : grant.getCondition().getIpAddress()) {
                            jsonGenerator.writeString(ipAddress);
                        }
                        jsonGenerator.writeEndArray();
                        jsonGenerator.writeBooleanField("secureTransport", grant.getCondition().isSecureTransport());
                        jsonGenerator.writeEndObject();
                    }
                    if (grant.getCondition() != null && grant.getCondition().getReferer() == null && grant.getCondition().getIpAddress() == null) {
                        jsonGenerator.writeObjectFieldStart("condition");
                        jsonGenerator.writeBooleanField("secureTransport", grant.getCondition().isSecureTransport());
                        jsonGenerator.writeEndObject();
                    }
                    if (grant.getEffect() != null) {
                        jsonGenerator.writeStringField("effect", grant.getEffect());
                    }
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndArray();
                jsonGenerator.writeEndObject();
                jsonGenerator.close();
            }
            catch (IOException e) {
                throw new BceClientException("Fail to generate json", e);
            }
            try {
                json = writer.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        } else if (request.getJsonAcl() != null) {
            byte[] json = null;
            try {
                json = request.getJsonAcl().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        } else {
            Preconditions.checkNotNull(null, (Object)"request.acl should not be null.");
        }
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public void setBucketLogging(SetBucketLoggingRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT);
        internalRequest.addParameter("logging", null);
        if (request.getJsonPutBucketLogging() != null) {
            byte[] json = null;
            try {
                json = request.getJsonPutBucketLogging().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        } else {
            byte[] json = null;
            StringWriter writer = new StringWriter();
            try {
                JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("targetBucket", request.getTargetBucket());
                if (request.getTargetPrefix() != null) {
                    jsonGenerator.writeStringField("targetPrefix", request.getTargetPrefix());
                }
                jsonGenerator.writeEndObject();
                jsonGenerator.close();
            }
            catch (IOException e) {
                throw new BceClientException("Fail to generate json", e);
            }
            try {
                json = writer.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        }
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public GetBucketLoggingResponse getBucketLogging(GetBucketLoggingRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET);
        internalRequest.addParameter("logging", null);
        internalRequest.addHeader("Content-Type", "application/json");
        GetBucketLoggingResponse response = this.invokeHttpClient(internalRequest, GetBucketLoggingResponse.class);
        return response;
    }

    public void deleteBucketLogging(DeleteBucketLoggingRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE);
        internalRequest.addParameter("logging", null);
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public void setBucketCors(SetBucketCorsRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT);
        internalRequest.addParameter("cors", null);
        if (request.getJsonBucketCors() != null) {
            byte[] json = null;
            try {
                json = request.getJsonBucketCors().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        } else if (request.getCorsConfigurationsList() != null) {
            byte[] json = null;
            List<CorsConfiguration> corsConfigurations = request.getCorsConfigurationsList();
            StringWriter writer = new StringWriter();
            try {
                JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
                jsonGenerator.writeStartObject();
                jsonGenerator.writeArrayFieldStart("corsConfiguration");
                for (CorsConfiguration corsConfiguration : corsConfigurations) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeArrayFieldStart("allowedOrigins");
                    for (String allowOrigin : corsConfiguration.getAllowedOrigins()) {
                        jsonGenerator.writeString(allowOrigin);
                    }
                    jsonGenerator.writeEndArray();
                    jsonGenerator.writeArrayFieldStart("allowedMethods");
                    for (AllowedMethods allowedMethod : corsConfiguration.getAllowedMethods()) {
                        jsonGenerator.writeString(allowedMethod.toString());
                    }
                    jsonGenerator.writeEndArray();
                    jsonGenerator.writeArrayFieldStart("allowedHeaders");
                    if (corsConfiguration.getAllowedHeaders() != null) {
                        for (String allowHead : corsConfiguration.getAllowedHeaders()) {
                            jsonGenerator.writeString(allowHead);
                        }
                    }
                    jsonGenerator.writeEndArray();
                    jsonGenerator.writeArrayFieldStart("allowedExposeHeaders");
                    if (corsConfiguration.getAllowedExposeHeaders() != null) {
                        for (String allowedExposeHeader : corsConfiguration.getAllowedExposeHeaders()) {
                            jsonGenerator.writeString(allowedExposeHeader);
                        }
                    }
                    jsonGenerator.writeEndArray();
                    jsonGenerator.writeNumberField("maxAgeSeconds", corsConfiguration.getMaxAgeSeconds());
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndArray();
                jsonGenerator.writeEndObject();
                jsonGenerator.close();
            }
            catch (IOException e) {
                throw new BceClientException("Fail to generate json", e);
            }
            try {
                json = writer.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        } else {
            Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        }
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public GetBucketCorsResponse getBucketCros(GetBucketCorsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET);
        internalRequest.addParameter("cors", null);
        GetBucketCorsResponse response = this.invokeHttpClient(internalRequest, GetBucketCorsResponse.class);
        return response;
    }

    public void deleteBucketCors(DeleteBucketCorsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE);
        internalRequest.addParameter("cors", null);
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public void setBucketBucketLifecycle(SetBucketLifecycleRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT);
        internalRequest.addParameter("lifecycle", null);
        if (request.getJsonBucketLifecycle() != null) {
            byte[] json = null;
            try {
                json = request.getJsonBucketLifecycle().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        } else if (request.getRuleList() != null) {
            byte[] json = null;
            List<Rule> rules = request.getRuleList();
            StringWriter writer = new StringWriter();
            try {
                JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
                jsonGenerator.writeStartObject();
                jsonGenerator.writeArrayFieldStart("rule");
                for (Rule rule : rules) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeStringField("id", rule.getId());
                    jsonGenerator.writeStringField("status", rule.getStatus());
                    jsonGenerator.writeArrayFieldStart("resource");
                    for (String resource : rule.getResource()) {
                        jsonGenerator.writeString(resource);
                    }
                    jsonGenerator.writeEndArray();
                    jsonGenerator.writeObjectFieldStart("condition");
                    jsonGenerator.writeObjectFieldStart("time");
                    jsonGenerator.writeStringField("dateGreaterThan", rule.getCondition().getTime().getDateGreaterThan());
                    jsonGenerator.writeEndObject();
                    jsonGenerator.writeEndObject();
                    jsonGenerator.writeObjectFieldStart("action");
                    jsonGenerator.writeStringField("name", rule.getAction().getName());
                    if (rule.getAction().getStorageClass() != null) {
                        jsonGenerator.writeStringField("storageClass", rule.getAction().getStorageClass());
                    }
                    jsonGenerator.writeEndObject();
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndArray();
                jsonGenerator.writeEndObject();
                jsonGenerator.close();
            }
            catch (IOException e) {
                throw new BceClientException("Fail to generate json", e);
            }
            try {
                json = writer.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        } else {
            Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        }
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public GetBucketLifecycleResponse getBucketLifecycle(GetBucketLifecycleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET);
        internalRequest.addParameter("lifecycle", null);
        GetBucketLifecycleResponse response = this.invokeHttpClient(internalRequest, GetBucketLifecycleResponse.class);
        return response;
    }

    public void deleteBucketLifecycle(DeleteBucketLifecycleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE);
        internalRequest.addParameter("lifecycle", null);
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public void deleteBucket(String bucketName) {
        this.deleteBucket(new DeleteBucketRequest(bucketName));
    }

    public void deleteBucket(DeleteBucketRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        this.invokeHttpClient(this.createRequest(request, HttpMethodName.DELETE), BosResponse.class);
    }

    public URL generatePresignedUrl(String bucketName, String key, int expirationInSeconds) {
        return this.generatePresignedUrl(bucketName, key, expirationInSeconds, HttpMethodName.GET);
    }

    public URL generatePresignedUrl(String bucketName, String key, int expirationInSeconds, HttpMethodName method) {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key, method);
        request.setExpiration(expirationInSeconds);
        return this.generatePresignedUrl(request);
    }

    public URL generatePresignedUrl(GeneratePresignedUrlRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"The request parameter must be specified when generating a pre-signed URL");
        HttpMethodName httpMethod = HttpMethodName.valueOf(request.getMethod().toString());
        String bucketName = ((BosClientConfiguration)this.config).isCnameEnabled() ? null : request.getBucketName();
        InternalRequest internalRequest = new InternalRequest(httpMethod, HttpUtils.appendUri(this.getEndpoint(), "v1", bucketName, request.getKey()));
        internalRequest.setCredentials(request.getRequestCredentials());
        SignOptions options = new SignOptions();
        options.setExpirationInSeconds(request.getExpiration());
        if (httpMethod != HttpMethodName.GET && httpMethod != HttpMethodName.HEAD) {
            options.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        }
        for (Map.Entry<String, String> entry : request.getRequestHeaders().entrySet()) {
            if (entry.getValue() == null) {
                internalRequest.addHeader(entry.getKey(), "");
                continue;
            }
            internalRequest.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : request.getRequestParameters().entrySet()) {
            if (entry.getValue() == null) {
                internalRequest.addParameter(entry.getKey(), "");
                continue;
            }
            internalRequest.addParameter(entry.getKey(), entry.getValue());
        }
        if (request.getContentType() != null) {
            internalRequest.addHeader("Content-Type", request.getContentType());
        }
        if (request.getContentMd5() != null) {
            internalRequest.addHeader("Content-MD5", request.getContentMd5());
        }
        this.addResponseHeaderParameters(internalRequest, request.getResponseHeaders());
        BceV1Signer signer = new BceV1Signer();
        signer.sign(internalRequest, this.config.getCredentials(), options);
        return this.convertRequestToUrl(internalRequest);
    }

    public ListObjectsResponse listObjects(String bucketName) {
        return this.listObjects(new ListObjectsRequest(bucketName));
    }

    public ListObjectsResponse listObjects(String bucketName, String prefix) {
        return this.listObjects(new ListObjectsRequest(bucketName, prefix));
    }

    public ListObjectsResponse listObjects(ListObjectsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET);
        if (request.getPrefix() != null) {
            internalRequest.addParameter("prefix", request.getPrefix());
        }
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getDelimiter() != null) {
            internalRequest.addParameter("delimiter", request.getDelimiter());
        }
        if (request.getMaxKeys() >= 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        ListObjectsResponse response = this.invokeHttpClient(internalRequest, ListObjectsResponse.class);
        response.setBucketName(request.getBucketName());
        List<BosObjectSummary> contents = response.getContents();
        for (BosObjectSummary object : contents) {
            object.setBucketName(request.getBucketName());
        }
        return response;
    }

    public ListObjectsResponse listNextBatchOfObjects(ListObjectsResponse previousResponse) {
        Preconditions.checkNotNull((Object)previousResponse, (Object)"previousResponse should not be null.");
        if (!previousResponse.isTruncated()) {
            ListObjectsResponse emptyResponse = new ListObjectsResponse();
            emptyResponse.setBucketName(previousResponse.getBucketName());
            emptyResponse.setDelimiter(previousResponse.getDelimiter());
            emptyResponse.setMarker(previousResponse.getNextMarker());
            emptyResponse.setMaxKeys(previousResponse.getMaxKeys());
            emptyResponse.setPrefix(previousResponse.getPrefix());
            emptyResponse.setTruncated(false);
            return emptyResponse;
        }
        return this.listObjects(new ListObjectsRequest(previousResponse.getBucketName()).withPrefix(previousResponse.getPrefix()).withMarker(previousResponse.getNextMarker()).withDelimiter(previousResponse.getDelimiter()).withMaxKeys(previousResponse.getMaxKeys()));
    }

    public BosObject getObject(String bucketName, String key) {
        return this.getObject(new GetObjectRequest(bucketName, key));
    }

    public ObjectMetadata getObject(String bucketName, String key, File destinationFile) {
        return this.getObject(new GetObjectRequest(bucketName, key), destinationFile);
    }

    public BosObject getObject(GetObjectRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET);
        long[] range = request.getRange();
        if (range != null) {
            internalRequest.addHeader("Range", "bytes=" + range[0] + "-" + range[1]);
        }
        GetObjectResponse response = this.invokeHttpClient(internalRequest, GetObjectResponse.class);
        BosObject bosObject = response.getObject();
        bosObject.setBucketName(request.getBucketName());
        bosObject.setKey(request.getKey());
        return bosObject;
    }

    public ObjectMetadata getObject(GetObjectRequest request, File destinationFile) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)destinationFile, (Object)"destinationFile should not be null.");
        BosObject bosObject = this.getObject(request);
        this.downloadObjectToFile(bosObject, destinationFile, request.getRange() == null);
        return bosObject.getObjectMetadata();
    }

    public byte[] getObjectContent(String bucketName, String key) {
        return this.getObjectContent(new GetObjectRequest(bucketName, key));
    }

    public byte[] getObjectContent(GetObjectRequest request) {
        BosObjectInputStream content = this.getObject(request).getObjectContent();
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)content);
            return byArray;
        }
        catch (IOException e) {
            throw new BceClientException("Fail read object content", e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean doesObjectExist(String bucketName, String key) {
        try {
            this.getObjectMetadata(bucketName, key);
            return true;
        }
        catch (BceServiceException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    public ObjectMetadata getObjectMetadata(String bucketName, String key) {
        return this.getObjectMetadata(new GetObjectMetadataRequest(bucketName, key));
    }

    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        return this.invokeHttpClient(this.createRequest(request, HttpMethodName.HEAD), GetObjectResponse.class).getObject().getObjectMetadata();
    }

    public PutObjectResponse putObject(String bucketName, String key, File file) {
        return this.putObject(new PutObjectRequest(bucketName, key, file));
    }

    public PutObjectResponse putObject(String bucketName, String key, File file, ObjectMetadata metadata) {
        return this.putObject(new PutObjectRequest(bucketName, key, file, metadata));
    }

    public PutObjectResponse putObject(String bucketName, String key, String value) {
        try {
            return this.putObject(bucketName, key, value.getBytes("UTF-8"), new ObjectMetadata());
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get bytes.", e);
        }
    }

    public PutObjectResponse putObject(String bucketName, String key, String value, ObjectMetadata metadata) {
        try {
            return this.putObject(bucketName, key, value.getBytes("UTF-8"), metadata);
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get bytes.", e);
        }
    }

    public PutObjectResponse putObject(String bucketName, String key, byte[] value) {
        return this.putObject(bucketName, key, value, new ObjectMetadata());
    }

    public PutObjectResponse putObject(String bucketName, String key, byte[] value, ObjectMetadata metadata) {
        if (metadata.getContentLength() == -1L) {
            metadata.setContentLength(value.length);
        }
        return this.putObject(new PutObjectRequest(bucketName, key, RestartableInputStream.wrap(value), metadata));
    }

    public PutObjectResponse putObject(String bucketName, String key, InputStream input) {
        return this.putObject(new PutObjectRequest(bucketName, key, input));
    }

    public PutObjectResponse putObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) {
        return this.putObject(new PutObjectRequest(bucketName, key, input, metadata));
    }

    public PutObjectResponse putObject(PutObjectRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        this.assertStringNotNullOrEmpty(request.getKey(), "object key should not be null or empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT);
        BosResponse response = this.uploadObject(request, internalRequest);
        PutObjectResponse result = new PutObjectResponse();
        result.setETag(response.getMetadata().getETag());
        return result;
    }

    public CopyObjectResponse copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) {
        return this.copyObject(new CopyObjectRequest(sourceBucketName, sourceKey, destinationBucketName, destinationKey));
    }

    public CopyObjectResponse copyObject(CopyObjectRequest request) {
        ObjectMetadata newObjectMetadata;
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        this.assertStringNotNullOrEmpty(request.getSourceKey(), "object key should not be null or empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT);
        String copySourceHeader = "/" + request.getSourceBucketName() + "/" + request.getSourceKey();
        copySourceHeader = HttpUtils.normalizePath(copySourceHeader);
        internalRequest.addHeader("x-bce-copy-source", copySourceHeader);
        if (request.getETag() != null) {
            internalRequest.addHeader("x-bce-copy-source-if-match", "\"" + request.getETag() + "\"");
        }
        if (request.getNoneMatchETagConstraint() != null) {
            internalRequest.addHeader("x-bce-copy-source-if-none-match", "\"" + request.getNoneMatchETagConstraint() + "\"");
        }
        if (request.getUnmodifiedSinceConstraint() != null) {
            internalRequest.addHeader("x-bce-copy-source-if-unmodified-since", request.getUnmodifiedSinceConstraint());
        }
        if (request.getModifiedSinceConstraint() != null) {
            internalRequest.addHeader("x-bce-copy-source-if-modified-since", request.getModifiedSinceConstraint());
        }
        if (request.getStorageClass() != null) {
            internalRequest.addHeader("x-bce-storage-class", request.getStorageClass());
        }
        if ((newObjectMetadata = request.getNewObjectMetadata()) != null) {
            internalRequest.addHeader("x-bce-metadata-directive", "replace");
            BosClient.populateRequestMetadata(internalRequest, newObjectMetadata);
        } else {
            internalRequest.addHeader("x-bce-metadata-directive", "copy");
        }
        this.setZeroContentLength(internalRequest);
        CopyObjectResponseWithExceptionInfo intermidiateRes = this.invokeHttpClient(internalRequest, CopyObjectResponseWithExceptionInfo.class);
        if (intermidiateRes.getETag() == null && intermidiateRes.getLastModified() == null && intermidiateRes.getMessage() != null) {
            BceServiceException bse = new BceServiceException(intermidiateRes.getMessage());
            bse.setErrorCode(intermidiateRes.getCode());
            bse.setRequestId(intermidiateRes.getRequestId());
            if (bse.getErrorCode() == "InternalError") {
                bse.setErrorType(BceServiceException.ErrorType.Service);
            } else {
                bse.setErrorType(BceServiceException.ErrorType.Client);
            }
            bse.setStatusCode(500);
            throw bse;
        }
        return intermidiateRes;
    }

    public FetchObjectResponse fetchObject(String bucketName, String key, String sourceUrl) {
        FetchObjectRequest request = new FetchObjectRequest(bucketName, key, sourceUrl);
        return this.fetchObject(request);
    }

    public FetchObjectResponse fetchObject(String bucketName, String key, String sourceUrl, String mode) {
        FetchObjectRequest request = new FetchObjectRequest(bucketName, key, sourceUrl).withMode(mode);
        return this.fetchObject(request);
    }

    public FetchObjectResponse fetchObject(FetchObjectRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        this.assertStringNotNullOrEmpty(request.getSourceUrl(), "source should not be null or empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("fetch", null);
        internalRequest.addHeader("x-bce-fetch-source", request.getSourceUrl());
        if (request.getMode() != null) {
            internalRequest.addHeader("x-bce-fetch-mode", request.getMode());
        }
        if (request.getStorageClass() != null) {
            internalRequest.addHeader("x-bce-storage-class", request.getStorageClass());
        }
        this.setZeroContentLength(internalRequest);
        FetchObjectResponse response = this.invokeHttpClient(internalRequest, FetchObjectResponse.class);
        return response;
    }

    public void deleteObject(String bucketName, String key) {
        this.deleteObject(new DeleteObjectRequest(bucketName, key));
    }

    public void deleteObject(DeleteObjectRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        this.assertStringNotNullOrEmpty(request.getKey(), "object key should not be null or empty");
        this.invokeHttpClient(this.createRequest(request, HttpMethodName.DELETE), BosResponse.class);
    }

    public DeleteMultipleObjectsResponse deleteMultipleObjects(DeleteMultipleObjectsRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("delete", "");
        if (request.getJsonDeleteObjects() != null) {
            byte[] json = null;
            try {
                json = request.getJsonDeleteObjects().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        } else if (request.getObjectKeys() != null) {
            if (request.getObjectKeys().size() > 1000) {
                throw new BceClientException("The delete objects number must not more than 1000.");
            }
            List<String> objectKeys = request.getObjectKeys();
            byte[] json = null;
            StringWriter writer = new StringWriter();
            try {
                JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
                jsonGenerator.writeStartObject();
                jsonGenerator.writeArrayFieldStart("objects");
                for (String object : objectKeys) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeStringField("key", object);
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndArray();
                jsonGenerator.writeEndObject();
                jsonGenerator.close();
            }
            catch (IOException e) {
                throw new BceClientException("Fail to generate json", e);
            }
            try {
                json = writer.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        } else {
            Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        }
        DeleteMultipleObjectsResponse response = this.invokeHttpClient(internalRequest, DeleteMultipleObjectsResponse.class);
        return response;
    }

    public void setObjectAcl(String bucketName, String objectKey, String jsonObjectAcl) {
        this.setObjectAcl(new SetObjectAclRequest(bucketName, objectKey, jsonObjectAcl));
    }

    public void setObjectAcl(String bucketName, String objectKey, CannedAccessControlList acl) {
        this.setObjectAcl(new SetObjectAclRequest(bucketName, objectKey, acl));
    }

    public void setObjectAcl(SetObjectAclRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT);
        internalRequest.addParameter("acl", null);
        if (request.getCannedAcl() != null) {
            internalRequest.addHeader("x-bce-acl", request.getCannedAcl().toString());
            this.setZeroContentLength(internalRequest);
        } else if (request.getAccessControlList() != null) {
            byte[] json = null;
            List<Grant> grants = request.getAccessControlList();
            StringWriter writer = new StringWriter();
            try {
                JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
                jsonGenerator.writeStartObject();
                jsonGenerator.writeArrayFieldStart("accessControlList");
                for (Grant grant : grants) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeArrayFieldStart("grantee");
                    for (Grantee grantee : grant.getGrantee()) {
                        jsonGenerator.writeStartObject();
                        jsonGenerator.writeStringField("id", grantee.getId());
                        jsonGenerator.writeEndObject();
                    }
                    jsonGenerator.writeEndArray();
                    jsonGenerator.writeArrayFieldStart("permission");
                    for (Permission permission : grant.getPermission()) {
                        jsonGenerator.writeString(permission.toString());
                    }
                    jsonGenerator.writeEndArray();
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndArray();
                jsonGenerator.writeEndObject();
                jsonGenerator.close();
            }
            catch (IOException e) {
                throw new BceClientException("Fail to generate json", e);
            }
            try {
                json = writer.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        } else if (request.getJsonObjectAcl() != null) {
            byte[] json = null;
            try {
                json = request.getJsonObjectAcl().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        } else if (request.getxBceGrantRead() != null) {
            internalRequest.addHeader("x-bce-grant-read", request.getxBceGrantRead());
            this.setZeroContentLength(internalRequest);
        } else if (request.getxBceGrantFullControl() != null) {
            internalRequest.addHeader("x-bce-grant-full-control", request.getxBceGrantFullControl());
            this.setZeroContentLength(internalRequest);
        } else {
            Preconditions.checkNotNull(null, (Object)"request.acl should not be null.");
        }
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public GetObjectAclResponse getObjectAcl(GetObjectAclRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        this.assertStringNotNullOrEmpty(request.getKey(), "object key should not be null or empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET);
        internalRequest.addParameter("acl", null);
        GetObjectAclResponse response = this.invokeHttpClient(internalRequest, GetObjectAclResponse.class);
        if (response.getVersion() > 1) {
            throw new BceClientException("Unsupported acl version.");
        }
        return response;
    }

    public void deleteObjectAcl(DeleteObjectAclRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        this.assertStringNotNullOrEmpty(request.getKey(), "object key should not be null or empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE);
        internalRequest.addParameter("acl", null);
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public InitiateMultipartUploadResponse initiateMultipartUpload(String bucketName, String key) {
        return this.initiateMultipartUpload(new InitiateMultipartUploadRequest(bucketName, key));
    }

    public InitiateMultipartUploadResponse initiateMultipartUpload(InitiateMultipartUploadRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("uploads", null);
        if (request.getStorageClass() != null) {
            internalRequest.addHeader("x-bce-storage-class", request.getStorageClass());
        }
        this.setZeroContentLength(internalRequest);
        if (request.getObjectMetadata() != null) {
            BosClient.populateRequestMetadata(internalRequest, request.getObjectMetadata());
        }
        return this.invokeHttpClient(internalRequest, InitiateMultipartUploadResponse.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadPartResponse uploadPart(UploadPartRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)request.getPartSize(), (Object)"partSize should not be null");
        Preconditions.checkNotNull((Object)request.getPartNumber(), (Object)"partNumber should not be null");
        if (request.getPartSize() > 0x140000000L) {
            throw new BceClientException("PartNumber " + request.getPartNumber() + " : Part Size should not be more than 5GB.");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT);
        internalRequest.addParameter("uploadId", request.getUploadId());
        internalRequest.addParameter("partNumber", String.valueOf(request.getPartNumber()));
        internalRequest.addHeader("Content-Length", String.valueOf(request.getPartSize()));
        if (request.getxBceCrc() != null) {
            internalRequest.addHeader("x-bce-content-crc32", String.valueOf(request.getxBceCrc()));
        }
        InputStream input = request.getInputStream();
        MD5DigestCalculatingInputStream md5DigestStream = null;
        if (request.getMd5Digest() == null) {
            try {
                md5DigestStream = new MD5DigestCalculatingInputStream(input);
                input = md5DigestStream;
            }
            catch (NoSuchAlgorithmException e) {
                logger.warn("Unable to verify data integrity.", (Throwable)e);
            }
        }
        try {
            internalRequest.setContent(this.wrapRestartableInputStream(input));
            BosResponse response = this.invokeHttpClient(internalRequest, BosResponse.class);
            if (md5DigestStream != null) {
                byte[] serverSideHash;
                byte[] clientSideHash = md5DigestStream.getMd5Digest();
                try {
                    serverSideHash = Hex.decodeHex((char[])response.getMetadata().getETag().toCharArray());
                }
                catch (Exception e) {
                    throw new BceClientException("Unable to verify integrity of data upload.", e);
                }
                if (!Arrays.equals(clientSideHash, serverSideHash)) {
                    throw new BceClientException("Unable to verify integrity of data upload.  Client calculated content hash didn't match hash calculated by BOS.  You may need to delete the data stored in BOS.");
                }
            }
            UploadPartResponse result = new UploadPartResponse();
            result.setETag(response.getMetadata().getETag());
            result.setPartNumber(request.getPartNumber());
            UploadPartResponse uploadPartResponse = result;
            return uploadPartResponse;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public UploadPartCopyResponse uploadPartCopy(UploadPartCopyRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)request.getPartNumber(), (Object)"partNumber should not be null");
        Preconditions.checkNotNull((Object)request.getSourceBucketName(), (Object)"sourceBucketName should not be null");
        Preconditions.checkNotNull((Object)request.getSourceKey(), (Object)"sourceKey should not be null");
        if (request.getPartSize() > 0x140000000L) {
            throw new BceClientException("PartNumber " + request.getPartNumber() + " : Part Size should not be more than 5GB.");
        }
        String bceCopySource = "/" + request.getSourceBucketName() + "/" + request.getSourceKey();
        bceCopySource = HttpUtils.normalizePath(bceCopySource);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT);
        internalRequest.addParameter("uploadId", request.getUploadId());
        internalRequest.addParameter("partNumber", String.valueOf(request.getPartNumber()));
        internalRequest.addHeader("Content-Length", String.valueOf(0));
        internalRequest.addHeader("x-bce-copy-source", bceCopySource);
        if (request.getxBceCrc() != null) {
            internalRequest.addHeader("x-bce-content-crc32", String.valueOf(request.getxBceCrc()));
        }
        if (request.getPartSize() != 0L) {
            long offSet = request.getOffSet();
            long partSize = request.getPartSize();
            String bceCopySourceRange = "bytes=" + String.valueOf(offSet) + "-" + String.valueOf(offSet + partSize - 1L);
            internalRequest.addHeader("x-bce-copy-source-range", bceCopySourceRange);
        }
        UploadPartCopyResponse response = this.invokeHttpClient(internalRequest, UploadPartCopyResponse.class);
        return response;
    }

    public ListPartsResponse listParts(String bucketName, String key, String uploadId) {
        return this.listParts(new ListPartsRequest(bucketName, key, uploadId));
    }

    public ListPartsResponse listParts(ListPartsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest interrnalRequest = this.createRequest(request, HttpMethodName.GET);
        interrnalRequest.addParameter("uploadId", request.getUploadId());
        int maxParts = request.getMaxParts();
        if (maxParts >= 0) {
            interrnalRequest.addParameter("maxParts", String.valueOf(maxParts));
        }
        interrnalRequest.addParameter("partNumberMarker", String.valueOf(request.getPartNumberMarker()));
        ListPartsResponse response = this.invokeHttpClient(interrnalRequest, ListPartsResponse.class);
        response.setBucketName(request.getBucketName());
        return response;
    }

    public CompleteMultipartUploadResponse completeMultipartUpload(String bucketName, String key, String uploadId, List<PartETag> partETags) {
        return this.completeMultipartUpload(new CompleteMultipartUploadRequest(bucketName, key, uploadId, partETags));
    }

    public CompleteMultipartUploadResponse completeMultipartUpload(String bucketName, String key, String uploadId, List<PartETag> partETags, ObjectMetadata metadata) {
        return this.completeMultipartUpload(new CompleteMultipartUploadRequest(bucketName, key, uploadId, partETags, metadata));
    }

    public CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("uploadId", request.getUploadId());
        ObjectMetadata metadata = request.getObjectMetadata();
        if (metadata != null) {
            BosClient.populateRequestMetadata(internalRequest, metadata);
        }
        byte[] json = null;
        List<PartETag> partETags = request.getPartETags();
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeArrayFieldStart("parts");
            for (PartETag partETag : partETags) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeNumberField("partNumber", partETag.getPartNumber());
                jsonGenerator.writeStringField("eTag", partETag.getETag());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        try {
            json = writer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(json.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.setContent(RestartableInputStream.wrap(json));
        CompleteMultipartUploadResponse response = this.invokeHttpClient(internalRequest, CompleteMultipartUploadResponse.class);
        response.setBucketName(request.getBucketName());
        return response;
    }

    public void abortMultipartUpload(String bucketName, String key, String uploadId) {
        this.abortMultipartUpload(new AbortMultipartUploadRequest(bucketName, key, uploadId));
    }

    public void abortMultipartUpload(AbortMultipartUploadRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE);
        internalRequest.addParameter("uploadId", request.getUploadId());
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public ListMultipartUploadsResponse listMultipartUploads(String bucketName) {
        return this.listMultipartUploads(new ListMultipartUploadsRequest(bucketName));
    }

    public ListMultipartUploadsResponse listMultipartUploads(ListMultipartUploadsRequest request) {
        String prefix;
        String delimiter;
        int maxUploads;
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET);
        internalRequest.addParameter("uploads", null);
        String keyMarker = request.getKeyMarker();
        if (keyMarker != null) {
            internalRequest.addParameter("keyMarker", keyMarker);
        }
        if ((maxUploads = request.getMaxUploads()) >= 0) {
            internalRequest.addParameter("maxUploads", String.valueOf(maxUploads));
        }
        if ((delimiter = request.getDelimiter()) != null) {
            internalRequest.addParameter("delimiter", delimiter);
        }
        if ((prefix = request.getPrefix()) != null) {
            internalRequest.addParameter("prefix", prefix);
        }
        ListMultipartUploadsResponse response = this.invokeHttpClient(internalRequest, ListMultipartUploadsResponse.class);
        response.setBucketName(request.getBucketName());
        return response;
    }

    private static void populateRequestMetadata(InternalRequest request, ObjectMetadata metadata) {
        Map<String, String> userMetadata;
        if (metadata.getContentType() != null) {
            request.addHeader("Content-Type", metadata.getContentType());
        }
        if (metadata.getContentMd5() != null) {
            request.addHeader("Content-MD5", metadata.getContentMd5());
        }
        if (metadata.getContentEncoding() != null) {
            request.addHeader("Content-Encoding", metadata.getContentEncoding());
        }
        if (metadata.getBceContentSha256() != null) {
            request.addHeader("x-bce-content-sha256", metadata.getBceContentSha256());
        }
        if (metadata.getContentDisposition() != null) {
            request.addHeader("Content-Disposition", metadata.getContentDisposition());
        }
        if (metadata.getETag() != null) {
            request.addHeader("ETag", metadata.getETag());
        }
        if (metadata.getExpires() != null) {
            request.addHeader("Expires", metadata.getExpires());
        }
        if (metadata.getCacheControl() != null) {
            request.addHeader("Cache-Control", metadata.getCacheControl());
        }
        if (metadata.getStorageClass() != null) {
            request.addHeader("x-bce-storage-class", metadata.getStorageClass());
        }
        if ((userMetadata = metadata.getUserMetadata()) != null) {
            for (Map.Entry<String, String> entry : userMetadata.entrySet()) {
                String key = entry.getKey();
                if (key == null) continue;
                String value = entry.getValue();
                if (value == null) {
                    value = "";
                }
                if (key.length() + value.length() > 32768) {
                    throw new BceClientException("MetadataTooLarge");
                }
                request.addHeader("x-bce-meta-" + HttpUtils.normalize(key.trim()), HttpUtils.normalize(value));
            }
        }
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod) {
        String bucketName = null;
        String key = null;
        if (bceRequest instanceof GenericBucketRequest && !((BosClientConfiguration)this.config).isCnameEnabled()) {
            bucketName = ((GenericBucketRequest)bceRequest).getBucketName();
        }
        if (bceRequest instanceof GenericObjectRequest) {
            key = ((GenericObjectRequest)bceRequest).getKey();
        }
        InternalRequest request = new InternalRequest(httpMethod, HttpUtils.appendUri(this.getEndpoint(), "v1", bucketName, key));
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void downloadObjectToFile(BosObject bosObject, File destinationFile, boolean verifyIntegrity) {
        File parentDirectory = destinationFile.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists()) {
            parentDirectory.mkdirs();
        }
        OutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
            byte[] buffer = new byte[this.getStreamBufferSize()];
            while ((bytesRead = bosObject.getObjectContent().read(buffer)) > -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            try {
                bosObject.getObjectContent().close();
            }
            catch (IOException abortException) {
                logger.warn("Couldn't abort stream", (Throwable)abortException);
            }
            throw new BceClientException("Unable to write to disk", e);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                bosObject.getObjectContent().close();
            }
            catch (Exception exception) {}
        }
        if (verifyIntegrity) {
            byte[] serverSideHash = null;
            byte[] clientSideHash = null;
            ObjectMetadata objectMetadata = bosObject.getObjectMetadata();
            try {
                if (objectMetadata.getBceContentSha256() != null) {
                    serverSideHash = Hex.decodeHex((char[])objectMetadata.getBceContentSha256().toCharArray());
                    clientSideHash = HashUtils.computeSha256Hash(new FileInputStream(destinationFile));
                } else if (objectMetadata.getContentMd5() != null) {
                    serverSideHash = Base64.decodeBase64((byte[])objectMetadata.getContentMd5().getBytes("UTF-8"));
                    clientSideHash = HashUtils.computeMd5Hash(new FileInputStream(destinationFile));
                }
            }
            catch (Exception e) {
                logger.warn("Unable to verify the integrity of the downloaded file", (Throwable)e);
            }
            if (serverSideHash != null && clientSideHash != null && !Arrays.equals(clientSideHash, serverSideHash)) {
                throw new BceClientException("Integrity verification failed! Client calculated content hash didn't match hash from server. The data stored in '" + destinationFile.getAbsolutePath() + "' may be corrupt.");
            }
        }
    }

    private List<byte[]> readAll(InputStream input, ObjectMetadata metadata) {
        ArrayList result = Lists.newArrayList();
        int bufferSize = this.getStreamBufferSize();
        long length = 0L;
        block2: while (true) {
            byte[] buffer = new byte[bufferSize];
            result.add(buffer);
            int off = 0;
            while (true) {
                int count;
                if (off >= bufferSize) continue block2;
                try {
                    count = input.read(buffer, off, bufferSize - off);
                }
                catch (IOException e) {
                    throw new BceClientException("Fail to read data.", e);
                }
                if (count < 0) {
                    metadata.setContentLength(length);
                    return result;
                }
                length += (long)count;
                off += count;
            }
            break;
        }
    }

    private RestartableInputStream wrapRestartableInputStream(InputStream input) {
        if (input.markSupported()) {
            return new RestartableResettableInputStream(input);
        }
        return new RestartableNonResettableInputStream(input, this.getStreamBufferSize());
    }

    private void setZeroContentLength(InternalRequest req) {
        req.addHeader("Content-Length", String.valueOf(0));
    }

    private int getStreamBufferSize() {
        return ((BosClientConfiguration)this.config).getStreamBufferSize();
    }

    private void assertStringNotNullOrEmpty(String parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        if (parameterValue.isEmpty()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void addResponseHeaderParameters(InternalRequest request, ResponseHeaderOverrides responseHeaders) {
        if (responseHeaders != null) {
            if (responseHeaders.getCacheControl() != null) {
                request.addParameter("responseCacheControl", responseHeaders.getCacheControl());
            }
            if (responseHeaders.getContentDisposition() != null) {
                request.addParameter("responseContentDisposition", responseHeaders.getContentDisposition());
            }
            if (responseHeaders.getContentEncoding() != null) {
                request.addParameter("responseContentEncoding", responseHeaders.getContentEncoding());
            }
            if (responseHeaders.getContentLanguage() != null) {
                request.addParameter("responseContentLanguage", responseHeaders.getContentLanguage());
            }
            if (responseHeaders.getContentType() != null) {
                request.addParameter("responseContentType", responseHeaders.getContentType());
            }
            if (responseHeaders.getExpires() != null) {
                request.addParameter("responseExpires", responseHeaders.getExpires());
            }
        }
    }

    private URL convertRequestToUrl(InternalRequest request) {
        String resourcePath = HttpUtils.normalizePath(request.getUri().getPath());
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        String urlPath = "/" + resourcePath;
        urlPath = urlPath.replaceAll("(?<=/)/", "%2F");
        String urlString = this.getEndpoint() + urlPath;
        boolean firstParam = true;
        for (String param : request.getParameters().keySet()) {
            if (firstParam) {
                urlString = urlString + "?";
                firstParam = false;
            } else {
                urlString = urlString + "&";
            }
            String value = request.getParameters().get(param);
            urlString = urlString + param + "=" + HttpUtils.normalize(value);
        }
        String authorization = request.getHeaders().get("Authorization");
        if (authorization != null) {
            urlString = firstParam ? urlString + "?" : urlString + "&";
            urlString = urlString + "authorization=" + HttpUtils.normalize(authorization);
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new BceClientException("Unable to convert request to well formed URL: " + e.getMessage(), e);
        }
    }

    public AppendObjectResponse appendObject(String bucketName, String key, File file) {
        return this.appendObject(new AppendObjectRequest(bucketName, key, file));
    }

    public AppendObjectResponse appendObject(String bucketName, String key, File file, ObjectMetadata metadata) {
        return this.appendObject(new AppendObjectRequest(bucketName, key, file, metadata));
    }

    public AppendObjectResponse appendObject(String bucketName, String key, String value) {
        try {
            return this.appendObject(bucketName, key, value.getBytes("UTF-8"), new ObjectMetadata());
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get bytes.", e);
        }
    }

    public AppendObjectResponse appendObject(String bucketName, String key, String value, ObjectMetadata metadata) {
        try {
            return this.appendObject(bucketName, key, value.getBytes("UTF-8"), metadata);
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get bytes.", e);
        }
    }

    public AppendObjectResponse appendObject(String bucketName, String key, byte[] value) {
        return this.appendObject(bucketName, key, value, new ObjectMetadata());
    }

    public AppendObjectResponse appendObject(String bucketName, String key, byte[] value, ObjectMetadata metadata) {
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata should not be null.");
        if (metadata.getContentLength() == -1L) {
            metadata.setContentLength(value.length);
        }
        return this.appendObject(new AppendObjectRequest(bucketName, key, RestartableInputStream.wrap(value), metadata));
    }

    public AppendObjectResponse appendObject(String bucketName, String key, InputStream input) {
        return this.appendObject(new AppendObjectRequest(bucketName, key, input));
    }

    public AppendObjectResponse appendObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) {
        return this.appendObject(new AppendObjectRequest(bucketName, key, input, metadata));
    }

    public AppendObjectResponse appendObject(AppendObjectRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        this.assertStringNotNullOrEmpty(request.getKey(), "object key should not be null or empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("append", null);
        if (request.getOffset() != null) {
            internalRequest.addParameter("offset", request.getOffset().toString());
        }
        BosResponse response = this.uploadObject(request, internalRequest);
        AppendObjectResponse result = new AppendObjectResponse();
        result.setNextAppendOffset(response.getMetadata().getNextAppendOffset());
        result.setContentMd5(response.getMetadata().getContentMd5());
        result.setETag(response.getMetadata().getETag());
        return result;
    }

    public void restoreObject(RestoreObjectRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        this.assertStringNotNullOrEmpty(request.getKey(), "object key should not be null or empty");
        if (request.getRestoreDays() != null && request.getRestoreDays() <= 0) {
            throw new BceClientException("invalid restore days");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("restore", null);
        if (request.getRestoreDays() != null) {
            internalRequest.addHeader("x-bce-restore-days", Integer.toString(request.getRestoreDays()));
        }
        if (request.getRestoreTier() != null) {
            internalRequest.addHeader("x-bce-restore-tier", request.getRestoreTier());
        }
        this.setZeroContentLength(internalRequest);
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public void setBucketEncryption(String bucketName, BucketEncryption encryption) {
        this.setBucketEncryption(new SetBucketEncryptionRequest(bucketName, encryption));
    }

    public void setBucketEncryption(SetBucketEncryptionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT);
        internalRequest.addParameter("encryption", null);
        if (request.getJsonBucketEncryption() != null) {
            byte[] json = null;
            try {
                json = request.getJsonBucketEncryption().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        } else {
            byte[] json = null;
            StringWriter writer = new StringWriter();
            try {
                JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
                jsonGenerator.writeStartObject();
                if (request.getBucketEncryption() != null) {
                    jsonGenerator.writeStringField("encryptionAlgorithm", request.getBucketEncryption().getEncryptionAlgorithm());
                }
                jsonGenerator.writeEndObject();
                jsonGenerator.close();
            }
            catch (IOException e) {
                throw new BceClientException("Fail to generate json", e);
            }
            try {
                json = writer.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        }
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public GetBucketEncryptionResponse getBucketEncryption(String bucketName) {
        return this.getBucketEncryption(new GetBucketEncryptionRequest(bucketName));
    }

    public GetBucketEncryptionResponse getBucketEncryption(GetBucketEncryptionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET);
        internalRequest.addParameter("encryption", null);
        GetBucketEncryptionResponse response = this.invokeHttpClient(internalRequest, GetBucketEncryptionResponse.class);
        return response;
    }

    public void deleteBucketEncryption(String bucketName) {
        this.deleteBucketEncryption(new DeleteBucketEncryptionRequest(bucketName));
    }

    public void deleteBucketEncryption(DeleteBucketEncryptionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE);
        internalRequest.addParameter("encryption", null);
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public void setBucketStaticWebSite(String bucketName, String index, String notfound) {
        this.setBucketStaticWebSite(new SetBucketStaticWebsiteRequest(bucketName, index, notfound));
    }

    public void setBucketStaticWebSite(SetBucketStaticWebsiteRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT);
        internalRequest.addParameter("website", null);
        if (request.getJsonBucketStaticWebsite() != null) {
            byte[] json = null;
            try {
                json = request.getJsonBucketStaticWebsite().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        } else {
            byte[] json = null;
            StringWriter writer = new StringWriter();
            try {
                JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
                jsonGenerator.writeStartObject();
                if (request.getIndex() != null) {
                    jsonGenerator.writeStringField("index", request.getIndex());
                }
                if (request.getNotFound() != null) {
                    jsonGenerator.writeStringField("notFound", request.getNotFound());
                }
                jsonGenerator.writeEndObject();
                jsonGenerator.close();
            }
            catch (IOException e) {
                throw new BceClientException("Fail to generate json", e);
            }
            try {
                json = writer.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        }
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public GetBucketStaticWebsiteResponse getBucketStaticWebsite(String bucketName) {
        return this.getBucketStaticWebsite(new GetBucketStaticWebsiteRequest(bucketName));
    }

    public GetBucketStaticWebsiteResponse getBucketStaticWebsite(GetBucketStaticWebsiteRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET);
        internalRequest.addParameter("website", null);
        GetBucketStaticWebsiteResponse response = this.invokeHttpClient(internalRequest, GetBucketStaticWebsiteResponse.class);
        return response;
    }

    public void deleteBucketStaticWebSite(String bucketName) {
        this.deleteBucketStaticWebSite(new DeleteBucketStaticWebsiteRequest(bucketName));
    }

    public void deleteBucketStaticWebSite(DeleteBucketStaticWebsiteRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE);
        internalRequest.addParameter("website", null);
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public void setBucketCopyrightProtection(String bucketName, List<String> resources) {
        this.setBucketCopyrightProtection(new SetBucketCopyrightProtectionRequest(bucketName, resources));
    }

    public void setBucketCopyrightProtection(SetBucketCopyrightProtectionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT);
        internalRequest.addParameter("copyrightProtection", null);
        if (request.getJsonBucketCopyrightProtection() != null) {
            byte[] json = null;
            try {
                json = request.getJsonBucketCopyrightProtection().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        } else {
            byte[] json = null;
            StringWriter writer = new StringWriter();
            List<String> resources = request.getResource();
            try {
                JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
                jsonGenerator.writeStartObject();
                jsonGenerator.writeArrayFieldStart("resource");
                if (resources != null) {
                    for (String resource : resources) {
                        jsonGenerator.writeString(resource);
                    }
                }
                jsonGenerator.writeEndArray();
                jsonGenerator.writeEndObject();
                jsonGenerator.close();
            }
            catch (IOException e) {
                throw new BceClientException("Fail to generate json", e);
            }
            try {
                json = writer.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(json.length));
            internalRequest.addHeader("Content-Type", "application/json");
            internalRequest.setContent(RestartableInputStream.wrap(json));
        }
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    public GetBucketCopyrightProtectionResponse getBucketCopyrightProtection(String bucketName) {
        return this.getBucketCopyrightProtection(new GetBucketCopyrightProtectionRequest(bucketName));
    }

    public GetBucketCopyrightProtectionResponse getBucketCopyrightProtection(GetBucketCopyrightProtectionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET);
        internalRequest.addParameter("copyrightProtection", null);
        GetBucketCopyrightProtectionResponse response = this.invokeHttpClient(internalRequest, GetBucketCopyrightProtectionResponse.class);
        return response;
    }

    public void deleteBucketCopyrightProtection(String bucketName) {
        this.deleteBucketCopyrightProtection(new DeleteBucketCopyrightProtectionRequest(bucketName));
    }

    public void deleteBucketCopyrightProtection(DeleteBucketCopyrightProtectionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE);
        internalRequest.addParameter("copyrightProtection", null);
        this.invokeHttpClient(internalRequest, BosResponse.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BosResponse uploadObject(PutObjectRequest request, InternalRequest internalRequest) {
        BosResponse response;
        ObjectMetadata metadata = request.getObjectMetadata();
        InputStream input = request.getInputStream();
        if (request.getFile() != null) {
            File file = request.getFile();
            if (file.length() > 0x140000000L) {
                BceServiceException bse = new BceServiceException("Your proposed upload exceeds the maximum allowed object size.");
                bse.setStatusCode(400);
                bse.setErrorCode("EntityTooLarge");
                bse.setErrorType(BceServiceException.ErrorType.Client);
                throw bse;
            }
            if (metadata.getContentLength() < 0L) {
                metadata.setContentLength(file.length());
            }
            if (metadata.getContentType() == null) {
                metadata.setContentType(Mimetypes.getInstance().getMimetype(file));
            }
            if (metadata.getContentLength() == file.length()) {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    metadata.setBceContentSha256(new String(Hex.encodeHex((byte[])HashUtils.computeSha256Hash(fileInputStream))));
                }
                catch (Exception e) {
                    throw new BceClientException("Unable to calculate SHA-256 hash", e);
                }
                finally {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (Exception e) {
                        logger.warn("The inputStream accured error");
                    }
                }
            }
            try {
                internalRequest.setContent(new RestartableFileInputStream(file));
            }
            catch (FileNotFoundException e) {
                throw new BceClientException("Unable to find file to upload", e);
            }
        }
        Preconditions.checkNotNull((Object)input, (Object)"Either file or inputStream should be set.");
        if (metadata.getContentLength() < 0L) {
            logger.warn("No content length specified for stream data. Trying to read them all into memory.");
            List<byte[]> data = this.readAll(input, metadata);
            internalRequest.setContent(new RestartableMultiByteArrayInputStream(data, metadata.getContentLength()));
        } else if (input instanceof RestartableInputStream) {
            internalRequest.setContent((RestartableInputStream)input);
        } else {
            internalRequest.setContent(this.wrapRestartableInputStream(input));
        }
        if (metadata.getContentType() == null) {
            metadata.setContentType(Mimetypes.getInstance().getMimetype(request.getKey()));
        }
        if (request.getStorageClass() != null) {
            metadata.setStorageClass(request.getStorageClass());
        }
        if (metadata.getxBceCrc() != null) {
            internalRequest.addHeader("x-bce-content-crc32", String.valueOf(metadata.getxBceCrc()));
        }
        internalRequest.addHeader("Content-Length", String.valueOf(metadata.getContentLength()));
        BosClient.populateRequestMetadata(internalRequest, metadata);
        try {
            response = this.invokeHttpClient(internalRequest, BosResponse.class);
        }
        finally {
            try {
                internalRequest.getContent().close();
            }
            catch (Exception e) {
                logger.warn("Fail to close input stream", (Throwable)e);
            }
        }
        return response;
    }

    public boolean putSuperObjectFromFile(File file, String bucketName, String objectKey) {
        int processors = Runtime.getRuntime().availableProcessors();
        return this.putSuperObjectFromFile(new PutSuperObjectRequest(bucketName, objectKey, file, 0x500000L, processors));
    }

    public boolean putSuperObjectFromFile(File file, String bucketName, String objectKey, long chunksize) {
        int processors = Runtime.getRuntime().availableProcessors();
        return this.putSuperObjectFromFile(new PutSuperObjectRequest(bucketName, objectKey, file, chunksize, processors));
    }

    public boolean putSuperObjectFromFile(File file, String bucketName, String objectKey, int nThreads) {
        return this.putSuperObjectFromFile(new PutSuperObjectRequest(bucketName, objectKey, file, 0x500000L, nThreads));
    }

    public boolean putSuperObjectFromFile(File file, String bucketName, String objectKey, long chunksize, int nThreads) {
        return this.putSuperObjectFromFile(new PutSuperObjectRequest(bucketName, objectKey, file, chunksize, nThreads));
    }

    public boolean putSuperObjectFromFile(PutSuperObjectRequest putSuperObjectRequest) {
        int i;
        boolean success = true;
        File file = putSuperObjectRequest.getFile();
        long chunksize = putSuperObjectRequest.getChunkSize();
        if (chunksize <= 0L) {
            throw new BceClientException("the chunksize must be greater than 0");
        }
        String bucketName = putSuperObjectRequest.getBucketName();
        String objectKey = putSuperObjectRequest.getKey();
        int nThreads = putSuperObjectRequest.getnThreads();
        AtomicBoolean isSuperObjectUploadCanced = putSuperObjectRequest.getIsSuperObjectUploadCanced();
        long fileLength = file.length();
        int parts = (int)(fileLength / chunksize);
        if (fileLength % chunksize > 0L) {
            ++parts;
        }
        if (parts > 10000) {
            throw new BceClientException("Total parts count should not exceed 10000");
        }
        String uploadId = this.initiateMultipartUpload(bucketName, objectKey).getUploadId();
        putSuperObjectRequest.setUploadId(uploadId);
        ExecutorService pool = Executors.newFixedThreadPool(nThreads);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        List<PartETag> partETags = Collections.synchronizedList(new ArrayList());
        for (i = 0; i < parts; ++i) {
            futures.add(pool.submit(new UploadPartTask(this, putSuperObjectRequest, i, partETags)));
        }
        for (i = 0; i < futures.size(); ++i) {
            Future future = (Future)futures.get(i);
            try {
                if (((Boolean)future.get()).booleanValue()) {
                    logger.info("The upload task [ " + i + "] completed.");
                    continue;
                }
                logger.error("The upload task [ " + i + "] failed.");
                success = false;
            }
            catch (Exception e) {
                success = false;
            }
            break;
        }
        pool.shutdown();
        try {
            if (!pool.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            throw new BceClientException("close thread pool fail exception", e);
        }
        if (isSuperObjectUploadCanced.get() || partETags.size() != parts) {
            success = false;
        }
        if (success) {
            Collections.sort(partETags, new Comparator<PartETag>(){

                @Override
                public int compare(PartETag a, PartETag b) {
                    return a.getPartNumber() - b.getPartNumber();
                }
            });
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, objectKey, uploadId, partETags);
            CompleteMultipartUploadResponse response = this.completeMultipartUpload(completeMultipartUploadRequest);
            logger.info("Success to upload file: " + file.getAbsolutePath() + " to BOS with ETag: " + response.getETag());
        } else {
            AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(bucketName, objectKey, uploadId);
            this.abortMultipartUpload(abortMultipartUploadRequest);
            logger.info("Failed to upload file: " + file.getAbsolutePath());
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFilePart(PutSuperObjectRequest putSuperObjectRequest, int partNum, List<PartETag> partETags) {
        int tryCount = 3;
        File file = putSuperObjectRequest.getFile();
        long chunksize = putSuperObjectRequest.getChunkSize();
        String bucketName = putSuperObjectRequest.getBucketName();
        String objectKey = putSuperObjectRequest.getKey();
        String uploadId = putSuperObjectRequest.getUploadId();
        AtomicBoolean isCancel = putSuperObjectRequest.getIsSuperObjectUploadCanced();
        while (tryCount > 0 && !isCancel.get()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                long skipBytes = chunksize * (long)partNum;
                fis.skip(skipBytes);
                long partSize = chunksize < file.length() - skipBytes ? chunksize : file.length() - skipBytes;
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(bucketName);
                uploadPartRequest.setKey(objectKey);
                uploadPartRequest.setUploadId(uploadId);
                uploadPartRequest.setInputStream(fis);
                uploadPartRequest.setPartSize(partSize);
                uploadPartRequest.setPartNumber(partNum + 1);
                if (isCancel.get()) break;
                UploadPartResponse uploadPartResponse = this.uploadPart(uploadPartRequest);
                partETags.add(uploadPartResponse.getPartETag());
                logger.info("Complete upload with ETag: " + uploadPartResponse.getPartETag());
            }
            catch (IOException e) {
                logger.error("Failed to upload the part " + partNum + " [tryCount] = " + tryCount);
                --tryCount;
                continue;
            }
            finally {
                if (fis == null) continue;
                try {
                    fis.close();
                }
                catch (Exception exception) {}
                continue;
            }
            if (tryCount <= 0) continue;
            break;
        }
        if (isCancel.get()) {
            logger.info("Request is canceled");
        } else if (tryCount == 0) {
            logger.error("Failed to upload the part " + partNum);
        } else {
            logger.info("Success to upload the part " + partNum);
        }
        return tryCount > 0 && !isCancel.get();
    }

    private static class UploadPartTask
    implements Callable<Boolean> {
        BosClient client;
        PutSuperObjectRequest putSuperObjectRequest;
        int partNum;
        List<PartETag> partETags;

        UploadPartTask(BosClient client, PutSuperObjectRequest putSuperObjectRequest, int partNum, List<PartETag> partETags) {
            this.client = client;
            this.putSuperObjectRequest = putSuperObjectRequest;
            this.partNum = partNum;
            this.partETags = partETags;
        }

        @Override
        public Boolean call() {
            return this.client.uploadFilePart(this.putSuperObjectRequest, this.partNum, this.partETags);
        }
    }
}

