/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bvw.model.matlib.timeline;

import com.baidubce.services.bos.BosClient;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TimelineMediaInfo {
    private String fileType;
    private String sourceType;
    private String sourceUrl;
    private String audioUrl;
    private String bucket;
    private String key;
    private String audioKey;
    private String instanceId;
    private String coverImage;
    private Double duration;
    private Integer width;
    private Integer height;
    private String errmsg;
    private String status;
    private String progress;
    private String action;
    private Integer size;
    private String name = "";
    private String thumbnailPrefix;
    private List<String> thumbnailKeys;
    private List<String> thumbnailList = new ArrayList<String>();
    private List<String> subtitleKeys;
    private String mediaId = "";

    public void generalSignedUrl(BosClient bosClient) {
        this.sourceUrl = "";
        this.audioUrl = "";
        if (!StringUtils.isBlank((String)this.bucket) && !StringUtils.isBlank((String)this.key)) {
            String tmpKey = this.addResolutionPrefix(this.fileType, this.key);
            this.sourceUrl = bosClient.generatePresignedUrl(this.bucket, tmpKey, 7200).toString();
            if (StringUtils.isBlank((String)this.audioKey)) {
                this.audioKey = this.addResolutionPrefix("audio", this.key);
            }
            this.audioUrl = bosClient.generatePresignedUrl(this.bucket, this.audioKey, 7200).toString();
        }
        if (!StringUtils.isBlank((String)this.bucket) && this.thumbnailKeys != null) {
            this.thumbnailPrefix = this.thumbnailPrefix == null ? "" : this.thumbnailPrefix;
            this.thumbnailList = new ArrayList<String>();
            for (String key : this.thumbnailKeys) {
                String thumbnailUrl = bosClient.generatePresignedUrl(this.bucket, this.thumbnailPrefix + key, 7200).toString();
                this.thumbnailList.add(thumbnailUrl);
            }
        }
        this.coverImage = "";
        if ("image".equals(this.fileType)) {
            this.coverImage = this.sourceUrl;
        } else if ("video".equals(this.fileType) && this.thumbnailList != null && this.thumbnailList.size() > 0) {
            int index = this.thumbnailList.size() * 2 / 3;
            this.coverImage = this.thumbnailList.get(index);
        }
    }

    private String addResolutionPrefix(String type, String key) {
        if (type == null) {
            return key;
        }
        if ("video".equals(type)) {
            return this.addResolutionPrefix("360p", ".mp4", key);
        }
        if ("audio".equals(type)) {
            return this.addResolutionPrefix("audio", ".mp3", key);
        }
        return key;
    }

    private String addResolutionPrefix(String prefix, String suffix, String key) {
        if (key == null) {
            return null;
        }
        String result = key;
        if (prefix != null) {
            int index = result.lastIndexOf(".");
            if (-1 != index) {
                result = result.substring(0, index);
            }
            result = -1 == (index = result.lastIndexOf("/")) ? prefix + "/" + result : (0 == index ? prefix + "/" + result.substring(1) : result.substring(0, index + 1) + prefix + "/" + result.substring(index + 1));
            result = result + suffix;
        }
        return result;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public String getAudioUrl() {
        return this.audioUrl;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getAudioKey() {
        return this.audioKey;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getCoverImage() {
        return this.coverImage;
    }

    public Double getDuration() {
        return this.duration;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public String getErrmsg() {
        return this.errmsg;
    }

    public String getStatus() {
        return this.status;
    }

    public String getProgress() {
        return this.progress;
    }

    public String getAction() {
        return this.action;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public String getThumbnailPrefix() {
        return this.thumbnailPrefix;
    }

    public List<String> getThumbnailKeys() {
        return this.thumbnailKeys;
    }

    public List<String> getThumbnailList() {
        return this.thumbnailList;
    }

    public List<String> getSubtitleKeys() {
        return this.subtitleKeys;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public void setAudioUrl(String audioUrl) {
        this.audioUrl = audioUrl;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setAudioKey(String audioKey) {
        this.audioKey = audioKey;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setCoverImage(String coverImage) {
        this.coverImage = coverImage;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public void setErrmsg(String errmsg) {
        this.errmsg = errmsg;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setThumbnailPrefix(String thumbnailPrefix) {
        this.thumbnailPrefix = thumbnailPrefix;
    }

    public void setThumbnailKeys(List<String> thumbnailKeys) {
        this.thumbnailKeys = thumbnailKeys;
    }

    public void setThumbnailList(List<String> thumbnailList) {
        this.thumbnailList = thumbnailList;
    }

    public void setSubtitleKeys(List<String> subtitleKeys) {
        this.subtitleKeys = subtitleKeys;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimelineMediaInfo)) {
            return false;
        }
        TimelineMediaInfo other = (TimelineMediaInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fileType = this.getFileType();
        String other$fileType = other.getFileType();
        if (this$fileType == null ? other$fileType != null : !this$fileType.equals(other$fileType)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        String this$sourceUrl = this.getSourceUrl();
        String other$sourceUrl = other.getSourceUrl();
        if (this$sourceUrl == null ? other$sourceUrl != null : !this$sourceUrl.equals(other$sourceUrl)) {
            return false;
        }
        String this$audioUrl = this.getAudioUrl();
        String other$audioUrl = other.getAudioUrl();
        if (this$audioUrl == null ? other$audioUrl != null : !this$audioUrl.equals(other$audioUrl)) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$audioKey = this.getAudioKey();
        String other$audioKey = other.getAudioKey();
        if (this$audioKey == null ? other$audioKey != null : !this$audioKey.equals(other$audioKey)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        String this$coverImage = this.getCoverImage();
        String other$coverImage = other.getCoverImage();
        if (this$coverImage == null ? other$coverImage != null : !this$coverImage.equals(other$coverImage)) {
            return false;
        }
        Double this$duration = this.getDuration();
        Double other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        String this$errmsg = this.getErrmsg();
        String other$errmsg = other.getErrmsg();
        if (this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$progress = this.getProgress();
        String other$progress = other.getProgress();
        if (this$progress == null ? other$progress != null : !this$progress.equals(other$progress)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$thumbnailPrefix = this.getThumbnailPrefix();
        String other$thumbnailPrefix = other.getThumbnailPrefix();
        if (this$thumbnailPrefix == null ? other$thumbnailPrefix != null : !this$thumbnailPrefix.equals(other$thumbnailPrefix)) {
            return false;
        }
        List<String> this$thumbnailKeys = this.getThumbnailKeys();
        List<String> other$thumbnailKeys = other.getThumbnailKeys();
        if (this$thumbnailKeys == null ? other$thumbnailKeys != null : !((Object)this$thumbnailKeys).equals(other$thumbnailKeys)) {
            return false;
        }
        List<String> this$thumbnailList = this.getThumbnailList();
        List<String> other$thumbnailList = other.getThumbnailList();
        if (this$thumbnailList == null ? other$thumbnailList != null : !((Object)this$thumbnailList).equals(other$thumbnailList)) {
            return false;
        }
        List<String> this$subtitleKeys = this.getSubtitleKeys();
        List<String> other$subtitleKeys = other.getSubtitleKeys();
        if (this$subtitleKeys == null ? other$subtitleKeys != null : !((Object)this$subtitleKeys).equals(other$subtitleKeys)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        return !(this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimelineMediaInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fileType = this.getFileType();
        result = result * 59 + ($fileType == null ? 43 : $fileType.hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        String $sourceUrl = this.getSourceUrl();
        result = result * 59 + ($sourceUrl == null ? 43 : $sourceUrl.hashCode());
        String $audioUrl = this.getAudioUrl();
        result = result * 59 + ($audioUrl == null ? 43 : $audioUrl.hashCode());
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $audioKey = this.getAudioKey();
        result = result * 59 + ($audioKey == null ? 43 : $audioKey.hashCode());
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        String $coverImage = this.getCoverImage();
        result = result * 59 + ($coverImage == null ? 43 : $coverImage.hashCode());
        Double $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        String $errmsg = this.getErrmsg();
        result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : $progress.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $thumbnailPrefix = this.getThumbnailPrefix();
        result = result * 59 + ($thumbnailPrefix == null ? 43 : $thumbnailPrefix.hashCode());
        List<String> $thumbnailKeys = this.getThumbnailKeys();
        result = result * 59 + ($thumbnailKeys == null ? 43 : ((Object)$thumbnailKeys).hashCode());
        List<String> $thumbnailList = this.getThumbnailList();
        result = result * 59 + ($thumbnailList == null ? 43 : ((Object)$thumbnailList).hashCode());
        List<String> $subtitleKeys = this.getSubtitleKeys();
        result = result * 59 + ($subtitleKeys == null ? 43 : ((Object)$subtitleKeys).hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        return result;
    }

    public String toString() {
        return "TimelineMediaInfo(fileType=" + this.getFileType() + ", sourceType=" + this.getSourceType() + ", sourceUrl=" + this.getSourceUrl() + ", audioUrl=" + this.getAudioUrl() + ", bucket=" + this.getBucket() + ", key=" + this.getKey() + ", audioKey=" + this.getAudioKey() + ", instanceId=" + this.getInstanceId() + ", coverImage=" + this.getCoverImage() + ", duration=" + this.getDuration() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", errmsg=" + this.getErrmsg() + ", status=" + this.getStatus() + ", progress=" + this.getProgress() + ", action=" + this.getAction() + ", size=" + this.getSize() + ", name=" + this.getName() + ", thumbnailPrefix=" + this.getThumbnailPrefix() + ", thumbnailKeys=" + this.getThumbnailKeys() + ", thumbnailList=" + this.getThumbnailList() + ", subtitleKeys=" + this.getSubtitleKeys() + ", mediaId=" + this.getMediaId() + ")";
    }
}

