/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.media;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.media.model.Area;
import com.baidubce.services.media.model.Audio;
import com.baidubce.services.media.model.Clip;
import com.baidubce.services.media.model.CreateJobRequest;
import com.baidubce.services.media.model.CreateJobResponse;
import com.baidubce.services.media.model.CreateNotificationRequest;
import com.baidubce.services.media.model.CreateNotificationResponse;
import com.baidubce.services.media.model.CreatePipelineRequest;
import com.baidubce.services.media.model.CreatePipelineResponse;
import com.baidubce.services.media.model.CreatePresetRequest;
import com.baidubce.services.media.model.CreatePresetResponse;
import com.baidubce.services.media.model.CreateSubtitleJobRequest;
import com.baidubce.services.media.model.CreateSubtitleJobResponse;
import com.baidubce.services.media.model.CreateThumbnailJobRequest;
import com.baidubce.services.media.model.CreateThumbnailJobResponse;
import com.baidubce.services.media.model.CreateThumbnailPresetRequest;
import com.baidubce.services.media.model.CreateThumbnailPresetResponse;
import com.baidubce.services.media.model.CreateTranscodingJobRequest;
import com.baidubce.services.media.model.CreateTranscodingJobResponse;
import com.baidubce.services.media.model.CreateWaterMarkRequest;
import com.baidubce.services.media.model.CreateWaterMarkResponse;
import com.baidubce.services.media.model.DeleteNotificationRequest;
import com.baidubce.services.media.model.DeleteNotificationResponse;
import com.baidubce.services.media.model.DeletePipelineRequest;
import com.baidubce.services.media.model.DeletePresetRequest;
import com.baidubce.services.media.model.DeletePresetResponse;
import com.baidubce.services.media.model.DeleteThumbnailPresetRequest;
import com.baidubce.services.media.model.DeleteWaterMarkRequest;
import com.baidubce.services.media.model.DeleteWaterMarkResponse;
import com.baidubce.services.media.model.Encryption;
import com.baidubce.services.media.model.ExtraCfg;
import com.baidubce.services.media.model.GetJobRequest;
import com.baidubce.services.media.model.GetJobResponse;
import com.baidubce.services.media.model.GetMediaInfoOfFileRequest;
import com.baidubce.services.media.model.GetMediaInfoOfFileResponse;
import com.baidubce.services.media.model.GetNotificationRequest;
import com.baidubce.services.media.model.GetNotificationResponse;
import com.baidubce.services.media.model.GetPipelineRequest;
import com.baidubce.services.media.model.GetPipelineResponse;
import com.baidubce.services.media.model.GetPresetRequest;
import com.baidubce.services.media.model.GetPresetResponse;
import com.baidubce.services.media.model.GetSubtitleJobRequest;
import com.baidubce.services.media.model.GetSubtitleJobResponse;
import com.baidubce.services.media.model.GetThumbnailJobRequest;
import com.baidubce.services.media.model.GetThumbnailJobResponse;
import com.baidubce.services.media.model.GetThumbnailPresetRequest;
import com.baidubce.services.media.model.GetThumbnailPresetResponse;
import com.baidubce.services.media.model.GetTranscodingJobRequest;
import com.baidubce.services.media.model.GetTranscodingJobResponse;
import com.baidubce.services.media.model.GetWaterMarkRequest;
import com.baidubce.services.media.model.GetWaterMarkResponse;
import com.baidubce.services.media.model.Insert;
import com.baidubce.services.media.model.ListJobsRequest;
import com.baidubce.services.media.model.ListJobsResponse;
import com.baidubce.services.media.model.ListNotificationsRequest;
import com.baidubce.services.media.model.ListNotificationsResponse;
import com.baidubce.services.media.model.ListPipelinesRequest;
import com.baidubce.services.media.model.ListPipelinesResponse;
import com.baidubce.services.media.model.ListPresetsRequest;
import com.baidubce.services.media.model.ListPresetsResponse;
import com.baidubce.services.media.model.ListSubtitleJobsRequest;
import com.baidubce.services.media.model.ListSubtitleJobsResponse;
import com.baidubce.services.media.model.ListThumbnailJobsRequest;
import com.baidubce.services.media.model.ListThumbnailJobsResponse;
import com.baidubce.services.media.model.ListThumbnailPresetsRequest;
import com.baidubce.services.media.model.ListThumbnailPresetsResponse;
import com.baidubce.services.media.model.ListTranscodingJobsRequest;
import com.baidubce.services.media.model.ListTranscodingJobsResponse;
import com.baidubce.services.media.model.ListWaterMarkRequest;
import com.baidubce.services.media.model.ListWaterMarkResponse;
import com.baidubce.services.media.model.PipelineConfig;
import com.baidubce.services.media.model.Source;
import com.baidubce.services.media.model.SourceClip;
import com.baidubce.services.media.model.SubtitleSource;
import com.baidubce.services.media.model.SubtitleTarget;
import com.baidubce.services.media.model.Target;
import com.baidubce.services.media.model.ThumbnailCapture;
import com.baidubce.services.media.model.ThumbnailPresetCapture;
import com.baidubce.services.media.model.ThumbnailPresetTarget;
import com.baidubce.services.media.model.ThumbnailSource;
import com.baidubce.services.media.model.ThumbnailTarget;
import com.baidubce.services.media.model.Timeline;
import com.baidubce.services.media.model.TransCfg;
import com.baidubce.services.media.model.UpdatePipelineRequest;
import com.baidubce.services.media.model.UpdatePipelineResponse;
import com.baidubce.services.media.model.UpdatePresetRequest;
import com.baidubce.services.media.model.UpdatePresetResponse;
import com.baidubce.services.media.model.UpdateThumbnailPresetRequest;
import com.baidubce.services.media.model.UpdateThumbnailPresetResponse;
import com.baidubce.services.media.model.Video;
import com.baidubce.services.media.model.Watermarks;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MediaClient
extends AbstractBceClient {
    private static final String VERSION = "v3";
    private static final String TRANSCODE_JOB = "job/transcoding";
    private static final String PIPELINE = "pipeline";
    private static final String PRESET = "preset";
    private static final String THUMBNAIL_PRESET = "preset/thumbnail";
    private static final String MEDIAINFO = "mediainfo";
    private static final String WATER_MARK = "watermark";
    private static final String THUMBNAIL = "job/thumbnail";
    private static final String SUBTITLE = "job/subtitle";
    private static final String NOTIFICATION = "notification";
    private static final int DEFAULT_PIPELINE_CAPACITY = 20;
    public static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    public static final String PIPELINENAME_MESSAGE_KEY = "pipelineName";
    public static final String SOURCE_MESSAGE_KEY = "source";
    public static final String TARGET_MESSAGE_KEY = "target";
    public static final String SOURCEKEY_MESSAGE_KEY = "sourceKey";
    public static final String TARGETKEY_MESSAGE_KEY = "targetKey";
    public static final String SOURCEBUCKET_MESSAGE_KEY = "sourceBucket";
    public static final String TARGETBUCKET_MESSAGE_KEY = "targetBucket";
    public static final String NAME_MESSAGE_KEY = "name";
    public static final String ENDPOINT_MESSAGE_KEY = "endpoint";
    public static final String PRESETNAME_MESSAGE_KEY = "presetName";
    public static final String JOBID_MESSAGE_KEY = "jobId";
    public static final String BUCKET_MESSAGE_KEY = "bucket";
    public static final String KEY_MESSAGE_KEY = "key";
    public static final String WATERMARKID_MESSAGE_KEY = "watermarkId";
    private static final HttpResponseHandler[] mediaHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public MediaClient() {
        this(new BceClientConfiguration());
    }

    public MediaClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, mediaHandlers);
    }

    @Deprecated
    public CreateJobResponse createJob(String pipelineName, String sourceKey, String targetKey, String presetName) {
        CreateJobRequest request = new CreateJobRequest();
        request.setPipelineName(pipelineName);
        Source source = new Source();
        source.setSourceKey(sourceKey);
        request.setSource(source);
        Target target = new Target();
        target.setTargetKey(targetKey);
        target.setPresetName(presetName);
        request.setTarget(target);
        return this.createJob(request);
    }

    @Deprecated
    public CreateJobResponse createJob(CreateJobRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getPipelineName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PIPELINENAME_MESSAGE_KEY));
        Validate.checkNotNull(request.getSource(), StringFormatUtils.checkEmptyExceptionMessageFormat(SOURCE_MESSAGE_KEY));
        Validate.checkNotNull(request.getTarget(), StringFormatUtils.checkEmptyExceptionMessageFormat(TARGET_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getTarget().getTargetKey(), StringFormatUtils.checkEmptyExceptionMessageFormat(TARGETKEY_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getTarget().getPresetName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PRESETNAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, TRANSCODE_JOB);
        return this.invokeHttpClient(internalRequest, CreateJobResponse.class);
    }

    @Deprecated
    public ListJobsResponse listJobs(String pipelineName) {
        ListJobsRequest request = new ListJobsRequest();
        request.setPipelineName(pipelineName);
        return this.listJobs(request);
    }

    @Deprecated
    public ListJobsResponse listJobs(ListJobsRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getPipelineName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PIPELINENAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, TRANSCODE_JOB);
        internalRequest.addParameter(PIPELINENAME_MESSAGE_KEY, request.getPipelineName());
        return this.invokeHttpClient(internalRequest, ListJobsResponse.class);
    }

    @Deprecated
    public GetJobResponse getJob(String jobId) {
        GetJobRequest request = new GetJobRequest();
        request.setJobId(jobId);
        return this.getJob(request);
    }

    @Deprecated
    public GetJobResponse getJob(GetJobRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getJobId(), StringFormatUtils.checkEmptyExceptionMessageFormat(JOBID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, TRANSCODE_JOB, request.getJobId());
        return this.invokeHttpClient(internalRequest, GetJobResponse.class);
    }

    public CreateTranscodingJobResponse createTranscodingJob(String pipelineName, String sourceKey, String targetKey, String presetName) {
        return this.createTranscodingJob(pipelineName, sourceKey, targetKey, presetName, null, null);
    }

    public CreateTranscodingJobResponse createTranscodingJob(String pipelineName, String sourceKey, String targetKey, String presetName, String watermarkId, Area delogoArea) {
        CreateTranscodingJobRequest request = new CreateTranscodingJobRequest();
        request.setPipelineName(pipelineName);
        Source source = new Source();
        source.setSourceKey(sourceKey);
        request.setSource(source);
        Target target = new Target();
        target.setTargetKey(targetKey);
        target.setPresetName(presetName);
        if (!Strings.isNullOrEmpty((String)watermarkId)) {
            List<String> watermarkIds = Collections.singletonList(watermarkId);
            target.setWatermarkIds(watermarkIds);
        }
        if (delogoArea != null) {
            target.setDelogoArea(delogoArea);
        }
        request.setTarget(target);
        return this.createTranscodingJob(request);
    }

    public CreateTranscodingJobResponse createTranscodingJob(String pipelineName, List<SourceClip> clips, String targetKey, String presetName) {
        return this.createTranscodingJob(pipelineName, clips, targetKey, presetName, null, null);
    }

    public CreateTranscodingJobResponse createTranscodingJob(String pipelineName, List<SourceClip> clips, String targetKey, String presetName, String watermarkId) {
        return this.createTranscodingJob(pipelineName, clips, targetKey, presetName, watermarkId, null);
    }

    public CreateTranscodingJobResponse createTranscodingJob(String pipelineName, List<SourceClip> clips, String targetKey, String presetName, String watermarkId, Area delogoArea) {
        return this.createTranscodingJob(pipelineName, clips, targetKey, presetName, watermarkId, delogoArea, null, null);
    }

    public CreateTranscodingJobResponse createTranscodingJob(String pipelineName, List<SourceClip> clips, String targetKey, String presetName, String watermarkId, Area delogoArea, Area crop, List<Insert> inserts) {
        CreateTranscodingJobRequest request = new CreateTranscodingJobRequest();
        request.setPipelineName(pipelineName);
        Source source = new Source();
        for (SourceClip clip : clips) {
            source.addClip(clip);
        }
        request.setSource(source);
        Target target = new Target();
        target.setTargetKey(targetKey);
        target.setPresetName(presetName);
        if (!Strings.isNullOrEmpty((String)watermarkId)) {
            List<String> watermarkIds = Collections.singletonList(watermarkId);
            target.setWatermarkIds(watermarkIds);
        }
        if (delogoArea != null) {
            target.setDelogoArea(delogoArea);
        }
        if (crop != null) {
            target.setCrop(crop);
        }
        if (inserts != null) {
            target.setInserts(inserts);
        }
        request.setTarget(target);
        return this.createTranscodingJob(request);
    }

    public CreateTranscodingJobResponse createTranscodingJob(CreateTranscodingJobRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getPipelineName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PIPELINENAME_MESSAGE_KEY));
        Validate.checkNotNull(request.getSource(), StringFormatUtils.checkEmptyExceptionMessageFormat(SOURCE_MESSAGE_KEY));
        Validate.checkNotNull(request.getTarget(), StringFormatUtils.checkEmptyExceptionMessageFormat(TARGET_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getTarget().getTargetKey(), StringFormatUtils.checkEmptyExceptionMessageFormat(TARGETKEY_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getTarget().getPresetName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PRESETNAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, TRANSCODE_JOB);
        return this.invokeHttpClient(internalRequest, CreateTranscodingJobResponse.class);
    }

    public ListTranscodingJobsResponse listTranscodingJobs(String pipelineName) {
        ListTranscodingJobsRequest request = new ListTranscodingJobsRequest();
        request.setPipelineName(pipelineName);
        return this.listTranscodingJobs(request);
    }

    public ListTranscodingJobsResponse listTranscodingJobs(ListTranscodingJobsRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getPipelineName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PIPELINENAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, TRANSCODE_JOB);
        internalRequest.addParameter(PIPELINENAME_MESSAGE_KEY, request.getPipelineName());
        return this.invokeHttpClient(internalRequest, ListTranscodingJobsResponse.class);
    }

    public GetTranscodingJobResponse getTranscodingJob(String jobId) {
        GetTranscodingJobRequest request = new GetTranscodingJobRequest();
        request.setJobId(jobId);
        return this.getTranscodingJob(request);
    }

    public GetTranscodingJobResponse getTranscodingJob(GetTranscodingJobRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getJobId(), StringFormatUtils.checkEmptyExceptionMessageFormat(JOBID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, TRANSCODE_JOB, request.getJobId());
        return this.invokeHttpClient(internalRequest, GetTranscodingJobResponse.class);
    }

    public CreatePipelineResponse createPipeline(String pipelineName, String sourceBucket, String targetBucket, int capacity) {
        return this.createPipeline(pipelineName, null, sourceBucket, targetBucket, capacity);
    }

    public CreatePipelineResponse createPipeline(String pipelineName, String sourceBucket, String targetBucket) {
        CreatePipelineRequest request = new CreatePipelineRequest();
        request.setPipelineName(pipelineName);
        request.setDescription("");
        request.setSourceBucket(sourceBucket);
        request.setTargetBucket(targetBucket);
        return this.createPipeline(request);
    }

    public CreatePipelineResponse createPipeline(String pipelineName, String description, String sourceBucket, String targetBucket, int capacity) {
        return this.createPipeline(pipelineName, description, sourceBucket, targetBucket, capacity, null);
    }

    public CreatePipelineResponse createPipeline(String pipelineName, String description, String sourceBucket, String targetBucket, int capacity, String notification) {
        CreatePipelineRequest request = new CreatePipelineRequest();
        request.setPipelineName(pipelineName);
        request.setDescription(description);
        request.setSourceBucket(sourceBucket);
        request.setTargetBucket(targetBucket);
        PipelineConfig config = new PipelineConfig();
        config.setCapacity(capacity);
        config.setNotification(notification);
        request.setConfig(config);
        return this.createPipeline(request);
    }

    public CreatePipelineResponse createPipeline(CreatePipelineRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getPipelineName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PIPELINENAME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getSourceBucket(), StringFormatUtils.checkEmptyExceptionMessageFormat(SOURCEBUCKET_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getTargetBucket(), StringFormatUtils.checkEmptyExceptionMessageFormat(TARGETBUCKET_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, PIPELINE);
        return this.invokeHttpClient(internalRequest, CreatePipelineResponse.class);
    }

    public UpdatePipelineResponse updatePipeline(UpdatePipelineRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getPipelineName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PIPELINENAME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getSourceBucket(), StringFormatUtils.checkEmptyExceptionMessageFormat(SOURCEBUCKET_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getTargetBucket(), StringFormatUtils.checkEmptyExceptionMessageFormat(TARGETBUCKET_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, PIPELINE, request.getPipelineName());
        return this.invokeHttpClient(internalRequest, UpdatePipelineResponse.class);
    }

    public ListPipelinesResponse listPipelines() {
        ListPipelinesRequest request = new ListPipelinesRequest();
        return this.listPipelines(request);
    }

    public ListPipelinesResponse listPipelines(ListPipelinesRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PIPELINE);
        return this.invokeHttpClient(internalRequest, ListPipelinesResponse.class);
    }

    public GetPipelineResponse getPipeline(String pipelineName) {
        GetPipelineRequest request = new GetPipelineRequest();
        request.setPipelineName(pipelineName);
        return this.getPipeline(request);
    }

    public GetPipelineResponse getPipeline(GetPipelineRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getPipelineName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PIPELINENAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PIPELINE, request.getPipelineName());
        return this.invokeHttpClient(internalRequest, GetPipelineResponse.class);
    }

    public void deletePipeline(String pipelineName) {
        DeletePipelineRequest request = new DeletePipelineRequest();
        request.setPipelineName(pipelineName);
        this.deletePipeline(request);
    }

    public void deletePipeline(DeletePipelineRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getPipelineName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PIPELINENAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, PIPELINE, request.getPipelineName());
        this.invokeHttpClient(internalRequest, CreatePipelineResponse.class);
    }

    public CreatePresetResponse createPreset(String presetName, String container, Audio audio) {
        return this.createPreset(presetName, null, container, false, null, audio, null, null, null);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container, Audio audio) {
        return this.createPreset(presetName, description, container, false, null, audio, null, null, null);
    }

    public CreatePresetResponse createPreset(String presetName, String container, Clip clip, Audio audio, Encryption encryption) {
        return this.createPreset(presetName, null, container, false, clip, audio, null, encryption, null);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container, Clip clip, Audio audio, Encryption encryption) {
        return this.createPreset(presetName, description, container, false, clip, audio, null, encryption, null);
    }

    public CreatePresetResponse createPreset(String presetName, String container, Audio audio, Video video) {
        return this.createPreset(presetName, null, container, false, null, audio, video, null, null);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container, Audio audio, Video video) {
        return this.createPreset(presetName, description, container, false, null, audio, video, null, null);
    }

    public CreatePresetResponse createPreset(String presetName, String container, Clip clip, Audio audio, Video video, Encryption encryption) {
        return this.createPreset(presetName, null, container, false, clip, audio, video, encryption, null);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container, Clip clip, Audio audio, Video video, Encryption encryption) {
        return this.createPreset(presetName, description, container, false, clip, audio, video, encryption, null);
    }

    public CreatePresetResponse createPreset(String presetName, String container, Clip clip, Audio audio, Video video, Encryption encryption, String watermarkId) {
        return this.createPreset(presetName, null, container, false, clip, audio, video, encryption, watermarkId);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container, Clip clip, Audio audio, Video video, Encryption encryption, String watermarkId) {
        return this.createPreset(presetName, description, container, false, clip, audio, video, encryption, watermarkId);
    }

    public CreatePresetResponse createPreset(String presetName, String container) {
        return this.createPreset(presetName, null, container, true, null, null, null, null, null);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container) {
        return this.createPreset(presetName, description, container, true, null, null, null, null, null);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container, boolean transmux, Clip clip, Audio audio, Video video, Encryption encryption) {
        return this.createPreset(presetName, description, container, false, clip, audio, video, encryption, null);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container, boolean transmux, Clip clip, Audio audio, Video video, Encryption encryption, String watermarkId) {
        CreatePresetRequest request = new CreatePresetRequest();
        request.setPresetName(presetName);
        request.setDescription(description);
        request.setContainer(container);
        request.setTransmux(transmux);
        request.setClip(clip);
        request.setAudio(audio);
        request.setVideo(video);
        request.setEncryption(encryption);
        request.setWatermarkId(watermarkId);
        return this.createPreset(request);
    }

    public CreatePresetResponse createPreset(String presetName, String description, String container, boolean transmux, Clip clip, Audio audio, Video video, Encryption encryption, Watermarks watermarks, TransCfg transCfg, ExtraCfg extraCfg) {
        CreatePresetRequest request = new CreatePresetRequest();
        request.setPresetName(presetName);
        request.setDescription(description);
        request.setContainer(container);
        request.setTransmux(transmux);
        request.setClip(clip);
        request.setAudio(audio);
        request.setVideo(video);
        request.setEncryption(encryption);
        request.setWatermarks(watermarks);
        request.setTransCfg(transCfg);
        request.setExtraCfg(extraCfg);
        return this.createPreset(request);
    }

    public CreatePresetResponse createPreset(CreatePresetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, PRESET);
        return this.invokeHttpClient(internalRequest, CreatePresetResponse.class);
    }

    public UpdatePresetResponse updatePreset(UpdatePresetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, PRESET, request.getPresetName());
        return this.invokeHttpClient(internalRequest, UpdatePresetResponse.class);
    }

    public ListPresetsResponse listPresets() {
        ListPresetsRequest request = new ListPresetsRequest();
        return this.listPresets(request);
    }

    public ListPresetsResponse listPresets(ListPresetsRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PRESET);
        return this.invokeHttpClient(internalRequest, ListPresetsResponse.class);
    }

    public GetPresetResponse getPreset(String presetName) {
        GetPresetRequest request = new GetPresetRequest();
        request.setPresetName(presetName);
        return this.getPreset(request);
    }

    public GetPresetResponse getPreset(GetPresetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getPresetName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PRESETNAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PRESET, request.getPresetName());
        return this.invokeHttpClient(internalRequest, GetPresetResponse.class);
    }

    public void deletePreset(String presetName) {
        DeletePresetRequest request = new DeletePresetRequest();
        request.setPresetName(presetName);
        this.deletePreset(request);
    }

    public void deletePreset(DeletePresetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getPresetName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PRESETNAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, PRESET, request.getPresetName());
        this.invokeHttpClient(internalRequest, DeletePresetResponse.class);
    }

    public GetMediaInfoOfFileResponse getMediaInfoOfFile(String bucket, String key) {
        GetMediaInfoOfFileRequest request = new GetMediaInfoOfFileRequest();
        request.setBucket(bucket);
        request.setKey(key);
        return this.getMediaInfoOfFile(request);
    }

    public GetMediaInfoOfFileResponse getMediaInfoOfFile(GetMediaInfoOfFileRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBucket(), StringFormatUtils.checkEmptyExceptionMessageFormat(BUCKET_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getKey(), StringFormatUtils.checkEmptyExceptionMessageFormat(KEY_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, MEDIAINFO);
        internalRequest.addParameter(BUCKET_MESSAGE_KEY, request.getBucket());
        internalRequest.addParameter(KEY_MESSAGE_KEY, request.getKey());
        return this.invokeHttpClient(internalRequest, GetMediaInfoOfFileResponse.class);
    }

    @Deprecated
    public CreateWaterMarkResponse createWaterMark(String bucket, String key, int horizontalOffsetInPixel, int verticalOffsetInPixel) {
        CreateWaterMarkRequest request = new CreateWaterMarkRequest().withBucket(bucket).withKey(key).withHorizontalOffsetInPixel(horizontalOffsetInPixel).withVerticalOffsetInPixel(verticalOffsetInPixel);
        return this.createWaterMark(request);
    }

    public CreateWaterMarkResponse createWaterMark(String bucket, String key, String horizontalAlignment, String verticalAlignment) {
        CreateWaterMarkRequest request = new CreateWaterMarkRequest().withBucket(bucket).withKey(key).withHorizontalAlignment(horizontalAlignment).withVerticalAlignment(verticalAlignment);
        return this.createWaterMark(request);
    }

    public CreateWaterMarkResponse createWaterMark(String bucket, String key, String horizontalAlignment, String verticalAlignment, int horizontalOffsetInPixel, int verticalOffsetInPixel) {
        CreateWaterMarkRequest request = new CreateWaterMarkRequest().withBucket(bucket).withKey(key).withHorizontalAlignment(horizontalAlignment).withVerticalAlignment(verticalAlignment).withHorizontalOffsetInPixel(horizontalOffsetInPixel).withVerticalOffsetInPixel(verticalOffsetInPixel);
        return this.createWaterMark(request);
    }

    public CreateWaterMarkResponse createWaterMark(String bucket, String key, String horizontalAlignment, String verticalAlignment, int horizontalOffsetInPixel, int verticalOffsetInPixel, Timeline timeline, Integer repeated, Boolean allowScaling) {
        CreateWaterMarkRequest request = new CreateWaterMarkRequest().withBucket(bucket).withKey(key).withHorizontalAlignment(horizontalAlignment).withVerticalAlignment(verticalAlignment).withHorizontalOffsetInPixel(horizontalOffsetInPixel).withVerticalOffsetInPixel(verticalOffsetInPixel).withTimeline(timeline).withRepeated(repeated).withAllowScaling(allowScaling);
        return this.createWaterMark(request);
    }

    public CreateWaterMarkResponse createWaterMark(CreateWaterMarkRequest request) {
        Validate.checkStringNotEmpty(request.getBucket(), StringFormatUtils.checkEmptyExceptionMessageFormat(BUCKET_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getKey(), StringFormatUtils.checkEmptyExceptionMessageFormat(KEY_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, WATER_MARK);
        return this.invokeHttpClient(internalRequest, CreateWaterMarkResponse.class);
    }

    public GetWaterMarkResponse getWaterMark(String watermarkId) {
        GetWaterMarkRequest request = new GetWaterMarkRequest().withWatermarkId(watermarkId);
        return this.getWaterMark(request);
    }

    public GetWaterMarkResponse getWaterMark(GetWaterMarkRequest request) {
        Validate.checkStringNotEmpty(request.getWatermarkId(), StringFormatUtils.checkEmptyExceptionMessageFormat(WATERMARKID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, WATER_MARK, request.getWatermarkId());
        return this.invokeHttpClient(internalRequest, GetWaterMarkResponse.class);
    }

    public ListWaterMarkResponse listWaterMark() {
        ListWaterMarkRequest request = new ListWaterMarkRequest();
        return this.listWaterMark(request);
    }

    public ListWaterMarkResponse listWaterMark(ListWaterMarkRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, WATER_MARK);
        return this.invokeHttpClient(internalRequest, ListWaterMarkResponse.class);
    }

    public void deleteWaterMark(String watermarkId) {
        DeleteWaterMarkRequest request = new DeleteWaterMarkRequest().withWatermarkId(watermarkId);
        this.deleteWaterMark(request);
    }

    public void deleteWaterMark(DeleteWaterMarkRequest request) {
        Validate.checkStringNotEmpty(request.getWatermarkId(), StringFormatUtils.checkEmptyExceptionMessageFormat(WATERMARKID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, WATER_MARK, request.getWatermarkId());
        this.invokeHttpClient(internalRequest, DeleteWaterMarkResponse.class);
    }

    public CreateThumbnailJobResponse createThumbnailJob(String pipelineName, String sourceKey, ThumbnailTarget target, ThumbnailCapture capture) {
        ThumbnailSource source = new ThumbnailSource();
        source.setKey(sourceKey);
        CreateThumbnailJobRequest request = new CreateThumbnailJobRequest().withPipelineName(pipelineName).withSource(source).withTarget(target).withCapture(capture);
        return this.createThumbnailJob(request);
    }

    public CreateThumbnailJobResponse createThumbnailJob(String pipelineName, String presetName, String sourceKey, String targetKeyPrefix) {
        ThumbnailSource source = new ThumbnailSource();
        source.setKey(sourceKey);
        ThumbnailTarget target = new ThumbnailTarget();
        target.setKeyPrefix(targetKeyPrefix);
        CreateThumbnailJobRequest request = new CreateThumbnailJobRequest().withPipelineName(pipelineName).withPresetName(presetName).withSource(source).withTarget(target);
        return this.createThumbnailJob(request);
    }

    public CreateThumbnailJobResponse createThumbnailJob(String pipelineName, String presetName, String sourceKey, String targetKeyPrefix, Area delogoArea) {
        ThumbnailSource source = new ThumbnailSource();
        source.setKey(sourceKey);
        ThumbnailTarget target = new ThumbnailTarget();
        target.setKeyPrefix(targetKeyPrefix);
        CreateThumbnailJobRequest request = new CreateThumbnailJobRequest().withPipelineName(pipelineName).withPresetName(presetName).withSource(source).withTarget(target).withDelogoArea(delogoArea);
        return this.createThumbnailJob(request);
    }

    public CreateThumbnailJobResponse createThumbnailJob(String pipelineName, String presetName, String sourceKey, String targetKeyPrefix, Area delogoArea, Area crop) {
        ThumbnailSource source = new ThumbnailSource();
        source.setKey(sourceKey);
        ThumbnailTarget target = new ThumbnailTarget();
        target.setKeyPrefix(targetKeyPrefix);
        CreateThumbnailJobRequest request = new CreateThumbnailJobRequest().withPipelineName(pipelineName).withPresetName(presetName).withSource(source).withTarget(target).withDelogoArea(delogoArea).withCrop(crop);
        return this.createThumbnailJob(request);
    }

    public CreateThumbnailJobResponse createThumbnailJob(String pipelineName, String sourceKey, ThumbnailTarget target, ThumbnailCapture capture, Area delogoArea) {
        ThumbnailSource source = new ThumbnailSource();
        source.setKey(sourceKey);
        CreateThumbnailJobRequest request = new CreateThumbnailJobRequest().withPipelineName(pipelineName).withSource(source).withTarget(target).withCapture(capture).withDelogoArea(delogoArea);
        return this.createThumbnailJob(request);
    }

    public CreateThumbnailJobResponse createThumbnailJob(String pipelineName, String sourceKey, ThumbnailTarget target, ThumbnailCapture capture, Area delogoArea, Area crop) {
        ThumbnailSource source = new ThumbnailSource();
        source.setKey(sourceKey);
        CreateThumbnailJobRequest request = new CreateThumbnailJobRequest().withPipelineName(pipelineName).withSource(source).withTarget(target).withCapture(capture).withDelogoArea(delogoArea).withCrop(crop);
        return this.createThumbnailJob(request);
    }

    public CreateThumbnailJobResponse createThumbnailJob(String pipelineName, String sourceKey) {
        ThumbnailSource source = new ThumbnailSource();
        source.setKey(sourceKey);
        CreateThumbnailJobRequest request = new CreateThumbnailJobRequest().withPipelineName(pipelineName).withSource(source);
        return this.createThumbnailJob(request);
    }

    public CreateThumbnailJobResponse createThumbnailJob(CreateThumbnailJobRequest request) {
        Validate.checkStringNotEmpty(request.getPipelineName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PIPELINENAME_MESSAGE_KEY));
        Validate.checkNotNull(request.getSource(), StringFormatUtils.checkEmptyExceptionMessageFormat(SOURCE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getSource().getKey(), StringFormatUtils.checkEmptyExceptionMessageFormat(SOURCEKEY_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, THUMBNAIL);
        return this.invokeHttpClient(internalRequest, CreateThumbnailJobResponse.class);
    }

    public GetThumbnailJobResponse getThumbnailJob(String jobId) {
        GetThumbnailJobRequest request = new GetThumbnailJobRequest().withJobId(jobId);
        return this.getThumbnailJob(request);
    }

    public GetThumbnailJobResponse getThumbnailJob(GetThumbnailJobRequest request) {
        Validate.checkStringNotEmpty(request.getJobId(), StringFormatUtils.checkEmptyExceptionMessageFormat(JOBID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, THUMBNAIL, request.getJobId());
        return this.invokeHttpClient(internalRequest, GetThumbnailJobResponse.class);
    }

    public ListThumbnailJobsResponse listThumbnailJobs(String pipelineName) {
        ListThumbnailJobsRequest request = new ListThumbnailJobsRequest().withPipeline(pipelineName);
        return this.listThumbnailJobs(request);
    }

    public ListThumbnailJobsResponse listThumbnailJobs(ListThumbnailJobsRequest request) {
        Validate.checkStringNotEmpty(request.getPipeline(), StringFormatUtils.checkEmptyExceptionMessageFormat(PIPELINENAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, THUMBNAIL);
        internalRequest.addParameter(PIPELINENAME_MESSAGE_KEY, request.getPipeline());
        return this.invokeHttpClient(internalRequest, ListThumbnailJobsResponse.class);
    }

    public GetNotificationResponse getNotification(String name) {
        Validate.checkNotNull(name, StringFormatUtils.checkEmptyExceptionMessageFormat(NAME_MESSAGE_KEY));
        GetNotificationRequest request = new GetNotificationRequest().withName(name);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, NOTIFICATION, request.getName());
        return this.invokeHttpClient(internalRequest, GetNotificationResponse.class);
    }

    public ListNotificationsResponse listNotification() {
        ListNotificationsRequest request = new ListNotificationsRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, NOTIFICATION);
        return this.invokeHttpClient(internalRequest, ListNotificationsResponse.class);
    }

    public CreateNotificationResponse createNotification(String name, String endpoint) {
        Validate.checkNotNull(name, StringFormatUtils.checkEmptyExceptionMessageFormat(NAME_MESSAGE_KEY));
        Validate.checkNotNull(endpoint, StringFormatUtils.checkEmptyExceptionMessageFormat(ENDPOINT_MESSAGE_KEY));
        CreateNotificationRequest request = new CreateNotificationRequest().withName(name).withEndpoint(endpoint);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, NOTIFICATION);
        return this.invokeHttpClient(internalRequest, CreateNotificationResponse.class);
    }

    public DeleteNotificationResponse deleteNotification(String name) {
        Validate.checkNotNull(name, StringFormatUtils.checkEmptyExceptionMessageFormat(NAME_MESSAGE_KEY));
        DeleteNotificationRequest request = new DeleteNotificationRequest().withName(name);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, NOTIFICATION, request.getName());
        return this.invokeHttpClient(internalRequest, DeleteNotificationResponse.class);
    }

    private InternalRequest createRequest(HttpMethodName httpMethod, AbstractBceRequest request, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.setCredentials(request.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillRequestPayload(internalRequest, request);
        }
        return internalRequest;
    }

    private InternalRequest fillRequestPayload(InternalRequest internalRequest, AbstractBceRequest request) {
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return internalRequest;
    }

    public CreateThumbnailPresetResponse createThumbnailPreset(String presetName, String description, ThumbnailPresetTarget target, ThumbnailPresetCapture capture) {
        return this.createThumbnailPreset(new CreateThumbnailPresetRequest().withDescription(description).withPresetName(presetName).withTarget(target).withCapture(capture));
    }

    public CreateThumbnailPresetResponse createThumbnailPreset(CreateThumbnailPresetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, THUMBNAIL_PRESET);
        return this.invokeHttpClient(internalRequest, CreateThumbnailPresetResponse.class);
    }

    public void deleteThumbnailPreset(String presetName) {
        DeleteThumbnailPresetRequest request = new DeleteThumbnailPresetRequest();
        request.setPresetName(presetName);
        this.deleteThumbnailPreset(request);
    }

    public void deleteThumbnailPreset(DeleteThumbnailPresetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getPresetName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PRESETNAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, THUMBNAIL_PRESET, request.getPresetName());
        this.invokeHttpClient(internalRequest, DeletePresetResponse.class);
    }

    public GetThumbnailPresetResponse getThumbnailPreset(String presetName) {
        GetThumbnailPresetRequest request = new GetThumbnailPresetRequest();
        request.setPresetName(presetName);
        return this.getThumbnailPreset(request);
    }

    public GetThumbnailPresetResponse getThumbnailPreset(GetThumbnailPresetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getPresetName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PRESETNAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, THUMBNAIL_PRESET, request.getPresetName());
        return this.invokeHttpClient(internalRequest, GetThumbnailPresetResponse.class);
    }

    public UpdateThumbnailPresetResponse updateThumbnailPreset(UpdateThumbnailPresetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, THUMBNAIL_PRESET, request.getPresetName());
        return this.invokeHttpClient(internalRequest, UpdateThumbnailPresetResponse.class);
    }

    public ListThumbnailPresetsResponse listThumbnailPresets() {
        ListThumbnailPresetsRequest request = new ListThumbnailPresetsRequest();
        return this.listThumbnailPresets(request);
    }

    public ListThumbnailPresetsResponse listThumbnailPresets(ListThumbnailPresetsRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, THUMBNAIL_PRESET);
        return this.invokeHttpClient(internalRequest, ListThumbnailPresetsResponse.class);
    }

    public CreateSubtitleJobResponse createSubtitleJob(CreateSubtitleJobRequest request) {
        Validate.checkStringNotEmpty(request.getPipelineName(), StringFormatUtils.checkEmptyExceptionMessageFormat(PIPELINENAME_MESSAGE_KEY));
        Validate.checkNotNull(request.getSource(), StringFormatUtils.checkEmptyExceptionMessageFormat(SOURCE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getSource().getKey(), StringFormatUtils.checkEmptyExceptionMessageFormat(SOURCEKEY_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, SUBTITLE);
        return this.invokeHttpClient(internalRequest, CreateSubtitleJobResponse.class);
    }

    public CreateSubtitleJobResponse createSubtitleJob(String pipelineName, String sourceKey, String targetKeyPrefix) {
        SubtitleSource source = new SubtitleSource();
        source.setKey(sourceKey);
        SubtitleTarget target = new SubtitleTarget();
        target.setKeyPrefix(targetKeyPrefix);
        CreateSubtitleJobRequest request = new CreateSubtitleJobRequest().withPipelineName(pipelineName).withSource(source).withTarget(target);
        return this.createSubtitleJob(request);
    }

    public CreateSubtitleJobResponse createSubtitleJob(String pipelineName, String sourceKey, String targetKeyPrefix, String format) {
        SubtitleSource source = new SubtitleSource();
        source.setKey(sourceKey);
        SubtitleTarget target = new SubtitleTarget();
        target.setKeyPrefix(targetKeyPrefix);
        target.addFormat(format);
        CreateSubtitleJobRequest request = new CreateSubtitleJobRequest().withPipelineName(pipelineName).withSource(source).withTarget(target);
        return this.createSubtitleJob(request);
    }

    public CreateSubtitleJobResponse createSubtitleJob(String pipelineName, String sourceKey, String targetKeyPrefix, List<String> formats) {
        SubtitleSource source = new SubtitleSource();
        source.setKey(sourceKey);
        SubtitleTarget target = new SubtitleTarget();
        target.setKeyPrefix(targetKeyPrefix);
        target.setFormats(formats);
        CreateSubtitleJobRequest request = new CreateSubtitleJobRequest().withPipelineName(pipelineName).withSource(source).withTarget(target);
        return this.createSubtitleJob(request);
    }

    public GetSubtitleJobResponse getSubtitleJob(String jobId) {
        GetSubtitleJobRequest request = new GetSubtitleJobRequest().withJobId(jobId);
        return this.getSubtitleJob(request);
    }

    public GetSubtitleJobResponse getSubtitleJob(GetSubtitleJobRequest request) {
        Validate.checkStringNotEmpty(request.getJobId(), StringFormatUtils.checkEmptyExceptionMessageFormat(JOBID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, SUBTITLE, request.getJobId());
        return this.invokeHttpClient(internalRequest, GetSubtitleJobResponse.class);
    }

    public ListSubtitleJobsResponse listSubtitleJobs(String pipelineName) {
        ListSubtitleJobsRequest request = new ListSubtitleJobsRequest().withPipeline(pipelineName);
        return this.listSubtitleJobs(request);
    }

    public ListSubtitleJobsResponse listSubtitleJobs(ListSubtitleJobsRequest request) {
        Validate.checkStringNotEmpty(request.getPipeline(), StringFormatUtils.checkEmptyExceptionMessageFormat(PIPELINENAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, SUBTITLE);
        internalRequest.addParameter(PIPELINENAME_MESSAGE_KEY, request.getPipeline());
        return this.invokeHttpClient(internalRequest, ListSubtitleJobsResponse.class);
    }
}

