/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iotdmp.model.handler;

import com.baidubce.http.BceHttpResponse;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.iotdmp.model.anno.BceListResponse;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;

public class BceDmpHandler
extends BceJsonResponseHandler {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Override
    public boolean handle(BceHttpResponse httpResponse, AbstractBceResponse response) throws Exception {
        InputStream content = httpResponse.getContent();
        if (content != null) {
            if (response.getMetadata().getContentLength() > 0L || "chunked".equalsIgnoreCase(response.getMetadata().getTransferEncoding())) {
                try {
                    if (response.getClass().isAnnotationPresent(BceListResponse.class)) {
                        Class<?> aClass = response.getClass();
                        Field[] fields = aClass.getDeclaredFields();
                        String field = fields[0].getName();
                        ParameterizedType type = (ParameterizedType)fields[0].getGenericType();
                        Type[] types = type.getActualTypeArguments();
                        Class type1 = (Class)types[0];
                        JavaType javaType = BceDmpHandler.getCollectionType(ArrayList.class, Class.forName(type1.getName()));
                        String value = EntityUtils.toString((HttpEntity)httpResponse.getHttpResponse().getEntity());
                        List list = (List)OBJECT_MAPPER.readValue(value, javaType);
                        PropertyDescriptor descriptor = new PropertyDescriptor(field, aClass);
                        Method setMethod = descriptor.getWriteMethod();
                        setMethod.invoke((Object)response, list);
                    }
                    JsonUtils.load(content, response);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            content.close();
        }
        return true;
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return OBJECT_MAPPER.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }
}

