/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.ses.model;

import com.baidubce.services.ses.model.SesRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public class SendEmailRequest
extends SesRequest {
    private Mail mail;

    public Mail getMail() {
        return this.mail;
    }

    public void setMail(Mail mail) {
        this.mail = mail;
    }

    public static class Mail {
        private Source source;
        private Destination destination;
        private Subject subject;
        private Integer priority;
        private Message message;
        private List<Attachment> attachments;

        public Mail() {
        }

        public Mail(Source source, Destination destination, Subject subject, Integer priority, Message message) {
            this.source = source;
            this.destination = destination;
            this.subject = subject;
            this.priority = priority;
            this.message = message;
            this.attachments = new ArrayList<Attachment>();
        }

        public Source getSource() {
            return this.source;
        }

        public void setSource(Source source) {
            this.source = source;
        }

        public Destination getDestination() {
            return this.destination;
        }

        public void setDestination(Destination destination) {
            this.destination = destination;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public void setSubject(Subject subject) {
            this.subject = subject;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public Message getMessage() {
            return this.message;
        }

        public void setMessage(Message message) {
            this.message = message;
        }

        public List<Attachment> getAttachments() {
            return this.attachments;
        }

        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        public static class Attachment {
            @JsonProperty(value="file_name")
            private String filename;
            @JsonProperty(value="file_data")
            private FileData filedata;

            public Attachment() {
            }

            public Attachment(String filename, String filedata) {
                this.filename = filename;
                this.filedata = new FileData().withData(filedata);
            }

            public Attachment(String filename, FileData filedata) {
                this.filename = filename;
                this.filedata = filedata;
            }

            public String getFilename() {
                return this.filename;
            }

            public void setFilename(String filename) {
                this.filename = filename;
            }

            public FileData getFiledata() {
                return this.filedata;
            }

            public void setFiledata(FileData filedata) {
                this.filedata = filedata;
            }

            public static class FileData {
                private String data;

                public FileData withData(String data) {
                    this.setData(data);
                    return this;
                }

                public String getData() {
                    return this.data;
                }

                public void setData(String data) {
                    this.data = data;
                }
            }
        }

        public static class Message {
            private Subject html;

            public Message withHtml(Subject html) {
                this.setHtml(html);
                return this;
            }

            public Subject getHtml() {
                return this.html;
            }

            public void setHtml(Subject html) {
                this.html = html;
            }
        }

        public static class Subject {
            private Integer charset;
            private String data;

            public Subject withCharset(Integer charset) {
                this.setCharset(charset);
                return this;
            }

            public Subject withData(String data) {
                this.setData(data);
                return this;
            }

            public Integer getCharset() {
                return this.charset;
            }

            public void setCharset(Integer charset) {
                this.charset = charset;
            }

            public String getData() {
                return this.data;
            }

            public void setData(String data) {
                this.data = data;
            }
        }

        public static class Destination {
            @JsonProperty(value="to_addr")
            private List<Addr> toAddr;
            @JsonProperty(value="cc_addr")
            private List<Addr> ccAddr;
            @JsonProperty(value="bcc_addr")
            private List<Addr> bccAddr;

            public Destination() {
            }

            public Destination(List<Addr> toAddr, List<Addr> ccAddr, List<Addr> bccAddr) {
                this.toAddr = toAddr;
                this.ccAddr = ccAddr;
                this.bccAddr = bccAddr;
            }

            public List<Addr> getToAddr() {
                return this.toAddr;
            }

            public void setToAddr(List<Addr> toAddr) {
                this.toAddr = toAddr;
            }

            public List<Addr> getCcAddr() {
                return this.ccAddr;
            }

            public void setCcAddr(List<Addr> ccAddr) {
                this.ccAddr = ccAddr;
            }

            public List<Addr> getBccAddr() {
                return this.bccAddr;
            }

            public void setBccAddr(List<Addr> bccAddr) {
                this.bccAddr = bccAddr;
            }

            public static class Addr {
                private String addr;

                public Addr() {
                }

                public Addr(String addr) {
                    this.addr = addr;
                }

                public Addr withAddr(String addr) {
                    this.setAddr(addr);
                    return this;
                }

                public String getAddr() {
                    return this.addr;
                }

                public void setAddr(String addr) {
                    this.addr = addr;
                }

                @JsonIgnore
                public static List<Addr> asAddrList(String[] addrs) {
                    if (addrs == null) {
                        return null;
                    }
                    ArrayList<Addr> addrList = new ArrayList<Addr>(addrs.length);
                    for (String addr : addrs) {
                        addrList.add(new Addr().withAddr(addr));
                    }
                    return addrList;
                }
            }
        }

        public static class Source {
            private String from;
            @JsonProperty(value="name")
            private String displayName;
            @JsonProperty(value="return_path")
            private String returnPath;
            @JsonProperty(value="reply_to")
            private String replyTo;

            public Source() {
            }

            public Source(String from, String returnPath, String replyTo) {
                this.from = from;
                this.returnPath = returnPath;
                this.replyTo = replyTo;
            }

            public String getFrom() {
                return this.from;
            }

            public void setFrom(String from) {
                this.from = from;
            }

            public String getDisplayName() {
                return this.displayName;
            }

            public void setDisplayName(String displayName) {
                this.displayName = displayName;
            }

            public String getReturnPath() {
                return this.returnPath;
            }

            public void setReturnPath(String returnPath) {
                this.returnPath = returnPath;
            }

            public String getReplyTo() {
                return this.replyTo;
            }

            public void setReplyTo(String replyTo) {
                this.replyTo = replyTo;
            }
        }
    }
}

