/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.vpn;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.eip.model.Billing;
import com.baidubce.services.vpc.model.NetworkAction;
import com.baidubce.services.vpn.VpnClientConfiguration;
import com.baidubce.services.vpn.model.BindEipRequest;
import com.baidubce.services.vpn.model.CreateVpnConnRequest;
import com.baidubce.services.vpn.model.CreateVpnConnResponse;
import com.baidubce.services.vpn.model.CreateVpnRequest;
import com.baidubce.services.vpn.model.CreateVpnResponse;
import com.baidubce.services.vpn.model.DeleteVpnConnRequest;
import com.baidubce.services.vpn.model.DeleteVpnRequest;
import com.baidubce.services.vpn.model.GetVpnRequest;
import com.baidubce.services.vpn.model.GetVpnResponse;
import com.baidubce.services.vpn.model.ListVpnConnRequest;
import com.baidubce.services.vpn.model.ListVpnConnResponse;
import com.baidubce.services.vpn.model.ListVpnRequest;
import com.baidubce.services.vpn.model.ListVpnResponse;
import com.baidubce.services.vpn.model.RenewVpnRequest;
import com.baidubce.services.vpn.model.UnBindEipRequest;
import com.baidubce.services.vpn.model.UpdateVpnConnRequest;
import com.baidubce.services.vpn.model.UpdateVpnRequest;
import com.baidubce.services.vpn.util.Preconditions;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class VpnClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String VPN_PREFIX = "vpn";
    private static final HttpResponseHandler[] vpnHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public VpnClient() {
        this(new VpnClientConfiguration());
    }

    public VpnClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, vpnHandlers);
    }

    public ListVpnResponse listVpns(ListVpnRequest request) {
        com.google.common.base.Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkStrIsBlank(request.getVpcId(), "vpcId");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VPN_PREFIX);
        if (StringUtils.isNotBlank((CharSequence)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (StringUtils.isNotBlank((CharSequence)request.getEip())) {
            internalRequest.addParameter("eip", request.getEip());
        }
        internalRequest.addParameter("vpcId", request.getVpcId());
        return this.invokeHttpClient(internalRequest, ListVpnResponse.class);
    }

    public CreateVpnResponse createVpn(CreateVpnRequest createVpnRequest) {
        com.google.common.base.Preconditions.checkNotNull((Object)createVpnRequest, (Object)"request should not be null.");
        Preconditions.checkStrIsBlank(createVpnRequest.getVpcId(), "vpcId");
        Preconditions.checkStrIsBlank(createVpnRequest.getVpnName(), "vpnName");
        if (createVpnRequest.getBilling() == null) {
            createVpnRequest.setBilling(this.generateDefaultBilling());
        }
        InternalRequest internalRequest = this.createRequest(createVpnRequest, HttpMethodName.POST, VPN_PREFIX);
        if (StringUtils.isNotBlank((CharSequence)createVpnRequest.getClientToken())) {
            internalRequest.addParameter("clientToken", createVpnRequest.getClientToken());
        }
        this.fillPayload(internalRequest, createVpnRequest);
        return this.invokeHttpClient(internalRequest, CreateVpnResponse.class);
    }

    public AbstractBceResponse updateVpn(UpdateVpnRequest updateVpnRequest) {
        com.google.common.base.Preconditions.checkNotNull((Object)updateVpnRequest, (Object)"request should not be null.");
        Preconditions.checkStrIsBlank(updateVpnRequest.getVpnId(), "vpnId");
        InternalRequest internalRequest = this.createRequest(updateVpnRequest, HttpMethodName.PUT, VPN_PREFIX, updateVpnRequest.getVpnId());
        internalRequest.addParameter(NetworkAction.modifyAttribute.name(), null);
        if (StringUtils.isNotBlank((CharSequence)updateVpnRequest.getClientToken())) {
            internalRequest.addParameter("clientToken", updateVpnRequest.getClientToken());
        }
        this.fillPayload(internalRequest, updateVpnRequest);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse deleteVpn(DeleteVpnRequest deleteVpnResquest) {
        com.google.common.base.Preconditions.checkNotNull((Object)deleteVpnResquest, (Object)"request should not be null.");
        Preconditions.checkStrIsBlank(deleteVpnResquest.getVpnId(), "vpnId");
        InternalRequest internalRequest = this.createRequest(deleteVpnResquest, HttpMethodName.DELETE, VPN_PREFIX, deleteVpnResquest.getVpnId());
        if (StringUtils.isNotBlank((CharSequence)deleteVpnResquest.getClientToken())) {
            internalRequest.addParameter("clientToken", deleteVpnResquest.getClientToken());
        }
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GetVpnResponse getVpn(String vpnId) {
        Preconditions.checkStrIsBlank(vpnId, "vpnId");
        GetVpnRequest getVpnRequest = new GetVpnRequest();
        getVpnRequest.setVpnId(vpnId);
        InternalRequest internalRequest = this.createRequest(getVpnRequest, HttpMethodName.GET, VPN_PREFIX, getVpnRequest.getVpnId());
        return this.invokeHttpClient(internalRequest, GetVpnResponse.class);
    }

    public AbstractBceResponse bindEip(BindEipRequest bindEipRequest) {
        com.google.common.base.Preconditions.checkNotNull((Object)bindEipRequest, (Object)"request should not be null.");
        Preconditions.checkStrIsBlank(bindEipRequest.getVpnId(), "vpnId");
        Preconditions.checkStrIsBlank(bindEipRequest.getEip(), "eip");
        InternalRequest internalRequest = this.createRequest(bindEipRequest, HttpMethodName.PUT, VPN_PREFIX, bindEipRequest.getVpnId());
        internalRequest.addParameter("bind", null);
        if (StringUtils.isNotBlank((CharSequence)bindEipRequest.getClientToken())) {
            internalRequest.addParameter("clientToken", bindEipRequest.getClientToken());
        }
        this.fillPayload(internalRequest, bindEipRequest);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse unBindEip(UnBindEipRequest unbindEipRequest) {
        com.google.common.base.Preconditions.checkNotNull((Object)unbindEipRequest, (Object)"request should not be null.");
        Preconditions.checkStrIsBlank(unbindEipRequest.getVpnId(), "vpnId");
        InternalRequest internalRequest = this.createRequest(unbindEipRequest, HttpMethodName.PUT, VPN_PREFIX, unbindEipRequest.getVpnId());
        internalRequest.addParameter("unbind", null);
        if (StringUtils.isNotBlank((CharSequence)unbindEipRequest.getClientToken())) {
            internalRequest.addParameter("clientToken", unbindEipRequest.getClientToken());
        }
        this.fillPayload(internalRequest, unbindEipRequest);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse renewVpn(RenewVpnRequest renewVpnRequest) {
        com.google.common.base.Preconditions.checkNotNull((Object)renewVpnRequest, (Object)"request should not be null.");
        Preconditions.checkStrIsBlank(renewVpnRequest.getVpnId(), "vpnId");
        if (renewVpnRequest.getBilling() == null) {
            renewVpnRequest.setBilling(this.generateDefaultBilling());
        }
        InternalRequest internalRequest = this.createRequest(renewVpnRequest, HttpMethodName.PUT, VPN_PREFIX, renewVpnRequest.getVpnId());
        internalRequest.addParameter("purchaseReserved", null);
        if (StringUtils.isNotBlank((CharSequence)renewVpnRequest.getClientToken())) {
            internalRequest.addParameter("clientToken", renewVpnRequest.getClientToken());
        }
        this.fillPayload(internalRequest, renewVpnRequest);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListVpnConnResponse listVpnConns(ListVpnConnRequest listVpnConnRequest) {
        com.google.common.base.Preconditions.checkNotNull((Object)listVpnConnRequest, (Object)"request should not be null.");
        Preconditions.checkStrIsBlank(listVpnConnRequest.getVpnId(), "vpnId");
        InternalRequest internalRequest = this.createRequest(listVpnConnRequest, HttpMethodName.GET, VPN_PREFIX, "vpnconn", listVpnConnRequest.getVpnId());
        return this.invokeHttpClient(internalRequest, ListVpnConnResponse.class);
    }

    public CreateVpnConnResponse createVpnConn(CreateVpnConnRequest createVpnConnRequest) {
        com.google.common.base.Preconditions.checkNotNull((Object)createVpnConnRequest, (Object)"request should not be null.");
        Preconditions.checkStrIsBlank(createVpnConnRequest.getVpnId(), "vpnId");
        Preconditions.checkStrIsBlank(createVpnConnRequest.getSecretKey(), "secretKey");
        Preconditions.checkListIsBlank(createVpnConnRequest.getLocalSubnets(), "localSubnets");
        Preconditions.checkStrIsBlank(createVpnConnRequest.getRemoteIp(), "remoteIp");
        Preconditions.checkListIsBlank(createVpnConnRequest.getRemoteSubnets(), "remoteSubnets");
        Preconditions.checkStrIsBlank(createVpnConnRequest.getVpnConnName(), "vpnConnName");
        com.google.common.base.Preconditions.checkNotNull((Object)createVpnConnRequest.getIkeConfig(), (Object)"ikeConfig should not be null.");
        com.google.common.base.Preconditions.checkNotNull((Object)createVpnConnRequest.getIpsecConfig(), (Object)"ipsecConfig should not be null.");
        InternalRequest internalRequest = this.createRequest(createVpnConnRequest, HttpMethodName.POST, VPN_PREFIX, createVpnConnRequest.getVpnId(), "vpnconn");
        if (StringUtils.isNotBlank((CharSequence)createVpnConnRequest.getClientToken())) {
            internalRequest.addParameter("clientToken", createVpnConnRequest.getClientToken());
        }
        this.fillPayload(internalRequest, createVpnConnRequest);
        return this.invokeHttpClient(internalRequest, CreateVpnConnResponse.class);
    }

    public AbstractBceResponse updateVpnConn(UpdateVpnConnRequest updateVpnConnRequest) {
        com.google.common.base.Preconditions.checkNotNull((Object)updateVpnConnRequest, (Object)"request should not be null.");
        Preconditions.checkStrIsBlank(updateVpnConnRequest.getVpnConnId(), "vpnConnId");
        Preconditions.checkStrIsBlank(updateVpnConnRequest.getVpnId(), "vpnId");
        Preconditions.checkStrIsBlank(updateVpnConnRequest.getSecretKey(), "secretKey");
        Preconditions.checkListIsBlank(updateVpnConnRequest.getLocalSubnets(), "localSubnets");
        Preconditions.checkStrIsBlank(updateVpnConnRequest.getRemoteIp(), "remoteIp");
        Preconditions.checkListIsBlank(updateVpnConnRequest.getRemoteSubnets(), "remoteSubnets");
        Preconditions.checkStrIsBlank(updateVpnConnRequest.getVpnConnName(), "vpnConnName");
        com.google.common.base.Preconditions.checkNotNull((Object)updateVpnConnRequest.getIkeConfig(), (Object)"ikeConfig should not be null.");
        com.google.common.base.Preconditions.checkNotNull((Object)updateVpnConnRequest.getIpsecConfig(), (Object)"ipsecConfig should not be null.");
        InternalRequest internalRequest = this.createRequest(updateVpnConnRequest, HttpMethodName.PUT, VPN_PREFIX, "vpnconn", updateVpnConnRequest.getVpnConnId());
        if (StringUtils.isNotBlank((CharSequence)updateVpnConnRequest.getClientToken())) {
            internalRequest.addParameter("clientToken", updateVpnConnRequest.getClientToken());
        }
        this.fillPayload(internalRequest, updateVpnConnRequest);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse deleteVpnConn(DeleteVpnConnRequest deleteVpnConnRequest) {
        com.google.common.base.Preconditions.checkNotNull((Object)deleteVpnConnRequest, (Object)"request should not be null.");
        Preconditions.checkStrIsBlank(deleteVpnConnRequest.getVpnConnId(), "vpnConnId");
        InternalRequest internalRequest = this.createRequest(deleteVpnConnRequest, HttpMethodName.DELETE, VPN_PREFIX, "vpnconn", deleteVpnConnRequest.getVpnConnId());
        if (StringUtils.isNotBlank((CharSequence)deleteVpnConnRequest.getClientToken())) {
            internalRequest.addParameter("clientToken", deleteVpnConnRequest.getClientToken());
        }
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private Billing generateDefaultBilling() {
        Billing billing = new Billing();
        billing.setPaymentTiming("Postpaid");
        billing.setBillingMethod("ByBandwidth");
        return billing;
    }

    protected void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }
}

