/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.internal;

import com.baidubce.BceClientException;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.services.bos.model.BosProgressCallback;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class RestartableFileInputStream
extends RestartableInputStream {
    private File file;
    private FileInputStream input;

    public RestartableFileInputStream(File file) throws FileNotFoundException {
        Preconditions.checkNotNull((Object)file, (Object)"file should not be null.");
        this.file = file;
        this.input = new FileInputStream(file);
    }

    public RestartableFileInputStream(File file, BosProgressCallback progressCallback) throws FileNotFoundException {
        this(file);
        super.setProgressCallback(progressCallback);
    }

    @Override
    public void restart() {
        try {
            this.input.close();
            this.input = new FileInputStream(this.file);
            super.restartProgressCallback();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to restart.", e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = this.input.read(b, off, len);
        if (count < 0) {
            return count;
        }
        super.doProgressCallback(count);
        return count;
    }

    @Override
    public int read() throws IOException {
        int count = this.input.read();
        if (count < 0) {
            return count;
        }
        super.doProgressCallback(1);
        return count;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

