/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model;

import com.baidubce.BceClientException;
import com.baidubce.services.tablestorage.model.AbstractTableStorageRequest;
import com.baidubce.services.tablestorage.model.CompressType;
import com.baidubce.services.tablestorage.model.TableOption;

public class UpdateTableRequest
extends AbstractTableStorageRequest {
    private TableOption tableOption;

    public UpdateTableRequest(String tableName, TableOption option) {
        super(tableName);
        this.tableOption = option;
    }

    @Override
    public String toJsonString() {
        long timeToLive;
        StringBuffer buffer = new StringBuffer("{");
        long tableVersion = this.tableOption.getTableVersion();
        if (tableVersion < 0L) {
            throw new BceClientException("The tableVersion's value should not be negative.");
        }
        if (tableVersion == 0L) {
            throw new BceClientException("The tableVersion's value cannot be 0 in UpdateTableRequest.");
        }
        buffer.append("\"tableVersion\":");
        buffer.append(this.tableOption.getTableVersion());
        if (this.tableOption.getCompressType() != CompressType.DEFAULT) {
            buffer.append(",\"compressType\":\"");
            buffer.append(this.tableOption.getCompressType().toString());
            buffer.append("\"");
        }
        if ((timeToLive = this.tableOption.getTimeToLive()) >= 82800L || timeToLive == 0L) {
            buffer.append(",\"ttl\":");
            buffer.append(this.tableOption.getTimeToLive());
        } else if (timeToLive != -1L) {
            throw new BceClientException("The timeToLive's value must be -1 or greater than 82800. timeToLive=" + timeToLive + ".");
        }
        int maxVersions = this.tableOption.getMaxVersions();
        if (maxVersions > 0) {
            buffer.append(",\"maxVersions\":");
            buffer.append(this.tableOption.getMaxVersions());
        } else if (this.tableOption.getMaxVersions() != 0) {
            throw new BceClientException("The maxVersions' value must be positive, or equal to DEFAULT_TABLE_MAX_VERSIONS 0. maxVersions=" + maxVersions + ".");
        }
        buffer.append("}");
        return buffer.toString();
    }
}

