/*
 * Copyright (c) 2014-2020 Baidu.com, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.bcc.model.volume;

/**
 * The action for operating the volume.
 */
public enum VolumeAction {

    /**
     * The action to attach the volume.
     */
    attach,

    /**
     * The action to detach the volume.
     */
    detach,

    /**
     * The action to resize the volume.
     */
    resize,

    /**
     * The action to rollback the volume.
     */
    rollback,

    /**
     * The action to purchaseReserved the volume.
     */
    purchaseReserved,

    /**
     * The action to modify the attribute of the volume.
     */
    modify,

    /**
     * The action to modify charge type of the volume.
     */
    modifyChargeType,

    /**
     * The action to enable auto renewal to volume
     */
    autoRenew,

    /**
     * The action to disable auto renewal to volume
     */
    cancelAutoRenew,

    /**
     * The action to rename the volume
     */
    rename
}
