/*
 * Copyright (c) 2023 Baidu.com, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package com.baidubce.services.bci.model.instance;

import com.baidubce.services.bci.model.common.Tag;
import com.baidubce.services.bci.model.common.ImageRegistryCredential;
import com.baidubce.services.bci.model.container.Container;
import com.baidubce.services.bci.model.volume.Volume;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;

import java.util.List;

/**
 * The request for creating instance
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreateInstanceRequest extends AbstractBceRequest {

    /**
     * An ASCII string whose length is less than 64.
     * <p>
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * <p>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * The name of instance
     */
    private String name = "";

    /**
     * The zone id of instance
     */
    private String zoneName = "";

    /**
     * The security group id of instance
     */
    private List<String> securityGroupIds;

    /**
     * The subnet id of instance
     */
    private List<String> subnetIds;

    /**
     * The restart policy of instance
     */
    private String restartPolicy = "";

    /**
     * The elastic ip of instance
     */
    private String eipIp = "";

    /**
     * The elastic ip name of instance
     */
    private String eipName = "eip";

    /**
     * The elastic ip auto create of instance
     */
    private Boolean autoCreateEip = false;

    /**
     * The elastic ip route type of instance
     * BGP(default) or BGP_S
     */
    private String eipRouteType = "BGP";

    /**
     * The elastic ip bandwidth of instance
     * BGP: 1~500
     * BGP_S: 100~5000
     */
    private Integer eipBandwidthInMbps = 100;

    /**
     * The elastic ip payment timing of instance
     * Postpaid(default) or Prepaid
     */
    private String eipPaymentTiming = "Postpaid";

    /**
     * The elastic ip billing method of instance
     * ByTraffic(default) or ByBandwidth or ByPeak95
     */
    private String eipBillingMethod = "ByTraffic";

    /**
     * The elastic ip auto renew time unit of instance
     * month(default) or year
     */
    private String eipAutoRenewTimeUnit = "month";

    /**
     * The elastic ip auto renew time of instance
     * month: 1~9
     * year: 1~3
     */
    private int eipAutoRenewTime = 1;


    /**
     * The cpu type of instance
     */
    private String cpuType;

    /**
     * The gpu type of instance
     * Supported types:
     *  Nvidia A10 PCIE
     */
    private String gpuType;

    /**
     * The grace period of instance
     */
    private Long terminationGracePeriodSeconds;

    /**
     * The host name of instance
     */
    private String hostName = "";

    /**
     * The tags of the instance.
     */
    private List<Tag> tags;

    /**
     * The image registry credentials of the instance.
     */
    private List<ImageRegistryCredential> imageRegistryCredentials;

    /**
     * The containers of the instance.
     */
    private List<Container> containers;

    /**
     * The init containers of the instance.
     */
    private List<Container> initContainers;

    /**
     * The volumes of the instance.
     */
    private Volume volume;

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return CreateInstanceRequest with credentials.
     */
    public CreateInstanceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    public String getClientToken() {
        return clientToken;
    }

    public CreateInstanceRequest setClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public String getName() {
        return name;
    }

    public CreateInstanceRequest setName(String name) {
        this.name = name;
        return this;
    }

    public String getZoneName() {
        return zoneName;
    }

    public CreateInstanceRequest setZoneName(String zoneName) {
        this.zoneName = zoneName;
        return this;
    }

    public List<String> getSecurityGroupIds() {
        return securityGroupIds;
    }

    public CreateInstanceRequest setSecurityGroupIds(List<String> securityGroupIds) {
        this.securityGroupIds = securityGroupIds;
        return this;
    }

    public List<String> getSubnetIds() {
        return subnetIds;
    }

    public CreateInstanceRequest setSubnetIds(List<String> subnetIds) {
        this.subnetIds = subnetIds;
        return this;
    }

    public String getRestartPolicy() {
        return restartPolicy;
    }

    public CreateInstanceRequest setRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    public String getEipIp() {
        return eipIp;
    }

    public CreateInstanceRequest setEipIp(String eipIp) {
        this.eipIp = eipIp;
        return this;
    }

    public String getEipName() {
        return eipName;
    }

    public CreateInstanceRequest setEipName(String eipName) {
        this.eipName = eipName;
        return this;
    }

    public Boolean getAutoCreateEip() {
        return autoCreateEip;
    }

    public CreateInstanceRequest setAutoCreateEip(Boolean autoCreateEip) {
        this.autoCreateEip = autoCreateEip;
        return this;
    }

    public String getEipRouteType() {
        return eipRouteType;
    }

    public CreateInstanceRequest setEipRouteType(String eipRouteType) {
        this.eipRouteType = eipRouteType;
        return this;
    }

    public Integer getEipBandwidthInMbps() {
        return eipBandwidthInMbps;
    }

    public CreateInstanceRequest setEipBandwidthInMbps(Integer eipBandwidthInMbps) {
        this.eipBandwidthInMbps = eipBandwidthInMbps;
        return this;
    }

    public String getEipPaymentTiming() {
        return eipPaymentTiming;
    }

    public CreateInstanceRequest setEipPaymentTiming(String eipPaymentTiming) {
        this.eipPaymentTiming = eipPaymentTiming;
        return this;
    }

    public String getEipBillingMethod() {
        return eipBillingMethod;
    }

    public CreateInstanceRequest setEipBillingMethod(String eipBillingMethod) {
        this.eipBillingMethod = eipBillingMethod;
        return this;
    }

    public String getEipAutoRenewTimeUnit() {
        return eipAutoRenewTimeUnit;
    }

    public CreateInstanceRequest setEipAutoRenewTimeUnit(String eipAutoRenewTimeUnit) {
        this.eipAutoRenewTimeUnit = eipAutoRenewTimeUnit;
        return this;
    }

    public int getEipAutoRenewTime() {
        return eipAutoRenewTime;
    }

    public CreateInstanceRequest setEipAutoRenewTime(int eipAutoRenewTime) {
        this.eipAutoRenewTime = eipAutoRenewTime;
        return this;
    }

    public String getCpuType() {
        return cpuType;
    }

    public CreateInstanceRequest setCpuType(String cpuType) {
        this.cpuType = cpuType;
        return this;
    }

    public String getGpuType() {
        return gpuType;
    }

    public CreateInstanceRequest setGpuType(String gpuType) {
        this.gpuType = gpuType;
        return this;
    }

    public Long getTerminationGracePeriodSeconds() {
        return terminationGracePeriodSeconds;
    }

    public CreateInstanceRequest setTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return this;
    }

    public String getHostName() {
        return hostName;
    }

    public CreateInstanceRequest setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public List<Tag> getTags() {
        return tags;
    }

    public CreateInstanceRequest setTags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    public List<ImageRegistryCredential> getImageRegistryCredentials() {
        return imageRegistryCredentials;
    }

    public CreateInstanceRequest setImageRegistryCredentials(List<ImageRegistryCredential> imageRegistryCredentials) {
        this.imageRegistryCredentials = imageRegistryCredentials;
        return this;
    }

    public List<Container> getContainers() {
        return containers;
    }

    public CreateInstanceRequest setContainers(List<Container> containers) {
        this.containers = containers;
        return this;
    }

    public List<Container> getInitContainers() {
        return initContainers;
    }

    public CreateInstanceRequest setInitContainers(List<Container> initContainers) {
        this.initContainers = initContainers;
        return this;
    }

    public Volume getVolume() {
        return volume;
    }

    public CreateInstanceRequest setVolume(Volume volume) {
        this.volume = volume;
        return this;
    }
}