/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.eipbp;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.eipbp.model.CreateEipBpRequest;
import com.baidubce.services.eipbp.model.CreateEipBpResponse;
import com.baidubce.services.eipbp.model.EipBpDetailResponse;
import com.baidubce.services.eipbp.model.GetEipBpRequest;
import com.baidubce.services.eipbp.model.ListEipBpsRequest;
import com.baidubce.services.eipbp.model.ListEipBpsResponse;
import com.baidubce.services.eipbp.model.ReleaseEipBpRequest;
import com.baidubce.services.eipbp.model.ResizeEipBpRequest;
import com.baidubce.services.eipbp.model.UpdateEipBpAutoReleaseTimeRequest;
import com.baidubce.services.eipbp.model.UpdateEipBpNameRequest;
import com.baidubce.util.DateUtils;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;

public class EipBpClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String PREFIX = "eipbp";
    private static final String CLIENT_TOKEN_IDENTIFY = "clientToken";
    private static final String RESIZE_ACTION = "resize";
    private static final String RENAME_ACTION = "rename";
    private static final String RETIME_ACTION = "retime";
    private static HttpResponseHandler[] eipHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public EipBpClient() {
        this(new BceClientConfiguration());
    }

    public EipBpClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, eipHandlers);
    }

    public CreateEipBpResponse createEipBp(CreateEipBpRequest request) {
        Validate.checkNotNull(request.getBandwidthInMbps(), "bandwidthInMbps should not be blank!");
        Validate.checkMultyParamsNotBothEmpty(Arrays.asList(request.getEip(), request.getEipGroupId()), "eip and eipGroupId should not be both blank!");
        DateUtils.validateUtcDate(request.getAutoReleaseTime());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateEipBpResponse.class);
    }

    public void resizeEipBp(ResizeEipBpRequest request) {
        Validate.checkNotNull(request.getId(), "id should not be blank!");
        Validate.checkNotNull(request.getBandwidthInMbps(), "bandwidthInMbps should not be blank!");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, request.getId());
        internalRequest.addParameter(RESIZE_ACTION, null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, CreateEipBpResponse.class);
    }

    public void resizeEipBp(String id, Integer bandwidthInMbps) {
        ResizeEipBpRequest resizeEipBpRequest = new ResizeEipBpRequest();
        resizeEipBpRequest.setId(id);
        resizeEipBpRequest.setBandwidthInMbps(bandwidthInMbps);
        this.resizeEipBp(resizeEipBpRequest);
    }

    public EipBpDetailResponse getEipBpDetail(GetEipBpRequest request) {
        Validate.checkNotNull(request.getId(), "id should not be blank!");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, request.getId());
        return this.invokeHttpClient(internalRequest, EipBpDetailResponse.class);
    }

    public EipBpDetailResponse getEipBpDetail(String id) {
        GetEipBpRequest getEipBpRequest = new GetEipBpRequest();
        getEipBpRequest.setId(id);
        return this.getEipBpDetail(getEipBpRequest);
    }

    public ListEipBpsResponse listEipBps(ListEipBpsRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, null);
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() >= 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getId())) {
            internalRequest.addParameter("id", request.getId());
        }
        if (!Strings.isNullOrEmpty((String)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        if (!Strings.isNullOrEmpty((String)request.getBindType())) {
            internalRequest.addParameter("bindType", request.getBindType());
        }
        return this.invokeHttpClient(internalRequest, ListEipBpsResponse.class);
    }

    public ListEipBpsResponse listEipBps() {
        ListEipBpsRequest request = new ListEipBpsRequest();
        return this.listEipBps(request);
    }

    public ListEipBpsResponse listEipBps(String id, String name, String bindType) {
        ListEipBpsRequest request = new ListEipBpsRequest();
        request.withId(id).withName(name).withBindType(bindType);
        return this.listEipBps(request);
    }

    public void renameEipBp(UpdateEipBpNameRequest request) {
        Validate.checkNotNull(request.getId(), "id should not be blank!");
        Validate.checkNotNull(request.getName(), "bandwidthInMbps should not be blank!");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, request.getId());
        internalRequest.addParameter(RENAME_ACTION, null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, CreateEipBpResponse.class);
    }

    public void renameEipBp(String id, String name) {
        UpdateEipBpNameRequest updateEipBpNameRequest = new UpdateEipBpNameRequest();
        updateEipBpNameRequest.withId(id).withName(name);
        this.renameEipBp(updateEipBpNameRequest);
    }

    public void updateAutoReleaseTime(UpdateEipBpAutoReleaseTimeRequest request) {
        Validate.checkNotNull(request.getId(), "id should not be blank!");
        Validate.checkNotNull(request.getAutoReleaseTime(), "autoReleaseTime should not be blank!");
        DateUtils.validateUtcDate(request.getAutoReleaseTime());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, request.getId());
        internalRequest.addParameter(RETIME_ACTION, null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, CreateEipBpResponse.class);
    }

    public void updateAutoReleaseTime(String id, String autoReleaseTime) {
        UpdateEipBpAutoReleaseTimeRequest updateEipBpNameRequest = new UpdateEipBpAutoReleaseTimeRequest();
        updateEipBpNameRequest.withId(id).withAutoReleaseTime(autoReleaseTime);
        this.updateAutoReleaseTime(updateEipBpNameRequest);
    }

    public void releaseEipBp(ReleaseEipBpRequest request) {
        Validate.checkNotNull(request.getId(), "id should not be blank!");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, request.getId());
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.invokeHttpClient(internalRequest, CreateEipBpResponse.class);
    }

    public void releaseEipBp(String id) {
        ReleaseEipBpRequest releaseEipBpRequest = new ReleaseEipBpRequest();
        this.releaseEipBp(releaseEipBpRequest.withId(id));
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        path.add(PREFIX);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    protected void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateDefaultClientToken() {
        return UUID.randomUUID().toString();
    }
}

