/*
 * Copyright 2021 Baidu, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.demo.v2;

import java.util.Map;

import com.baidubce.BceClientConfiguration;
import com.baidubce.common.ApiInfo;
import com.baidubce.common.BaseBceClient;
import com.baidubce.common.BceRegion;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.demo.v2.api.DemoApi;
import com.baidubce.services.demo.v2.model.ListInstancesResponse;
import com.google.common.collect.ImmutableMap;

/**
 * Demo
 */
public class DemoClient extends BaseBceClient {
    // ------Endpoints------
    // map of all endpoints
    private static final Map<BceRegion, String> ENDPOINTS = ImmutableMap.<BceRegion, String>builder()
            .put(BceRegion.BJ, "https://bcc.bj.baidubce.com	")
            .put(BceRegion.GZ, "https://bcc.gz.baidubce.com")
            .put(BceRegion.SU, "https://bcc.su.baidubce.com")
            .build();
    // ------Endpoints------

    // ------ServiceInfo------
    /**
     * Service name for extra config and handler.
     */
    private static final String SERVICE_ID = "Demo";

    /**
     * Constructs a new client to invoke service methods on demo with region.
     */
    public DemoClient(String ak, String sk, BceRegion region) {
        super(SERVICE_ID, ak, sk, ENDPOINTS.get(region));
    }

    /**
     * Constructs a new client to invoke service methods on demo.
     */
    public DemoClient(String ak, String sk) {
        super(SERVICE_ID, ak, sk, ENDPOINTS.get(BceRegion.DEFAULT));
    }

    /**
     * Constructs a new client to invoke service methods on demo.
     */
    public DemoClient(BceClientConfiguration configuration) {
        super(configuration);
    }

    /**
     * Api lists
     */
    private static final Map<String, ApiInfo> DEMO_APIS = DemoApi.getApis();

    /**
     * 查询所有实例的详细信息。
     *
     * @param marker 批量获取列表的查询的起始位置，是一个由系统生成的字符串
     * @param markerKeys 每页包含的最大数量，最大数量通常不超过1000，缺省值为1000
     * @param internalIp 内网IP
     * @param dedicatedHostId 专属服务器id
     * @param zoneName 可用区信息
     * @param autoRenew 是否自动续费
     * @return ListInstancesResponse
     */
    public ListInstancesResponse listInstances(String marker, Integer markerKeys, String internalIp,
                                               String dedicatedHostId, String zoneName, Boolean autoRenew) {
        ApiInfo apiInfo = new ApiInfo(DEMO_APIS.get("listInstances"));
        String apiPath = apiInfo.getPath().get();
        apiInfo.getQueries().put("marker", marker);
        apiInfo.getQueries().put("markerKeys", String.valueOf(markerKeys));
        apiInfo.getQueries().put("internalIp", internalIp);
        apiInfo.getQueries().put("dedicatedHostId", dedicatedHostId);
        apiInfo.getQueries().put("zoneName", zoneName);
        apiInfo.getQueries().put("autoRenew", String.valueOf(autoRenew));
        InternalRequest internalRequest = createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(),
                apiInfo.getHeaders(), null);
        return invokeHttpClient(internalRequest, ListInstancesResponse.class);
    }

}
