/*
 * Copyright 2021 Baidu, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.demo.v2.api;

import java.util.HashMap;
import java.util.Map;

import com.baidubce.common.ApiInfo;
import com.baidubce.common.ApiPath;
import com.baidubce.http.HttpMethodName;

public class DemoApi {
    /**
     * Api list with api name
     */
    private static Map<String, ApiInfo> APIS = new HashMap<String, ApiInfo>();

    public static Map<String, ApiInfo> getApis() {
        // 查询所有实例的详细信息。
        APIS.put("listInstances", new ApiInfo(
                HttpMethodName.valueOf("GET"),
                new ApiPath("/v2/instance"),
                new HashMap<String, String>() {
                    {
                        put("marker", null);
                        put("markerKeys", null);
                        put("internalIp", null);
                        put("dedicatedHostId", null);
                        put("zoneName", null);
                        put("autoRenew", null);
                    }
                },
                new HashMap<String, String>()));
        return APIS;
    }
}
