/*
 * Copyright 2016-2019 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package com.baidubce.services.cdn.model.stat;

import com.baidubce.services.cdn.model.CdnResponse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * The result of metric query
 * 
 */
public class GetStatMetricResponse extends CdnResponse {

    private static final long serialVersionUID = 1L;

    private String status;

    /**
     *
     */
    private List<Map<String, Object>> details = new ArrayList<Map<String, Object>>();

    private Long count;

    /**
     * @param details
     */
    public void setDetails(List<Map<String, Object>> details) {
        this.details = details;
    }

    /**
     * @return details
     */
    public List<Map<String, Object>> getDetails() {
        return details;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getCount() {
        return count;
    }

    public void setCount(Long count) {
        this.count = count;
    }
}
