/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.internal;

import com.baidubce.internal.RestartableResettableInputStream;
import com.baidubce.services.bos.model.BosProgressCallback;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public abstract class RestartableInputStream
extends InputStream {
    private BosProgressCallback progressCallback = null;

    public abstract void restart();

    public static RestartableInputStream wrap(byte[] b) {
        ByteArrayInputStream input = new ByteArrayInputStream(b);
        input.mark(b.length);
        return new RestartableResettableInputStream(input);
    }

    public void setProgressCallback(BosProgressCallback progressCallback) {
        this.progressCallback = progressCallback;
    }

    public void doProgressCallback(int count) {
        if (this.progressCallback != null) {
            this.progressCallback.addCurrentSize(count);
        }
    }

    public void restartProgressCallback() {
        if (this.progressCallback != null) {
            this.progressCallback.setCurrentSize(0L);
        }
    }
}

