/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iotdmp.model.device;

import com.baidubce.model.GenericAccountRequest;
import com.baidubce.services.iotdmp.model.device.AuthType;
import com.baidubce.services.iotdmp.model.device.ResourceType;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GetDeviceConnectionInfoRequest
extends GenericAccountRequest {
    @NonNull
    private ResourceType resourceType;
    private boolean permanentConnect;
    private AuthType authType = AuthType.SIGNATURE;

    public static GetDeviceConnectionInfoRequestBuilder builder() {
        return new GetDeviceConnectionInfoRequestBuilder();
    }

    @NonNull
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public boolean isPermanentConnect() {
        return this.permanentConnect;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public void setResourceType(@NonNull ResourceType resourceType) {
        if (resourceType == null) {
            throw new NullPointerException("resourceType is marked @NonNull but is null");
        }
        this.resourceType = resourceType;
    }

    public void setPermanentConnect(boolean permanentConnect) {
        this.permanentConnect = permanentConnect;
    }

    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetDeviceConnectionInfoRequest)) {
            return false;
        }
        GetDeviceConnectionInfoRequest other = (GetDeviceConnectionInfoRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResourceType this$resourceType = this.getResourceType();
        ResourceType other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !((Object)((Object)this$resourceType)).equals((Object)other$resourceType)) {
            return false;
        }
        if (this.isPermanentConnect() != other.isPermanentConnect()) {
            return false;
        }
        AuthType this$authType = this.getAuthType();
        AuthType other$authType = other.getAuthType();
        return !(this$authType == null ? other$authType != null : !((Object)((Object)this$authType)).equals((Object)other$authType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetDeviceConnectionInfoRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceType $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : ((Object)((Object)$resourceType)).hashCode());
        result = result * 59 + (this.isPermanentConnect() ? 79 : 97);
        AuthType $authType = this.getAuthType();
        result = result * 59 + ($authType == null ? 43 : ((Object)((Object)$authType)).hashCode());
        return result;
    }

    public String toString() {
        return "GetDeviceConnectionInfoRequest(resourceType=" + (Object)((Object)this.getResourceType()) + ", permanentConnect=" + this.isPermanentConnect() + ", authType=" + (Object)((Object)this.getAuthType()) + ")";
    }

    public GetDeviceConnectionInfoRequest(@NonNull ResourceType resourceType, boolean permanentConnect, AuthType authType) {
        if (resourceType == null) {
            throw new NullPointerException("resourceType is marked @NonNull but is null");
        }
        this.resourceType = resourceType;
        this.permanentConnect = permanentConnect;
        this.authType = authType;
    }

    public GetDeviceConnectionInfoRequest(@NonNull ResourceType resourceType) {
        if (resourceType == null) {
            throw new NullPointerException("resourceType is marked @NonNull but is null");
        }
        this.resourceType = resourceType;
    }

    public static class GetDeviceConnectionInfoRequestBuilder {
        private ResourceType resourceType;
        private boolean permanentConnect;
        private AuthType authType;

        GetDeviceConnectionInfoRequestBuilder() {
        }

        public GetDeviceConnectionInfoRequestBuilder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public GetDeviceConnectionInfoRequestBuilder permanentConnect(boolean permanentConnect) {
            this.permanentConnect = permanentConnect;
            return this;
        }

        public GetDeviceConnectionInfoRequestBuilder authType(AuthType authType) {
            this.authType = authType;
            return this;
        }

        public GetDeviceConnectionInfoRequest build() {
            return new GetDeviceConnectionInfoRequest(this.resourceType, this.permanentConnect, this.authType);
        }

        public String toString() {
            return "GetDeviceConnectionInfoRequest.GetDeviceConnectionInfoRequestBuilder(resourceType=" + (Object)((Object)this.resourceType) + ", permanentConnect=" + this.permanentConnect + ", authType=" + (Object)((Object)this.authType) + ")";
        }
    }
}

