/*
 * Copyright 2023 Baidu, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.localdns.model;

import java.util.List;

import com.baidubce.common.BaseBceResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ListPrivateZoneResponse extends BaseBceResponse {
    /**
     * 标记查询的起始位置
     */
    private String marker;

    /**
     * true表示后面还有数据，false表示已经是最后一页
     */
    private Boolean isTruncated;

    /**
     * 获取下一页所需要传递的marker值。当isTruncated为false时，该域不出现
     */
    private String nextMarker;

    /**
     * 每页包含的最大数量
     */
    private Integer maxKeys;

    /**
     * Zone列表
     */
    private List<Zone> zones;

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public Boolean isIsTruncated() {
        return this.isTruncated;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setMaxKeys(Integer maxKeys) {
        this.maxKeys = maxKeys;
    }

    public Integer getMaxKeys() {
        return this.maxKeys;
    }

    public void setZones(List<Zone> zones) {
        this.zones = zones;
    }

    public List<Zone> getZones() {
        return this.zones;
    }

    @Override
    public String toString() {
        return "ListPrivateZoneResponse{"
                + "marker=" + marker + "\n"
                + "isTruncated=" + isTruncated + "\n"
                + "nextMarker=" + nextMarker + "\n"
                + "maxKeys=" + maxKeys + "\n"
                + "zones=" + zones + "\n"
                + "}";
    }

    public static class Zone {
        private String zoneId;
    
        private String zoneName;
    
        private Integer recordCount;
    
        private String createTime;
    
        private String updateTime;
    
        public void setZoneId(String zoneId) {
            this.zoneId = zoneId;
        }
    
        public String getZoneId() {
            return this.zoneId;
        }
    
        public void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }
    
        public String getZoneName() {
            return this.zoneName;
        }
    
        public void setRecordCount(Integer recordCount) {
            this.recordCount = recordCount;
        }
    
        public Integer getRecordCount() {
            return this.recordCount;
        }
    
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }
    
        public String getCreateTime() {
            return this.createTime;
        }
    
        public void setUpdateTime(String updateTime) {
            this.updateTime = updateTime;
        }
    
        public String getUpdateTime() {
            return this.updateTime;
        }
    
        @Override
        public String toString() {
            return "Zone{"
                    + "zoneId=" + zoneId + "\n"
                    + "zoneName=" + zoneName + "\n"
                    + "recordCount=" + recordCount + "\n"
                    + "createTime=" + createTime + "\n"
                    + "updateTime=" + updateTime + "\n"
                    + "}";
        }
    }

}