package com.baidubce.services.nat.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;

/**
 * The request for updating one dnat rule in the specified dnat.
 */
@Getter
@Setter
public class UpdateDnatRuleRequest extends AbstractBceRequest {

    /**
     * An ASCII string whose length is less than 64.
     * <p>
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * The nat id of the specified dnat
     */
    @JsonIgnore
    private String natId;

    /**
     * The id of the dnat rule to de updated
     */
    @JsonIgnore
    private String ruleId;

    /**
     * The name of the dnat rule
     */
    private String ruleName;

    /**
     * The type of protocol
     */
    private String protocol;

    /**
     * The public port
     */
    private Integer publicPort;

    /**
     * The private port
     */
    private Integer privatePort;

    /**
     * The public ip address
     */
    private String publicIpAddress;

    /**
     * The private ip address
     */
    private String privateIpAddress;

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return UpdateDnatRuleRequest with credentials.
     */
    @Override
    public UpdateDnatRuleRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
