/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bcm;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bcm.model.Dimension;
import com.baidubce.services.bcm.model.ListMetricDataRequest;
import com.baidubce.services.bcm.model.ListMetricDataResponse;
import com.baidubce.services.bcm.model.MetricDataRequest;
import com.baidubce.services.bcm.model.MetricDataResponse;
import com.baidubce.services.bcm.model.PushCustomMetricDataRequest;
import com.baidubce.services.bcm.model.PushMetricDataResponse;
import com.baidubce.services.bcm.model.Statistics;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class BcmClient
extends AbstractBceClient {
    private static final String PREFIX = "json-api";
    private static final String V1 = "v1";
    private static final String V3 = "v3";
    private static final String METRIC_DATA = "metricdata";
    private static final String METRIC_NAME = "metricName";
    private static final String PUSH_CUSTOM_METRIC_DATA_FORMAT = "/csm/api/v1/userId/%s/custom/data";
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String PERIOD_ERROR_MESSAGE = "request %s should be a multiple of 60.";
    private static final String USER_ID_MESSAGE_KEY = "userId";
    private static final String SCOPE_MESSAGE_KEY = "scope";
    private static final String STATISTICS_ARR_MESSAGE_KEY = "statistics[]";
    private static final String START_TIME_MESSAGE_KEY = "startTime";
    private static final String END_TIME_MESSAGE_KEY = "endTime";
    private static final String TIMESTAMP_MESSAGE_KEY = "timestamp";
    private static final String PERIOD_MESSAGE_KEY = "periodInSecond";
    private static final String DIMENSIONS_MESSAGE_KEY = "dimensions";
    private static final String METRIC_NAME_MESSAGE_KEY = "metricName";
    private static final String METRIC_NAMES_MESSAGE_KEY = "metricName[]";
    private static final String NAMESPACE_MESSAGE_KEY = "namespace";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] BCM_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public BcmClient() {
        this(new BceClientConfiguration());
    }

    public BcmClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, BCM_HANDLERS);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(PREFIX);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private InternalRequest createBodyRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String url) {
        URI uri = HttpUtils.appendUri(this.getEndpoint(), url);
        InternalRequest request = new InternalRequest(httpMethod, uri);
        this.fillPayload(request, bceRequest);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    protected void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private void checkV1Request(AbstractBceRequest request, InternalRequest internalRequest, String userId, String scope, Statistics[] statistics, String startTime, String endTime, Integer periodInSecond) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(userId, StringFormatUtils.checkEmptyExceptionMessageFormat(USER_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(scope, StringFormatUtils.checkEmptyExceptionMessageFormat(SCOPE_MESSAGE_KEY));
        Preconditions.checkNotNull((Object)statistics, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat(STATISTICS_ARR_MESSAGE_KEY));
        Preconditions.checkArgument((statistics.length != 0 ? 1 : 0) != 0, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat(STATISTICS_ARR_MESSAGE_KEY));
        Validate.checkStringNotEmpty(startTime, StringFormatUtils.checkEmptyExceptionMessageFormat(START_TIME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(endTime, StringFormatUtils.checkEmptyExceptionMessageFormat(END_TIME_MESSAGE_KEY));
        Preconditions.checkNotNull((Object)periodInSecond, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat(PERIOD_MESSAGE_KEY));
        Preconditions.checkArgument((periodInSecond / 60 != 0 ? 1 : 0) != 0, (Object)StringFormatUtils.stringFormat(PERIOD_ERROR_MESSAGE, PERIOD_MESSAGE_KEY));
        internalRequest.addParameter(STATISTICS_ARR_MESSAGE_KEY, StringUtils.join((Object[])statistics, (String)","));
        internalRequest.addParameter(START_TIME_MESSAGE_KEY, startTime);
        internalRequest.addParameter(END_TIME_MESSAGE_KEY, endTime);
        internalRequest.addParameter(PERIOD_MESSAGE_KEY, String.valueOf(periodInSecond));
    }

    public MetricDataResponse getMetricData(MetricDataRequest request) {
        Validate.checkStringNotEmpty(request.getMetricName(), StringFormatUtils.checkEmptyExceptionMessageFormat("metricName"));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, V1, METRIC_DATA, request.getUserId(), request.getScope(), request.getMetricName());
        this.checkV1Request(request, internalRequest, request.getUserId(), request.getScope(), request.getStatistics(), request.getStartTime(), request.getEndTime(), request.getPeriodInSecond());
        Validate.checkStringNotEmpty(request.getDimensions(), StringFormatUtils.checkEmptyExceptionMessageFormat(DIMENSIONS_MESSAGE_KEY));
        internalRequest.addParameter(DIMENSIONS_MESSAGE_KEY, request.getDimensions());
        return this.invokeHttpClient(internalRequest, MetricDataResponse.class);
    }

    public ListMetricDataResponse getMetricData(ListMetricDataRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, V1, METRIC_DATA, "metricName", request.getUserId(), request.getScope());
        this.checkV1Request(request, internalRequest, request.getUserId(), request.getScope(), request.getStatistics(), request.getStartTime(), request.getEndTime(), request.getPeriodInSecond());
        Preconditions.checkNotNull((Object)request.getMetricNames(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat(METRIC_NAMES_MESSAGE_KEY));
        Preconditions.checkArgument((request.getMetricNames().length != 0 ? 1 : 0) != 0, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat(METRIC_NAMES_MESSAGE_KEY));
        internalRequest.addParameter(METRIC_NAMES_MESSAGE_KEY, StringUtils.join((Object[])request.getMetricNames(), (String)","));
        Validate.checkStringNotEmpty(request.getDimensions(), StringFormatUtils.checkEmptyExceptionMessageFormat(DIMENSIONS_MESSAGE_KEY));
        internalRequest.addParameter(DIMENSIONS_MESSAGE_KEY, request.getDimensions());
        return this.invokeHttpClient(internalRequest, ListMetricDataResponse.class);
    }

    public PushMetricDataResponse pushCustomMonitorMetricData(PushCustomMetricDataRequest request) {
        this.checkAndFormatPushCustomMetricDataRequest(request);
        String url = String.format(PUSH_CUSTOM_METRIC_DATA_FORMAT, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, PushMetricDataResponse.class);
    }

    private void checkAndFormatPushCustomMetricDataRequest(PushCustomMetricDataRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat(USER_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getTimestamp(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAMESPACE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getMetricName(), StringFormatUtils.checkEmptyExceptionMessageFormat("metricName"));
        Validate.checkStringNotEmpty(request.getTimestamp(), StringFormatUtils.checkEmptyExceptionMessageFormat(TIMESTAMP_MESSAGE_KEY));
        if (null == request.getValue() && null == request.getStatisticValues()) {
            throw new IllegalArgumentException("value and statistics all should not be null.");
        }
        if (null == request.getDimensions()) {
            request.setDimensions(Collections.<Dimension>emptyList());
        }
    }
}

