/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iothisk.device;

import com.baidubce.services.iothisk.device.model.ActiveMessage;
import com.baidubce.services.iothisk.device.model.CipherMessage;
import com.baidubce.services.iothisk.device.model.Device;
import com.baidubce.services.iothisk.device.model.DeviceKey;
import com.baidubce.services.iothisk.device.model.PlainMessage;
import com.baidubce.services.iothisk.device.seplatform.SecureElement;
import com.baidubce.services.iothisk.device.seplatform.SecureElementFactory;
import com.baidubce.services.iothisk.device.utils.CounterUtils;
import com.google.common.base.Preconditions;
import java.security.Provider;
import java.security.Security;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class IotHiskDevice {
    private final Device device;
    private final DeviceKey deviceKey;
    private long currentCounter = 0L;
    private static final int SERIAL_NUMBER_MAX_LENGTH = 32;
    private static final int DEVICE_COMPANY_MAX_LENGTH = 32;
    private static final int DEVICE_TYPE_MAX_LENGTH = 48;
    private static final int DEVICE_COMPANY_AND_TYPE_MIN_LENTH = 3;
    private static final Pattern namePattern = Pattern.compile("[\u4e00-\u9fa5\\w-]+");

    public IotHiskDevice(Device device) {
        Preconditions.checkNotNull((Object)device, (Object)"contract should not be null");
        IotHiskDevice.validDevice(device);
        this.device = device;
        this.deviceKey = this.generateDeviceKey(device);
    }

    public String getDeviceId() {
        return this.deviceKey.getDeviceId();
    }

    public byte[] getActiveData() {
        ActiveMessage activeMessage = new ActiveMessage();
        activeMessage.setDeviceId(this.deviceKey.getDeviceId());
        activeMessage.setSdkType(this.device.getDeviceSdkType());
        activeMessage.setSeId(this.deviceKey.getSeId());
        return this.encrypt(activeMessage.getBytes());
    }

    public byte[] encrypt(byte[] message) {
        PlainMessage plainMessage = new PlainMessage(this.getCurrentCounter(), message);
        return this.deviceKey.getSe().encryptThenSign(plainMessage).getBytes();
    }

    public byte[] decrypt(byte[] cipherMessage) {
        CipherMessage cipher = this.deviceKey.getSe().parseCipherMessage(cipherMessage);
        PlainMessage plainMessage = this.deviceKey.getSe().verifyThenDecrypt(cipher);
        CounterUtils.validCounter(this.device.getDeviceSdkType(), plainMessage.getCounter(), this.getCurrentCounter());
        this.setCurrentCounter(plainMessage.getCounter());
        return plainMessage.getMessage();
    }

    public long getCurrentCounter() {
        switch (this.device.getDeviceSdkType()) {
            case NONE_RTC: {
                return this.currentCounter;
            }
            case RTC: {
                return System.currentTimeMillis() / 1000L;
            }
            case NONE_COUNTER: {
                return System.currentTimeMillis() / 1000L;
            }
        }
        throw new IllegalArgumentException("Unknown device key sdk type");
    }

    public void setCurrentCounter(long counter) {
        switch (this.device.getDeviceSdkType()) {
            case NONE_RTC: {
                this.currentCounter = counter;
                break;
            }
            case RTC: 
            case NONE_COUNTER: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown device key sdk type");
            }
        }
    }

    private DeviceKey generateDeviceKey(Device device) {
        DeviceKey deviceKey = new DeviceKey();
        deviceKey.setSeId(device.getSerialNumber());
        deviceKey.setSeType(device.getType());
        SecureElement se = SecureElementFactory.createSe(device, deviceKey);
        deviceKey.setDeviceId(se.generateId());
        deviceKey.setSe(se);
        return deviceKey;
    }

    private static void validDevice(Device device) {
        Preconditions.checkNotNull((Object)device.getSerialNumber(), (Object)"serial number should not be null");
        Preconditions.checkNotNull((Object)((Object)device.getDeviceSdkType()), (Object)"device sdk type should not be null");
        IotHiskDevice.validateName(device.getDeviceCompany(), 32, "Device company name must consist of Chinese or English characters, numbers, hypen \"-\", or the underscore \"_\", and between 3 and 32 characters in length.");
        IotHiskDevice.validateName(device.getDeviceType(), 48, "Device type name must consist of Chinese or English characters, numbers, hypen \"-\", or the underscore \"_\", and between 3 and 32 characters in length.");
        IotHiskDevice.validateSerialNumber(device.getSerialNumber());
    }

    private static void validateName(String name, int maxLength, String errorMessage) {
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.length((CharSequence)name) < 3 || StringUtils.length((CharSequence)name) > maxLength || !namePattern.matcher(name).matches()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static void validateSerialNumber(String serialNumber) {
        if (StringUtils.isBlank((CharSequence)serialNumber) || StringUtils.length((CharSequence)serialNumber) > 32) {
            throw new IllegalArgumentException("Serial number is empty or its length greater than 32.");
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

