/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.kafka;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientException;
import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.kafka.KafkaClientConfiguration;
import com.baidubce.services.kafka.model.acl.CreateAclRequest;
import com.baidubce.services.kafka.model.acl.CreateAclResponse;
import com.baidubce.services.kafka.model.acl.DeleteAclRequest;
import com.baidubce.services.kafka.model.acl.DeleteAclResponse;
import com.baidubce.services.kafka.model.acl.ListAclRequest;
import com.baidubce.services.kafka.model.acl.ListAclResponse;
import com.baidubce.services.kafka.model.cluster.CreateClusterRequest;
import com.baidubce.services.kafka.model.cluster.CreateClusterResponse;
import com.baidubce.services.kafka.model.cluster.DecreaseBrokerCountRequest;
import com.baidubce.services.kafka.model.cluster.DecreaseBrokerCountResponse;
import com.baidubce.services.kafka.model.cluster.DeleteClusterRequest;
import com.baidubce.services.kafka.model.cluster.DeleteClusterResponse;
import com.baidubce.services.kafka.model.cluster.ExpandBrokerDiskCapacityRequest;
import com.baidubce.services.kafka.model.cluster.ExpandBrokerDiskCapacityResponse;
import com.baidubce.services.kafka.model.cluster.GetClusterAccessEndpointsRequest;
import com.baidubce.services.kafka.model.cluster.GetClusterAccessEndpointsResponse;
import com.baidubce.services.kafka.model.cluster.GetClusterDetailRequest;
import com.baidubce.services.kafka.model.cluster.GetClusterDetailResponse;
import com.baidubce.services.kafka.model.cluster.GetClusterNodesRequest;
import com.baidubce.services.kafka.model.cluster.GetClusterNodesResponse;
import com.baidubce.services.kafka.model.cluster.IncreaseBrokerCountRequest;
import com.baidubce.services.kafka.model.cluster.IncreaseBrokerCountResponse;
import com.baidubce.services.kafka.model.cluster.ListClustersRequest;
import com.baidubce.services.kafka.model.cluster.ListClustersResponse;
import com.baidubce.services.kafka.model.cluster.ResizeClusterEipBandwidthRequest;
import com.baidubce.services.kafka.model.cluster.ResizeClusterEipBandwidthResponse;
import com.baidubce.services.kafka.model.cluster.StartClusterRequest;
import com.baidubce.services.kafka.model.cluster.StartClusterResponse;
import com.baidubce.services.kafka.model.cluster.StopClusterRequest;
import com.baidubce.services.kafka.model.cluster.StopClusterResponse;
import com.baidubce.services.kafka.model.cluster.SwitchClusterEipRequest;
import com.baidubce.services.kafka.model.cluster.SwitchClusterEipResponse;
import com.baidubce.services.kafka.model.cluster.UpdateAccessConfigRequest;
import com.baidubce.services.kafka.model.cluster.UpdateAccessConfigResponse;
import com.baidubce.services.kafka.model.cluster.UpdateBrokerNodeTypeRequest;
import com.baidubce.services.kafka.model.cluster.UpdateBrokerNodeTypeResponse;
import com.baidubce.services.kafka.model.consumer.DeleteConsumerGroupRequest;
import com.baidubce.services.kafka.model.consumer.DeleteConsumerGroupResponse;
import com.baidubce.services.kafka.model.consumer.ListConsumerGroupRequest;
import com.baidubce.services.kafka.model.consumer.ListConsumerGroupResponse;
import com.baidubce.services.kafka.model.consumer.ListSubscribedTopicsRequest;
import com.baidubce.services.kafka.model.consumer.ListSubscribedTopicsResponse;
import com.baidubce.services.kafka.model.consumer.ResetConsumerGroupRequest;
import com.baidubce.services.kafka.model.consumer.ResetConsumerGroupResponse;
import com.baidubce.services.kafka.model.job.CancelJobRequest;
import com.baidubce.services.kafka.model.job.CancelJobResponse;
import com.baidubce.services.kafka.model.job.GetJobDetailRequest;
import com.baidubce.services.kafka.model.job.GetJobDetailResponse;
import com.baidubce.services.kafka.model.job.GetOperationDetailRequest;
import com.baidubce.services.kafka.model.job.GetOperationDetailResponse;
import com.baidubce.services.kafka.model.job.ListJobsRequest;
import com.baidubce.services.kafka.model.job.ListJobsResponse;
import com.baidubce.services.kafka.model.job.ResumeJobRequest;
import com.baidubce.services.kafka.model.job.ResumeJobResponse;
import com.baidubce.services.kafka.model.job.StartJobRequest;
import com.baidubce.services.kafka.model.job.StartJobResponse;
import com.baidubce.services.kafka.model.job.SuspendJobRequest;
import com.baidubce.services.kafka.model.job.SuspendJobResponse;
import com.baidubce.services.kafka.model.topic.CreateTopicRequest;
import com.baidubce.services.kafka.model.topic.CreateTopicResponse;
import com.baidubce.services.kafka.model.topic.DeleteTopicRequest;
import com.baidubce.services.kafka.model.topic.DeleteTopicResponse;
import com.baidubce.services.kafka.model.topic.GetSubscribedGroupDetailRequest;
import com.baidubce.services.kafka.model.topic.GetSubscribedGroupDetailResponse;
import com.baidubce.services.kafka.model.topic.GetTopicDetailRequest;
import com.baidubce.services.kafka.model.topic.GetTopicDetailResponse;
import com.baidubce.services.kafka.model.topic.GetTopicPartitionDetailRequest;
import com.baidubce.services.kafka.model.topic.GetTopicPartitionDetailResponse;
import com.baidubce.services.kafka.model.topic.ListSubscribedGroupsRequest;
import com.baidubce.services.kafka.model.topic.ListSubscribedGroupsResponse;
import com.baidubce.services.kafka.model.topic.ListTopicPartitionsRequest;
import com.baidubce.services.kafka.model.topic.ListTopicPartitionsResponse;
import com.baidubce.services.kafka.model.topic.ListTopicRequest;
import com.baidubce.services.kafka.model.topic.ListTopicResponse;
import com.baidubce.services.kafka.model.topic.UpdateTopicRequest;
import com.baidubce.services.kafka.model.topic.UpdateTopicResponse;
import com.baidubce.services.kafka.model.user.CreateUserRequest;
import com.baidubce.services.kafka.model.user.CreateUserResponse;
import com.baidubce.services.kafka.model.user.DeleteUserRequest;
import com.baidubce.services.kafka.model.user.DeleteUserResponse;
import com.baidubce.services.kafka.model.user.ListUserResponse;
import com.baidubce.services.kafka.model.user.ListUsersRequest;
import com.baidubce.services.kafka.model.user.ResetUserPasswordRequest;
import com.baidubce.services.kafka.model.user.ResetUserPasswordResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaClient.class);
    private static final String VERSION = "v2";
    private static final String CLUSTERS_PREFIX = "clusters";
    private static final String TOPICS_PREFIX = "topics";
    private static final String CONSUMER_GROUPS_PREFIX = "consumer-groups";
    private static final String USERS_PREFIX = "users";
    private static final String ACLS_PREFIX = "acls";
    private static final String ACCESS_ENDPOINTS_PREFIX = "access-endpoints";
    private static final String NODES_PREFIX = "nodes";
    private static final String OFFSETS_PREFIX = "offsets";
    private static final String PARTITONS_PREFIX = "partitions";
    private static final String JOBS_PREFIX = "jobs";
    private static final String OPERATIONS_PREFIX = "operations";
    private static final String PAGE_NO = "pageNo";
    private static final String PAGE_SIZE = "pageSize";
    private static final String MARKER = "marker";
    private static final String MAX_KEYS = "maxKeys";
    private static final String STATE = "state";
    private static final String MODE = "mode";
    private static final String NAME = "name";
    private static final String KAFKA_VERSION = "kafkaVersion";
    private static final String PAYMENT = "payment";
    private static final String TAG_KEY = "tagKey";
    private static final String TAG_VALUE = "tagValue";
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String CLUSTERID_MESSAGE_KEY = "clusterId";
    private static final String CLUSTER_NAME_MESSAGE_KEY = "clusterName";
    private static final String NAME_MESSAGE_KEY = "name";
    private static final String TOPIC_NAME_MESSAGE_KEY = "topicName";
    private static final String GROUP_NAME_MESSAGE_KEY = "groupName";
    private static final String JOBID_MESSAGE_KEY = "jobId";
    private static final String OPERATIONID_MESSAGE_KEY = "operationId";
    private static final String USERNAME_MESSAGE_KEY = "username";
    private static final String PASSWORD_MESSAGE_KEY = "password";
    private static final String PATTERN_TYPE_MESSAGE_KEY = "patternType";
    private static final String RESOURCE_TYPE_MESSAGE_KEY = "resourceType";
    private static final String RESOURCE_NAME_MESSAGE_KEY = "resourceName";
    private static final String OPERATION_MESSAGE_KEY = "operation";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] KAFKA_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public KafkaClient() {
        this(new KafkaClientConfiguration());
    }

    public KafkaClient(KafkaClientConfiguration clientConfiguration) {
        super(clientConfiguration, KAFKA_HANDLERS);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    private String aes128WithFirst16Char(String content, String privateKey) throws GeneralSecurityException {
        byte[] crypted = null;
        SecretKeySpec skey = new SecretKeySpec(privateKey.substring(0, 16).getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, skey);
        crypted = cipher.doFinal(content.getBytes());
        return new String(Hex.encodeHex((byte[])crypted, (boolean)false));
    }

    public CreateClusterResponse createCluster(CreateClusterRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CLUSTERS_PREFIX);
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat("name"));
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateClusterResponse.class);
    }

    public DeleteClusterResponse deleteCluster(DeleteClusterRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, CLUSTERS_PREFIX, request.getClusterId());
        return this.invokeHttpClient(internalRequest, DeleteClusterResponse.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ListClustersResponse listClusters(ListClustersRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() <= 1000 && request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getClusterName())) {
            internalRequest.addParameter(CLUSTER_NAME_MESSAGE_KEY, request.getClusterName());
        }
        if (!Strings.isNullOrEmpty((String)request.getState())) {
            internalRequest.addParameter(STATE, request.getState());
        }
        if (!Strings.isNullOrEmpty((String)request.getMode())) {
            internalRequest.addParameter(MODE, request.getMode());
        }
        if (!Strings.isNullOrEmpty((String)request.getKafkaVersion())) {
            internalRequest.addParameter(KAFKA_VERSION, request.getKafkaVersion());
        }
        if (!Strings.isNullOrEmpty((String)request.getPayment())) {
            internalRequest.addParameter(PAYMENT, request.getPayment());
        }
        if (!Strings.isNullOrEmpty((String)request.getTagKey())) {
            if (request.getTagValue() == null) throw new IllegalArgumentException("Request tagValue should not be null.");
            internalRequest.addParameter(TAG_KEY, request.getTagKey());
            internalRequest.addParameter(TAG_VALUE, request.getTagValue());
            return this.invokeHttpClient(internalRequest, ListClustersResponse.class);
        } else {
            if (request.getTagValue() == null) return this.invokeHttpClient(internalRequest, ListClustersResponse.class);
            throw new IllegalArgumentException("Request tagKey should not be null or empty.");
        }
    }

    public GetClusterDetailResponse getClusterDetail(GetClusterDetailRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId());
        return this.invokeHttpClient(internalRequest, GetClusterDetailResponse.class);
    }

    public GetClusterAccessEndpointsResponse getClusterAccessEndpoints(GetClusterAccessEndpointsRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId(), ACCESS_ENDPOINTS_PREFIX);
        return this.invokeHttpClient(internalRequest, GetClusterAccessEndpointsResponse.class);
    }

    public GetClusterNodesResponse getClusterNodes(GetClusterNodesRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId(), NODES_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() <= 1000 && request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getState())) {
            internalRequest.addParameter(STATE, request.getState());
        }
        return this.invokeHttpClient(internalRequest, GetClusterNodesResponse.class);
    }

    public IncreaseBrokerCountResponse increaseBrokerCount(IncreaseBrokerCountRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CLUSTERS_PREFIX, request.getClusterId(), "increase-broker-count");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, IncreaseBrokerCountResponse.class);
    }

    public DecreaseBrokerCountResponse decreaseBrokerCount(DecreaseBrokerCountRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CLUSTERS_PREFIX, request.getClusterId(), "decrease-broker-count");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DecreaseBrokerCountResponse.class);
    }

    public UpdateBrokerNodeTypeResponse updateBrokerNodeType(UpdateBrokerNodeTypeRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CLUSTERS_PREFIX, request.getClusterId(), "update-broker-node-type");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBrokerNodeTypeResponse.class);
    }

    public ExpandBrokerDiskCapacityResponse expandBrokerDiskCapacity(ExpandBrokerDiskCapacityRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CLUSTERS_PREFIX, request.getClusterId(), "expand-broker-disk-capacity");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ExpandBrokerDiskCapacityResponse.class);
    }

    public UpdateAccessConfigResponse updateAccessConfig(UpdateAccessConfigRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CLUSTERS_PREFIX, request.getClusterId(), "update-access-config");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateAccessConfigResponse.class);
    }

    public StartClusterResponse startCluster(StartClusterRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CLUSTERS_PREFIX, request.getClusterId(), "start");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, StartClusterResponse.class);
    }

    public StopClusterResponse stopCluster(StopClusterRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CLUSTERS_PREFIX, request.getClusterId(), "stop");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, StopClusterResponse.class);
    }

    public ResizeClusterEipBandwidthResponse resizeClusterEipBandwidth(ResizeClusterEipBandwidthRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CLUSTERS_PREFIX, request.getClusterId(), "eip-bandwidths/resize");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ResizeClusterEipBandwidthResponse.class);
    }

    public SwitchClusterEipResponse switchClusterEip(SwitchClusterEipRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CLUSTERS_PREFIX, request.getClusterId(), "eips/switch");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, SwitchClusterEipResponse.class);
    }

    public UpdateTopicResponse updateTopic(UpdateTopicRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getTopicName(), StringFormatUtils.checkEmptyExceptionMessageFormat(TOPICS_PREFIX));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CLUSTERS_PREFIX, request.getClusterId(), TOPICS_PREFIX, request.getTopicName());
        if (request.getPartitionNum() != null || MapUtils.isNotEmpty(request.getOtherConfigs())) {
            this.fillPayload(internalRequest, request);
            return this.invokeHttpClient(internalRequest, UpdateTopicResponse.class);
        }
        throw new IllegalArgumentException("Request fields should not be both null or empty.");
    }

    public GetSubscribedGroupDetailResponse getSubscribedGroupDetail(GetSubscribedGroupDetailRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getTopicName(), StringFormatUtils.checkEmptyExceptionMessageFormat(TOPICS_PREFIX));
        Validate.checkStringNotEmpty(request.getGroupName(), StringFormatUtils.checkEmptyExceptionMessageFormat(CONSUMER_GROUPS_PREFIX));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId(), TOPICS_PREFIX, request.getTopicName(), CONSUMER_GROUPS_PREFIX, request.getGroupName(), "subscribe-details");
        return this.invokeHttpClient(internalRequest, GetSubscribedGroupDetailResponse.class);
    }

    public ListTopicPartitionsResponse listTopicPartitions(ListTopicPartitionsRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getTopicName(), StringFormatUtils.checkEmptyExceptionMessageFormat(TOPICS_PREFIX));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId(), TOPICS_PREFIX, request.getTopicName(), PARTITONS_PREFIX, "statuses");
        internalRequest.addParameter(PAGE_NO, String.valueOf(request.getPageNo()));
        if (request.getPageSize() > 0) {
            internalRequest.addParameter(PAGE_SIZE, String.valueOf(request.getPageSize()));
        }
        return this.invokeHttpClient(internalRequest, ListTopicPartitionsResponse.class);
    }

    public GetTopicPartitionDetailResponse getTopicPartitionDetail(GetTopicPartitionDetailRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getTopicName(), StringFormatUtils.checkEmptyExceptionMessageFormat(TOPICS_PREFIX));
        Validate.checkStringNotEmpty(request.getPartitionId(), StringFormatUtils.checkEmptyExceptionMessageFormat(PARTITONS_PREFIX));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId(), TOPICS_PREFIX, request.getTopicName(), PARTITONS_PREFIX, request.getPartitionId(), "statuses");
        return this.invokeHttpClient(internalRequest, GetTopicPartitionDetailResponse.class);
    }

    public ListTopicResponse listTopic(ListTopicRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId(), TOPICS_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getTopicName())) {
            internalRequest.addParameter(TOPIC_NAME_MESSAGE_KEY, request.getTopicName());
        }
        return this.invokeHttpClient(internalRequest, ListTopicResponse.class);
    }

    public GetTopicDetailResponse getTopicDetail(GetTopicDetailRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getTopicName(), StringFormatUtils.checkEmptyExceptionMessageFormat(TOPIC_NAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId(), TOPICS_PREFIX, request.getTopicName());
        return this.invokeHttpClient(internalRequest, GetTopicDetailResponse.class);
    }

    public CreateTopicResponse createTopic(CreateTopicRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CLUSTERS_PREFIX, request.getClusterId(), TOPICS_PREFIX);
        Validate.checkStringNotEmpty(request.getTopicName(), StringFormatUtils.checkEmptyExceptionMessageFormat(TOPIC_NAME_MESSAGE_KEY));
        Validate.checkNotNull(request.getPartitionNum(), "Request partitionNum should not be null.");
        Validate.checkNotNull(request.getReplicationFactor(), "Request replicationFactor should not be null.");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateTopicResponse.class);
    }

    public ListSubscribedGroupsResponse listSubscribedGroups(ListSubscribedGroupsRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getTopicName(), StringFormatUtils.checkEmptyExceptionMessageFormat(TOPIC_NAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId(), TOPICS_PREFIX, request.getTopicName(), CONSUMER_GROUPS_PREFIX);
        return this.invokeHttpClient(internalRequest, ListSubscribedGroupsResponse.class);
    }

    public DeleteTopicResponse deleteTopic(DeleteTopicRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getTopicName(), StringFormatUtils.checkEmptyExceptionMessageFormat(TOPIC_NAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, CLUSTERS_PREFIX, request.getClusterId(), TOPICS_PREFIX, request.getTopicName());
        return this.invokeHttpClient(internalRequest, DeleteTopicResponse.class);
    }

    public ListSubscribedTopicsResponse listSubscribedTopics(ListSubscribedTopicsRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getGroupName(), StringFormatUtils.checkEmptyExceptionMessageFormat(GROUP_NAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId(), CONSUMER_GROUPS_PREFIX, request.getGroupName(), TOPICS_PREFIX);
        return this.invokeHttpClient(internalRequest, ListSubscribedTopicsResponse.class);
    }

    public ListConsumerGroupResponse listConsumerGroup(ListConsumerGroupRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId(), CONSUMER_GROUPS_PREFIX);
        return this.invokeHttpClient(internalRequest, ListConsumerGroupResponse.class);
    }

    public DeleteConsumerGroupResponse deleteConsumerGroup(DeleteConsumerGroupRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getGroupName(), StringFormatUtils.checkEmptyExceptionMessageFormat(GROUP_NAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, CLUSTERS_PREFIX, request.getClusterId(), CONSUMER_GROUPS_PREFIX, request.getGroupName());
        return this.invokeHttpClient(internalRequest, DeleteConsumerGroupResponse.class);
    }

    public ResetConsumerGroupResponse resetConsumerGroup(ResetConsumerGroupRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getGroupName(), StringFormatUtils.checkEmptyExceptionMessageFormat(GROUP_NAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CLUSTERS_PREFIX, request.getClusterId(), CONSUMER_GROUPS_PREFIX, request.getGroupName(), OFFSETS_PREFIX);
        Validate.checkStringNotEmpty(request.getTopicName(), StringFormatUtils.checkEmptyExceptionMessageFormat(TOPIC_NAME_MESSAGE_KEY));
        if (CollectionUtils.isEmpty(request.getPartitions())) {
            throw new IllegalArgumentException("Request partitions should not be both null or empty.");
        }
        Validate.checkStringNotEmpty(request.getResetStrategy(), StringFormatUtils.checkEmptyExceptionMessageFormat("resetStrategy"));
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ResetConsumerGroupResponse.class);
    }

    public CreateUserResponse createUser(CreateUserRequest request) throws BceClientException {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getUsername(), StringFormatUtils.checkEmptyExceptionMessageFormat(USERNAME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getPassword(), StringFormatUtils.checkEmptyExceptionMessageFormat(PASSWORD_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CLUSTERS_PREFIX, request.getClusterId(), USERS_PREFIX);
        BceCredentials credentials = this.config.getCredentials();
        if (internalRequest.getCredentials() != null) {
            credentials = internalRequest.getCredentials();
        }
        try {
            request.setPassword(this.aes128WithFirst16Char(request.getPassword(), credentials.getSecretKey()));
        }
        catch (GeneralSecurityException e) {
            throw new BceClientException("Encryption procedure exception", e);
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateUserResponse.class);
    }

    public DeleteUserResponse deleteUser(DeleteUserRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getUsername(), StringFormatUtils.checkEmptyExceptionMessageFormat(USERNAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, CLUSTERS_PREFIX, request.getClusterId(), USERS_PREFIX, request.getUsername());
        return this.invokeHttpClient(internalRequest, DeleteUserResponse.class);
    }

    public ResetUserPasswordResponse resetUserPassword(ResetUserPasswordRequest request) throws BceClientException {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getUsername(), StringFormatUtils.checkEmptyExceptionMessageFormat(USERNAME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getPassword(), StringFormatUtils.checkEmptyExceptionMessageFormat(PASSWORD_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CLUSTERS_PREFIX, request.getClusterId(), USERS_PREFIX);
        BceCredentials credentials = this.config.getCredentials();
        if (internalRequest.getCredentials() != null) {
            credentials = internalRequest.getCredentials();
        }
        try {
            request.setPassword(this.aes128WithFirst16Char(request.getPassword(), credentials.getSecretKey()));
        }
        catch (GeneralSecurityException e) {
            throw new BceClientException("Encryption procedure exception", e);
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ResetUserPasswordResponse.class);
    }

    public ListUserResponse listUsers(String clusterId) {
        return this.listUsers(ListUsersRequest.builder().clusterId(clusterId).build());
    }

    public ListUserResponse listUsers(ListUsersRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId(), USERS_PREFIX);
        return this.invokeHttpClient(internalRequest, ListUserResponse.class);
    }

    public CreateAclResponse createAcl(CreateAclRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getUsername(), StringFormatUtils.checkEmptyExceptionMessageFormat(USERNAME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getPatternType(), StringFormatUtils.checkEmptyExceptionMessageFormat(PATTERN_TYPE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getResourceType(), StringFormatUtils.checkEmptyExceptionMessageFormat(RESOURCE_TYPE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getResourceName(), StringFormatUtils.checkEmptyExceptionMessageFormat(RESOURCE_NAME_MESSAGE_KEY));
        if (CollectionUtils.isEmpty(request.getOperations())) {
            throw new IllegalArgumentException(StringFormatUtils.checkEmptyExceptionMessageFormat(OPERATION_MESSAGE_KEY));
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CLUSTERS_PREFIX, request.getClusterId(), ACLS_PREFIX);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateAclResponse.class);
    }

    public DeleteAclResponse deleteAcl(DeleteAclRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, CLUSTERS_PREFIX, request.getClusterId(), ACLS_PREFIX);
        Validate.checkStringNotEmpty(request.getUsername(), StringFormatUtils.checkEmptyExceptionMessageFormat(USERNAME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getPatternType(), StringFormatUtils.checkEmptyExceptionMessageFormat(PATTERN_TYPE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getResourceType(), StringFormatUtils.checkEmptyExceptionMessageFormat(RESOURCE_TYPE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getResourceName(), StringFormatUtils.checkEmptyExceptionMessageFormat(RESOURCE_NAME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getOperation(), StringFormatUtils.checkEmptyExceptionMessageFormat(OPERATION_MESSAGE_KEY));
        internalRequest.addParameter(USERNAME_MESSAGE_KEY, request.getUsername());
        internalRequest.addParameter(PATTERN_TYPE_MESSAGE_KEY, request.getPatternType());
        internalRequest.addParameter(RESOURCE_TYPE_MESSAGE_KEY, request.getResourceType());
        internalRequest.addParameter(RESOURCE_NAME_MESSAGE_KEY, request.getResourceName());
        internalRequest.addParameter(OPERATION_MESSAGE_KEY, request.getOperation());
        return this.invokeHttpClient(internalRequest, DeleteAclResponse.class);
    }

    public ListAclResponse listAcls(String clusterId) {
        return this.listAcls(ListAclRequest.builder().clusterId(clusterId).build());
    }

    public ListAclResponse listAcls(ListAclRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId(), ACLS_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getUsername())) {
            internalRequest.addParameter(USERNAME_MESSAGE_KEY, request.getUsername());
        }
        if (!Strings.isNullOrEmpty((String)request.getPatternType())) {
            internalRequest.addParameter(PATTERN_TYPE_MESSAGE_KEY, request.getPatternType());
        }
        if (!Strings.isNullOrEmpty((String)request.getResourceType())) {
            internalRequest.addParameter(RESOURCE_TYPE_MESSAGE_KEY, request.getResourceType());
        }
        if (!Strings.isNullOrEmpty((String)request.getResourceName())) {
            internalRequest.addParameter(RESOURCE_NAME_MESSAGE_KEY, request.getResourceName());
        }
        return this.invokeHttpClient(internalRequest, ListAclResponse.class);
    }

    public ListJobsResponse listJobs(ListJobsRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId(), JOBS_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        return this.invokeHttpClient(internalRequest, ListJobsResponse.class);
    }

    public GetJobDetailResponse getJob(GetJobDetailRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getJobId(), StringFormatUtils.checkEmptyExceptionMessageFormat(JOBID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId(), JOBS_PREFIX, request.getJobId());
        return this.invokeHttpClient(internalRequest, GetJobDetailResponse.class);
    }

    public GetOperationDetailResponse getOperation(GetOperationDetailRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getJobId(), StringFormatUtils.checkEmptyExceptionMessageFormat(JOBID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getOperationId(), StringFormatUtils.checkEmptyExceptionMessageFormat(OPERATIONID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTERS_PREFIX, request.getClusterId(), JOBS_PREFIX, request.getJobId(), OPERATIONS_PREFIX, request.getOperationId());
        return this.invokeHttpClient(internalRequest, GetOperationDetailResponse.class);
    }

    public StartJobResponse startJob(StartJobRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getJobId(), StringFormatUtils.checkEmptyExceptionMessageFormat(JOBID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CLUSTERS_PREFIX, request.getClusterId(), JOBS_PREFIX, request.getJobId(), "start");
        return this.invokeHttpClient(internalRequest, StartJobResponse.class);
    }

    public CancelJobResponse cancelJob(CancelJobRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getJobId(), StringFormatUtils.checkEmptyExceptionMessageFormat(JOBID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CLUSTERS_PREFIX, request.getClusterId(), JOBS_PREFIX, request.getJobId(), "cancel");
        return this.invokeHttpClient(internalRequest, CancelJobResponse.class);
    }

    public SuspendJobResponse suspendJob(SuspendJobRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getJobId(), StringFormatUtils.checkEmptyExceptionMessageFormat(JOBID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CLUSTERS_PREFIX, request.getClusterId(), JOBS_PREFIX, request.getJobId(), "suspend");
        return this.invokeHttpClient(internalRequest, SuspendJobResponse.class);
    }

    public ResumeJobResponse resumeJob(ResumeJobRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterId(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTERID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getJobId(), StringFormatUtils.checkEmptyExceptionMessageFormat(JOBID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CLUSTERS_PREFIX, request.getClusterId(), JOBS_PREFIX, request.getJobId(), "resume");
        return this.invokeHttpClient(internalRequest, ResumeJobResponse.class);
    }
}

