/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.route;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.route.RouteClientConfiguration;
import com.baidubce.services.route.model.CreateRouteRequest;
import com.baidubce.services.route.model.CreateRouteResponse;
import com.baidubce.services.route.model.DeleteRouteRequest;
import com.baidubce.services.route.model.GetRouteRequest;
import com.baidubce.services.route.model.GetRouteResponse;
import com.baidubce.services.route.model.ListRouteRuleReq;
import com.baidubce.services.route.model.ListRouteRuleResponse;
import com.baidubce.services.route.model.SwitchRouteHaRequest;
import com.baidubce.services.route.model.UpdateRouteRuleRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteClient.class);
    private static final String VERSION = "v1";
    private static final String ROUTE_PREFIX = "route";
    private static final String ROUTE_RULE = "rule";
    private static final HttpResponseHandler[] vpc_handlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public RouteClient() {
        this(new RouteClientConfiguration());
    }

    public RouteClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, vpc_handlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public CreateRouteResponse createRoute(CreateRouteRequest request) throws BceClientException {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getRouteTableId(), "routeTableId should not be empty");
        Validate.checkStringNotEmpty(request.getSourceAddress(), "source address should not be empty");
        Validate.checkStringNotEmpty(request.getDestinationAddress(), "destination address should not be empty");
        Validate.checkStringNotEmpty(request.getNexthopType(), "nexthop type  should not be empty");
        Validate.checkStringNotEmpty(request.getDescription(), "description should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ROUTE_PREFIX, ROUTE_RULE);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateRouteResponse.class);
    }

    public GetRouteResponse getRoute(String routeTableId, String vpcId) {
        GetRouteRequest request = new GetRouteRequest();
        if (Strings.isNullOrEmpty((String)vpcId) && Strings.isNullOrEmpty((String)routeTableId)) {
            throw new IllegalArgumentException("routeTableId and vpcId should not be empty at the same time");
        }
        if (!Strings.isNullOrEmpty((String)routeTableId)) {
            request.withRouteTableId(routeTableId);
        } else if (!Strings.isNullOrEmpty((String)vpcId)) {
            request.withVpcId(vpcId);
        }
        return this.getRoutes(request);
    }

    private GetRouteResponse getRoutes(GetRouteRequest getRouteRequest) {
        Preconditions.checkNotNull((Object)getRouteRequest, (Object)"route request should not be null");
        if (Strings.isNullOrEmpty((String)getRouteRequest.getRouteTableId()) && Strings.isNullOrEmpty((String)getRouteRequest.getVpcId())) {
            throw new IllegalArgumentException("routeTableId and vpcId cannot be empty at the same time");
        }
        InternalRequest internalRequest = this.createRequest(getRouteRequest, HttpMethodName.GET, ROUTE_PREFIX);
        if (!Strings.isNullOrEmpty((String)getRouteRequest.getVpcId())) {
            internalRequest.addParameter("vpcId", getRouteRequest.getVpcId());
        } else if (!Strings.isNullOrEmpty((String)getRouteRequest.getRouteTableId())) {
            internalRequest.addParameter("routeTableId", getRouteRequest.getRouteTableId());
        }
        return this.invokeHttpClient(internalRequest, GetRouteResponse.class);
    }

    public void deleteRouteRule(String routeRuleId) {
        this.deleteRouteRule(new DeleteRouteRequest().withRouteRuleId(routeRuleId));
    }

    public void deleteRouteRule(DeleteRouteRequest deleteRouteRequest) {
        Preconditions.checkNotNull((Object)deleteRouteRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)deleteRouteRequest.getRouteRuleId(), (Object)"request routeRuleId should not be null.");
        if (Strings.isNullOrEmpty((String)deleteRouteRequest.getClientToken())) {
            deleteRouteRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(deleteRouteRequest, HttpMethodName.DELETE, ROUTE_PREFIX, ROUTE_RULE, deleteRouteRequest.getRouteRuleId());
        internalRequest.addParameter("clientToken", deleteRouteRequest.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateRouteRule(UpdateRouteRuleRequest updateRouteRuleRequest) {
        Preconditions.checkNotNull((Object)updateRouteRuleRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)updateRouteRuleRequest.getRouteRuleId(), (Object)"request routeRuleId should not be null.");
        if (Strings.isNullOrEmpty((String)updateRouteRuleRequest.getClientToken())) {
            updateRouteRuleRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(updateRouteRuleRequest, HttpMethodName.PUT, ROUTE_PREFIX, ROUTE_RULE, updateRouteRuleRequest.getRouteRuleId());
        internalRequest.addParameter("clientToken", updateRouteRuleRequest.getClientToken());
        this.fillPayload(internalRequest, updateRouteRuleRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListRouteRuleResponse listRouteRule(ListRouteRuleReq listRouteRuleReq) {
        InternalRequest internalRequest = this.createRequest(listRouteRuleReq, HttpMethodName.GET, ROUTE_PREFIX, ROUTE_RULE);
        if (!Strings.isNullOrEmpty((String)listRouteRuleReq.getVpcId())) {
            internalRequest.addParameter("vpcId", listRouteRuleReq.getVpcId());
        } else if (!Strings.isNullOrEmpty((String)listRouteRuleReq.getRouteTableId())) {
            internalRequest.addParameter("routeTableId", listRouteRuleReq.getRouteTableId());
        }
        return this.invokeHttpClient(internalRequest, ListRouteRuleResponse.class);
    }

    public void switchRouteHa(String ruleId) {
        SwitchRouteHaRequest switchRouteHaRequest = new SwitchRouteHaRequest();
        switchRouteHaRequest.setRouteRuleId(ruleId);
        this.switchRouteHa(switchRouteHaRequest);
    }

    public void switchRouteHa(SwitchRouteHaRequest switchRouteHaRequest) {
        InternalRequest internalRequest = this.createRequest(switchRouteHaRequest, HttpMethodName.PUT, ROUTE_PREFIX, ROUTE_RULE, switchRouteHaRequest.getRouteRuleId());
        internalRequest.addParameter("switchRouteHA", null);
        internalRequest.addHeader("Content-Length", "0");
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }
}

