/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.vod;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.Region;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosClientConfiguration;
import com.baidubce.services.bos.model.ObjectMetadata;
import com.baidubce.services.vod.FileUploadSession;
import com.baidubce.services.vod.model.ActionAttributes;
import com.baidubce.services.vod.model.CreateMediaResourceResponse;
import com.baidubce.services.vod.model.CreateNotificationRequest;
import com.baidubce.services.vod.model.CreateNotificationResponse;
import com.baidubce.services.vod.model.DeleteMediaResourceRequest;
import com.baidubce.services.vod.model.DeleteMediaResourceResponse;
import com.baidubce.services.vod.model.DeleteNotificationRequest;
import com.baidubce.services.vod.model.DeleteNotificationResponse;
import com.baidubce.services.vod.model.GenerateMediaDeliveryInfoRequest;
import com.baidubce.services.vod.model.GenerateMediaDeliveryInfoResponse;
import com.baidubce.services.vod.model.GenerateMediaIdRequest;
import com.baidubce.services.vod.model.GenerateMediaIdResponse;
import com.baidubce.services.vod.model.GenerateMediaPlayerCodeRequest;
import com.baidubce.services.vod.model.GenerateMediaPlayerCodeResponse;
import com.baidubce.services.vod.model.GetMediaResourceRequest;
import com.baidubce.services.vod.model.GetMediaResourceResponse;
import com.baidubce.services.vod.model.GetMediaSourceDownloadRequest;
import com.baidubce.services.vod.model.GetMediaSourceDownloadResponse;
import com.baidubce.services.vod.model.GetMediaStatisticRequest;
import com.baidubce.services.vod.model.GetMediaStatisticResponse;
import com.baidubce.services.vod.model.GetNotificationRequest;
import com.baidubce.services.vod.model.GetNotificationResponse;
import com.baidubce.services.vod.model.GetPartMediaResourceRequest;
import com.baidubce.services.vod.model.GetPartMediaResourceResponse;
import com.baidubce.services.vod.model.InternalCreateMediaRequest;
import com.baidubce.services.vod.model.InternalCreateMediaResponse;
import com.baidubce.services.vod.model.ListMediaResourceByMarkerRequest;
import com.baidubce.services.vod.model.ListMediaResourceByMarkerResponse;
import com.baidubce.services.vod.model.ListMediaResourceRequest;
import com.baidubce.services.vod.model.ListMediaResourceResponse;
import com.baidubce.services.vod.model.ListNotificationsRequest;
import com.baidubce.services.vod.model.ListNotificationsResponse;
import com.baidubce.services.vod.model.PublishMediaResourceRequest;
import com.baidubce.services.vod.model.PublishMediaResourceResponse;
import com.baidubce.services.vod.model.ReTranscodeRequest;
import com.baidubce.services.vod.model.ReTranscodeResponse;
import com.baidubce.services.vod.model.StopMediaResourceRequest;
import com.baidubce.services.vod.model.StopMediaResourceResponse;
import com.baidubce.services.vod.model.UpdateMediaResourceRequest;
import com.baidubce.services.vod.model.UpdateMediaResourceResponse;
import com.baidubce.util.DateUtils;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VodClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String PATH_MEDIA = "media";
    private static final String PATH_NOTIFICATION = "notification";
    private static final String PATH_INTERNAL_MEDIA = "media/internal";
    private static final String PATH_SERVICE_CODE = "service/code";
    private static final String PATH_SERVICE_FILE = "service/file";
    private static final String MEDIA_STATISTIC = "statistic/media";
    private static final String PARA_PUBLISH = "publish";
    private static final String PARA_DISABLE = "disable";
    private static final String PARA_MEDIA_ID = "media_id";
    private static final String PARA_WIDTH = "width";
    private static final String PARA_HEIGHT = "height";
    private static final String PARA_AUTO_START = "auto_start";
    private static final String PARA_AUTO_START_NEW = "autostart";
    private static final String PARA_ATTRIBUTES = "attributes";
    private static final String PARA_APPLY = "apply";
    private static final String PARA_APPLY_MODE = "mode";
    private static final String PARA_PROCESS = "process";
    private static final String PARA_GET_SCOPE = "scope";
    private static final String PARA_GET_TASK_ID = "taskId";
    private static final String PARA_GENDELIVERY = "delivery";
    private static final String PARA_GENCODE = "code";
    private static final String PARA_AK = "ak";
    private static final String PARA_PAGENO = "pageNo";
    private static final String PARA_PAGESIZE = "pageSize";
    private static final String PARA_STATUS = "status";
    private static final String PARA_BEGIN = "begin";
    private static final String PARA_END = "end";
    private static final String PARA_TITLE = "title";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String PARAM_MAX_SIZE = "maxSize";
    private static final String PARAM_MARKER = "marker";
    private static final String PARAM_TRANSCODING_PRESET_NAME = "transcodingPresetName";
    private static final String AGGREGATE = "aggregate";
    private static final String PARA_RERUN = "rerun";
    private static final String PARA_DOWNLOAD = "sourcedownload";
    private static final String PARA_EXPIREDINSECONDS = "expiredInSeconds";
    private static final String VALID_EXTENSION_PATTERN = "[0-9a-zA-Z]{0,10}";
    private static final int LIST_MAX_PAGESIZE = 1000;
    private static final int LIST_MIN_PAGESIZE = 1;
    private static final int MAX_SOURCE_EXTENSION_LENGTH = 10;
    private static Logger logger = LoggerFactory.getLogger(VodClient.class);
    private BosClient bosClient;
    private static final HttpResponseHandler[] responseHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public VodClient(BceClientConfiguration vodConfig) {
        super(vodConfig, responseHandlers, true);
        BosClientConfiguration bosConfig = new BosClientConfiguration(vodConfig, "http://bj.bcebos.com").withRegion(Region.CN_N1);
        this.bosClient = new BosClient(bosConfig);
    }

    public VodClient(BceClientConfiguration vodConfig, BosClientConfiguration bosConfig) {
        super(vodConfig, responseHandlers, true);
        this.bosClient = new BosClient(bosConfig);
    }

    public CreateMediaResourceResponse createMediaResource(String title, String description, File file, String transcodingPresetGroupName, int priority) throws FileNotFoundException {
        return this.createMediaResource(title, description, file, transcodingPresetGroupName, priority, null);
    }

    public CreateMediaResourceResponse createMediaResource(String title, String description, File file, String transcodingPresetGroupName, int priority, String mode) throws FileNotFoundException {
        return this.createMediaResource(title, description, file, transcodingPresetGroupName, priority, mode, null);
    }

    public CreateMediaResourceResponse createMediaResource(String title, String description, File file, String transcodingPresetGroupName, int priority, String mode, ActionAttributes actionAttributes) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("The media file " + file.getAbsolutePath() + " doesn't exist!");
        }
        String sourceExtension = null;
        String filename = file.getName();
        sourceExtension = this.getFileExtension(filename);
        GenerateMediaIdResponse generateMediaIdresponse = mode == null ? this.applyMedia() : this.applyMedia(mode);
        String bosKey = generateMediaIdresponse.getSourceKey();
        String mediaId = generateMediaIdresponse.getMediaId();
        String bucket = generateMediaIdresponse.getSourceBucket();
        logger.info("[bucket] = " + bucket + ", [bosKey] = " + bosKey + ", [mediaId] = " + mediaId);
        FileUploadSession session = new FileUploadSession(this.bosClient);
        CreateMediaResourceResponse response = new CreateMediaResourceResponse();
        if (session.upload(file, bucket, bosKey)) {
            InternalCreateMediaRequest request = new InternalCreateMediaRequest().withMediaId(mediaId).withTitle(title).withDescription(description).withSourceExtension(sourceExtension).withTranscodingPresetGroupName(transcodingPresetGroupName).withPriority(priority).withActionAttributes(actionAttributes);
            InternalCreateMediaResponse internalResponse = this.processMedia(request);
            response.setMediaId(internalResponse.getMediaId());
        }
        return response;
    }

    public CreateMediaResourceResponse createMediaResource(String sourceBucket, String sourceKey, String title, String description, String transcodingPresetGroupName, int priority) {
        return this.createMediaResource(sourceBucket, sourceKey, title, description, transcodingPresetGroupName, priority, null);
    }

    public CreateMediaResourceResponse createMediaResource(String sourceBucket, String sourceKey, String title, String description, String transcodingPresetGroupName, int priority, String mode) {
        return this.createMediaResource(sourceBucket, sourceKey, title, description, transcodingPresetGroupName, priority, mode, null);
    }

    public CreateMediaResourceResponse createMediaResource(String sourceBucket, String sourceKey, String title, String description, String transcodingPresetGroupName, int priority, String mode, ActionAttributes actionAttributes) {
        Validate.checkStringNotEmpty(sourceBucket, "sourceBucket should not be null or empty!");
        Validate.checkStringNotEmpty(sourceKey, "key should not be null or empty!");
        ObjectMetadata metaData = this.bosClient.getObjectMetadata(sourceBucket, sourceKey);
        Validate.checkIsTrue(metaData != null && metaData.getContentLength() > 0L, "The object corresponding to [bucket] = " + sourceBucket + ", [key] = " + sourceKey + " doesn't exist.");
        String sourceExtension = null;
        sourceExtension = this.getFileExtension(sourceKey);
        GenerateMediaIdResponse generateMediaIdresponse = mode == null ? this.applyMedia() : this.applyMedia(mode);
        String mediaId = generateMediaIdresponse.getMediaId();
        String targetBucket = generateMediaIdresponse.getSourceBucket();
        String targetKey = generateMediaIdresponse.getSourceKey();
        this.bosClient.copyObject(sourceBucket, sourceKey, targetBucket, targetKey);
        InternalCreateMediaRequest request = new InternalCreateMediaRequest().withMediaId(mediaId).withTitle(title).withDescription(description).withSourceExtension(sourceExtension).withTranscodingPresetGroupName(transcodingPresetGroupName).withPriority(priority);
        InternalCreateMediaResponse internalResponse = this.processMedia(request);
        CreateMediaResourceResponse response = new CreateMediaResourceResponse();
        response.setMediaId(internalResponse.getMediaId());
        return response;
    }

    public CreateMediaResourceResponse createMediaResource(String sourceUrl, String title, String description, String transcodingPresetGroupName, int priority) {
        return this.createMediaResource(sourceUrl, title, description, transcodingPresetGroupName, priority, null);
    }

    public CreateMediaResourceResponse createMediaResource(String sourceUrl, String title, String description, String transcodingPresetGroupName, int priority, String mode) {
        return this.createMediaResource(sourceUrl, title, description, transcodingPresetGroupName, priority, mode, null);
    }

    public CreateMediaResourceResponse createMediaResource(String sourceUrl, String title, String description, String transcodingPresetGroupName, int priority, String mode, ActionAttributes actionAttributes) {
        Validate.checkStringNotEmpty(sourceUrl, "sourceUrl should not be null or empty!");
        GenerateMediaIdResponse generateMediaIdresponse = mode == null ? this.applyMedia() : this.applyMedia(mode);
        String mediaId = generateMediaIdresponse.getMediaId();
        String targetBucket = generateMediaIdresponse.getSourceBucket();
        String targetKey = generateMediaIdresponse.getSourceKey();
        this.bosClient.fetchObject(targetBucket, targetKey, sourceUrl);
        InternalCreateMediaRequest request = new InternalCreateMediaRequest().withMediaId(mediaId).withTitle(title).withDescription(description).withTranscodingPresetGroupName(transcodingPresetGroupName).withPriority(priority).withActionAttributes(actionAttributes);
        InternalCreateMediaResponse internalResponse = this.processMedia(request);
        CreateMediaResourceResponse response = new CreateMediaResourceResponse();
        response.setMediaId(internalResponse.getMediaId());
        return response;
    }

    public InternalCreateMediaResponse processMedia(InternalCreateMediaRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, PATH_MEDIA, request.getMediaId());
        internalRequest.addParameter(PARA_PROCESS, null);
        return this.invokeHttpClient(internalRequest, InternalCreateMediaResponse.class);
    }

    public InternalCreateMediaResponse processMedia(String mediaId, String title, String description, String sourceExtension, String transcodingPresetGroupName, int priority, ActionAttributes actionAttributes) {
        InternalCreateMediaRequest request = new InternalCreateMediaRequest().withMediaId(mediaId).withTitle(title).withDescription(description).withSourceExtension(sourceExtension).withTranscodingPresetGroupName(transcodingPresetGroupName).withPriority(priority).withActionAttributes(actionAttributes);
        InternalCreateMediaResponse internalResponse = this.processMedia(request);
        return internalResponse;
    }

    public InternalCreateMediaResponse processMedia(String mediaId, String title, String description, String sourceExtension, String transcodingPresetGroupName, int priority) {
        InternalCreateMediaRequest request = new InternalCreateMediaRequest().withMediaId(mediaId).withTitle(title).withDescription(description).withSourceExtension(sourceExtension).withTranscodingPresetGroupName(transcodingPresetGroupName).withPriority(priority);
        InternalCreateMediaResponse internalResponse = this.processMedia(request);
        return internalResponse;
    }

    public GenerateMediaIdResponse applyMedia() {
        GenerateMediaIdRequest request = new GenerateMediaIdRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, PATH_MEDIA);
        internalRequest.addParameter(PARA_APPLY, null);
        return this.invokeHttpClient(internalRequest, GenerateMediaIdResponse.class);
    }

    public GenerateMediaIdResponse applyMedia(String mode) {
        GenerateMediaIdRequest request = new GenerateMediaIdRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, PATH_MEDIA);
        internalRequest.addParameter(PARA_APPLY, null);
        internalRequest.addParameter(PARA_APPLY_MODE, mode);
        return this.invokeHttpClient(internalRequest, GenerateMediaIdResponse.class);
    }

    public GetMediaResourceResponse getMediaResource(String mediaId) {
        GetMediaResourceRequest request = new GetMediaResourceRequest().withMediaId(mediaId);
        return this.getMediaResource(request);
    }

    public GetMediaResourceResponse getMediaResource(GetMediaResourceRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_MEDIA, request.getMediaId());
        return this.invokeHttpClient(internalRequest, GetMediaResourceResponse.class);
    }

    public GetPartMediaResourceResponse getPartMediaResource(String mediaId, String scope, String taskId) {
        GetPartMediaResourceRequest request = new GetPartMediaResourceRequest().withMediaId(mediaId).withScope(scope).withTaskId(taskId);
        return this.getPartMediaResource(request);
    }

    public GetPartMediaResourceResponse getPartMediaResource(GetPartMediaResourceRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        Validate.checkStringNotEmpty(request.getScope(), "Scope should not be null or empty!");
        Validate.checkStringNotEmpty(request.getTaskId(), "Task ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_MEDIA, request.getMediaId());
        internalRequest.addParameter(PARA_GET_SCOPE, request.getScope());
        internalRequest.addParameter(PARA_GET_TASK_ID, request.getTaskId());
        return this.invokeHttpClient(internalRequest, GetPartMediaResourceResponse.class);
    }

    public ListMediaResourceResponse listMediaResources(int pageNo, int pageSize, String status, Date begin, Date end, String title) {
        ListMediaResourceRequest request = new ListMediaResourceRequest().withPageNo(pageNo).withPageSize(pageSize).withStatus(status).withBegin(begin).withEnd(end).withTitle(title);
        return this.listMediaResources(request);
    }

    public ListMediaResourceResponse listMediaResources(ListMediaResourceRequest request) {
        Validate.checkIsTrue(request.getPageNo() > 0, "pageNo should greater than 0!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_MEDIA);
        internalRequest.addParameter(PARA_PAGENO, String.valueOf(request.getPageNo()));
        internalRequest.addParameter(PARA_PAGESIZE, String.valueOf(request.getPageSize()));
        if (request.getStatus() != null) {
            internalRequest.addParameter(PARA_STATUS, request.getStatus());
        }
        if (request.getBegin() != null) {
            internalRequest.addParameter(PARA_BEGIN, DateUtils.formatAlternateIso8601Date(request.getBegin()));
        }
        if (request.getEnd() != null) {
            internalRequest.addParameter(PARA_END, DateUtils.formatAlternateIso8601Date(request.getEnd()));
        }
        if (request.getTitle() != null) {
            internalRequest.addParameter(PARA_TITLE, request.getTitle());
        }
        return this.invokeHttpClient(internalRequest, ListMediaResourceResponse.class);
    }

    public ListMediaResourceByMarkerResponse listMediaResourcesByMarker(String marker, int maxSize, String status, Date begin, Date end, String title) {
        ListMediaResourceByMarkerRequest request = new ListMediaResourceByMarkerRequest().withMarker(marker).withMaxSize(maxSize).withStatus(status).withBegin(begin).withEnd(end).withTitle(title);
        return this.listMediaResourcesByMarker(request);
    }

    public ListMediaResourceByMarkerResponse listMediaResourcesByMarker(ListMediaResourceByMarkerRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_MEDIA);
        internalRequest.addParameter(PARAM_MAX_SIZE, String.valueOf(request.getMaxSize()));
        if (request.getMarker() != null) {
            internalRequest.addParameter(PARAM_MARKER, String.valueOf(request.getMarker()));
        }
        if (request.getStatus() != null) {
            internalRequest.addParameter(PARA_STATUS, request.getStatus());
        }
        if (request.getBegin() != null) {
            internalRequest.addParameter(PARA_BEGIN, DateUtils.formatAlternateIso8601Date(request.getBegin()));
        }
        if (request.getEnd() != null) {
            internalRequest.addParameter(PARA_END, DateUtils.formatAlternateIso8601Date(request.getEnd()));
        }
        if (request.getTitle() != null) {
            internalRequest.addParameter(PARA_TITLE, request.getTitle());
        }
        return this.invokeHttpClient(internalRequest, ListMediaResourceByMarkerResponse.class);
    }

    public UpdateMediaResourceResponse updateMediaResource(String mediaId, String title, String description) {
        UpdateMediaResourceRequest request = new UpdateMediaResourceRequest().withMediaId(mediaId).withTitle(title).withDescription(description);
        return this.updateMediaResource(request);
    }

    public UpdateMediaResourceResponse updateMediaResource(UpdateMediaResourceRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, PATH_MEDIA, request.getMediaId());
        internalRequest.addParameter(PARA_ATTRIBUTES, null);
        return this.invokeHttpClient(internalRequest, UpdateMediaResourceResponse.class);
    }

    public StopMediaResourceResponse stopMediaResource(String mediaId) {
        StopMediaResourceRequest request = new StopMediaResourceRequest().withMediaId(mediaId);
        return this.stopMediaResource(request);
    }

    public StopMediaResourceResponse stopMediaResource(StopMediaResourceRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, PATH_MEDIA, request.getMediaId());
        internalRequest.addParameter(PARA_DISABLE, null);
        return this.invokeHttpClient(internalRequest, StopMediaResourceResponse.class);
    }

    public PublishMediaResourceResponse publishMediaResource(String mediaId) {
        PublishMediaResourceRequest request = new PublishMediaResourceRequest().withMediaId(mediaId);
        return this.publishMediaResource(request);
    }

    public PublishMediaResourceResponse publishMediaResource(PublishMediaResourceRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, PATH_MEDIA, request.getMediaId());
        internalRequest.addParameter(PARA_PUBLISH, null);
        return this.invokeHttpClient(internalRequest, PublishMediaResourceResponse.class);
    }

    public DeleteMediaResourceResponse deleteMediaResource(String mediaId) {
        DeleteMediaResourceRequest request = new DeleteMediaResourceRequest().withMediaId(mediaId);
        return this.deleteMediaResource(request);
    }

    public DeleteMediaResourceResponse deleteMediaResource(DeleteMediaResourceRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, PATH_MEDIA, request.getMediaId());
        return this.invokeHttpClient(internalRequest, DeleteMediaResourceResponse.class);
    }

    public GenerateMediaDeliveryInfoResponse generateMediaDeliveryInfo(String mediaId, String transcodingPresetName) {
        GenerateMediaDeliveryInfoRequest request = new GenerateMediaDeliveryInfoRequest().withMediaId(mediaId).withTranscodingPresetName(transcodingPresetName);
        return this.generateMediaDeliveryInfo(request);
    }

    public GenerateMediaDeliveryInfoResponse generateMediaDeliveryInfo(GenerateMediaDeliveryInfoRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_MEDIA, request.getMediaId(), PARA_GENDELIVERY);
        internalRequest.addParameter(PARAM_TRANSCODING_PRESET_NAME, request.getTranscodingPresetName());
        return this.invokeHttpClient(internalRequest, GenerateMediaDeliveryInfoResponse.class);
    }

    public GenerateMediaPlayerCodeResponse generateMediaPlayerCode(String mediaId, int width, int height, boolean autoStart, String transcodingPresetName) {
        GenerateMediaPlayerCodeRequest request = new GenerateMediaPlayerCodeRequest().withMediaId(mediaId).withWidth(width).withHeight(height).withAutoStart(autoStart).withTranscodingPresetName(transcodingPresetName);
        return this.generateMediaPlayerCode(request);
    }

    public GenerateMediaPlayerCodeResponse generateMediaPlayerCode(GenerateMediaPlayerCodeRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        Validate.checkIsTrue(request.getHeight() > 0, "Height of playback view should be positive!");
        Validate.checkIsTrue(request.getWidth() > 0, "Width of playback view should be positive!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_MEDIA, request.getMediaId(), PARA_GENCODE);
        internalRequest.addParameter(PARA_WIDTH, Integer.toString(request.getWidth()));
        internalRequest.addParameter(PARA_HEIGHT, Integer.toString(request.getHeight()));
        internalRequest.addParameter(PARA_AUTO_START_NEW, Boolean.toString(request.isAutoStart()));
        internalRequest.addParameter(PARA_AK, this.config.getCredentials().getAccessKeyId());
        internalRequest.addParameter(PARAM_TRANSCODING_PRESET_NAME, request.getTranscodingPresetName());
        return this.invokeHttpClient(internalRequest, GenerateMediaPlayerCodeResponse.class);
    }

    public GetMediaStatisticResponse getMediaStatistic(String mediaId, Date startTime, Date endTime, boolean aggregate) {
        GetMediaStatisticRequest request = new GetMediaStatisticRequest().withMediaId(mediaId).withStartTime(startTime).withEndTime(endTime).withAggregate(aggregate);
        return this.getMediaStatistic(request);
    }

    public GetMediaStatisticResponse getMediaStatistic(GetMediaStatisticRequest request) {
        Validate.checkIsTrue(request.getMediaId() != null, "mediaId is null!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, MEDIA_STATISTIC, request.getMediaId());
        if (request.getStartTime() != null) {
            internalRequest.addParameter(START_TIME, DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter(END_TIME, DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        internalRequest.addParameter(AGGREGATE, String.valueOf(request.isAggregate()));
        return this.invokeHttpClient(internalRequest, GetMediaStatisticResponse.class);
    }

    public ReTranscodeResponse reTranscode(String mediaId) {
        ReTranscodeRequest request = new ReTranscodeRequest().withMediaId(mediaId);
        return this.reTranscode(request);
    }

    public ReTranscodeResponse reTranscode(ReTranscodeRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, PATH_MEDIA, request.getMediaId());
        internalRequest.addParameter(PARA_RERUN, null);
        return this.invokeHttpClient(internalRequest, ReTranscodeResponse.class);
    }

    public GetMediaSourceDownloadResponse getMediaSourceDownload(String mediaId, long expiredInSeconds) {
        GetMediaSourceDownloadRequest request = new GetMediaSourceDownloadRequest().withMediaId(mediaId).withExpiredInSeconds(expiredInSeconds);
        return this.getMediaSourceDownload(request);
    }

    public GetMediaSourceDownloadResponse getMediaSourceDownload(GetMediaSourceDownloadRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_MEDIA, request.getMediaId());
        internalRequest.addParameter(PARA_DOWNLOAD, null);
        internalRequest.addParameter(PARA_EXPIREDINSECONDS, String.valueOf(request.getExpiredInSeconds()));
        return this.invokeHttpClient(internalRequest, GetMediaSourceDownloadResponse.class);
    }

    public ListNotificationsResponse listNotifications() {
        ListNotificationsRequest request = new ListNotificationsRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_NOTIFICATION);
        return this.invokeHttpClient(internalRequest, ListNotificationsResponse.class);
    }

    public DeleteNotificationResponse deleteNotification(String name) {
        DeleteNotificationRequest request = new DeleteNotificationRequest();
        request.setName(name);
        return this.deleteNotification(request);
    }

    public DeleteNotificationResponse deleteNotification(DeleteNotificationRequest request) {
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, PATH_NOTIFICATION, request.getName());
        return this.invokeHttpClient(internalRequest, DeleteNotificationResponse.class);
    }

    public GetNotificationResponse getNotification(String name) {
        GetNotificationRequest request = new GetNotificationRequest();
        request.setName(name);
        return this.getNotification(request);
    }

    public GetNotificationResponse getNotification(GetNotificationRequest request) {
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_NOTIFICATION, request.getName());
        return this.invokeHttpClient(internalRequest, GetNotificationResponse.class);
    }

    public CreateNotificationResponse createNotification(String name, String endpoint) {
        CreateNotificationRequest request = new CreateNotificationRequest();
        request.withName(name).withEndpoint(endpoint);
        return this.createNotification(request);
    }

    public CreateNotificationResponse createNotification(CreateNotificationRequest request) {
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        Validate.checkStringNotEmpty(request.getEndpoint(), "The parameter endpoint should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, PATH_NOTIFICATION);
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return this.invokeHttpClient(internalRequest, CreateNotificationResponse.class);
    }

    private InternalRequest createRequest(HttpMethodName httpMethod, AbstractBceRequest request, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.setCredentials(request.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillRequestPayload(internalRequest, request);
        }
        return internalRequest;
    }

    private InternalRequest fillRequestPayload(InternalRequest internalRequest, AbstractBceRequest request) {
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return internalRequest;
    }

    private String getFileExtension(String filename) {
        if (filename != null && filename.lastIndexOf(".") != -1) {
            String extension = filename.substring(filename.lastIndexOf(".") + 1);
            if (extension.length() <= 0 || extension.length() > 10) {
                return null;
            }
            if (!extension.matches(VALID_EXTENSION_PATTERN)) {
                return null;
            }
            return extension;
        }
        return null;
    }

    @Override
    public boolean isRegionSupported() {
        return false;
    }
}

