/*
 * Copyright (C) 2016 Baidu, Inc. All Rights Reserved.
 */
package com.baidubce.services.eip.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;

/**
 * The request for autorenew eip.
 */
@Getter
@Setter
public class AutoRenewEipRequest extends AbstractBceRequest {
    /**
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/EIP/API.html#.E9.80.9A.E7.94.A8.E8.AF.B4.E6.98.8E">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;
    /**
     * eip address to be started autoRenew
     */
    private String eip;
    /**
     * autoRenew TimeUnit.
     */
    private String autoRenewTimeUnit;
    /**
     * autoRenewTime.
     */
    private Integer autoRenewTime;

    public AutoRenewEipRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public AutoRenewEipRequest withEip(String eip) {
        this.eip = eip;
        return this;
    }

    public AutoRenewEipRequest withAutoRenewTimeUnit(String autoRenewTimeUnit) {
        this.autoRenewTimeUnit = autoRenewTimeUnit;
        return this;
    }

    public AutoRenewEipRequest withAutoRenewTime(Integer autoRenewTime) {
        this.autoRenewTime = autoRenewTime;
        return this;
    }

    public AutoRenewEipRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
