package com.baidubce.services.vpn.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.eip.model.Billing;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

/**
 *  Renew vpn
 */
@Data
public class RenewVpnRequest extends AbstractBceRequest {

    /*********************** Required **************************/
    /**vpn id*/
    private String vpnId;
    /** Billing information, support prepaid and postpaid methods */
    private Billing billing;


    /************************ Not required **********************/
    /**
     * An ASCII string whose length is less than 64.
     *
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *     BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
