/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.eni.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class EniOperateRequest
extends AbstractBceRequest {
    @JsonIgnore
    private String clientToken;
    private String action;
    private String eniId;

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    public static EniOperateRequestBuilder builder() {
        return new EniOperateRequestBuilder();
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public String getAction() {
        return this.action;
    }

    public String getEniId() {
        return this.eniId;
    }

    public EniOperateRequest setClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public EniOperateRequest setAction(String action) {
        this.action = action;
        return this;
    }

    public EniOperateRequest setEniId(String eniId) {
        this.eniId = eniId;
        return this;
    }

    public String toString() {
        return "EniOperateRequest(clientToken=" + this.getClientToken() + ", action=" + this.getAction() + ", eniId=" + this.getEniId() + ")";
    }

    public EniOperateRequest(String clientToken, String action, String eniId) {
        this.clientToken = clientToken;
        this.action = action;
        this.eniId = eniId;
    }

    public EniOperateRequest() {
    }

    public static class EniOperateRequestBuilder {
        private String clientToken;
        private String action;
        private String eniId;

        EniOperateRequestBuilder() {
        }

        public EniOperateRequestBuilder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public EniOperateRequestBuilder action(String action) {
            this.action = action;
            return this;
        }

        public EniOperateRequestBuilder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public EniOperateRequest build() {
            return new EniOperateRequest(this.clientToken, this.action, this.eniId);
        }

        public String toString() {
            return "EniOperateRequest.EniOperateRequestBuilder(clientToken=" + this.clientToken + ", action=" + this.action + ", eniId=" + this.eniId + ")";
        }
    }
}

