/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.etgateway;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.etgateway.EtGatewayClientConfiguration;
import com.baidubce.services.etgateway.model.BindEtChannelRequest;
import com.baidubce.services.etgateway.model.CreateEtGatewayHealthCheckRequest;
import com.baidubce.services.etgateway.model.CreateEtGatewayRequest;
import com.baidubce.services.etgateway.model.CreateEtGatewayResponse;
import com.baidubce.services.etgateway.model.DeleteEtGatewayRequest;
import com.baidubce.services.etgateway.model.GetEtGatewayRequest;
import com.baidubce.services.etgateway.model.GetEtGatewayResponse;
import com.baidubce.services.etgateway.model.ListEtGatewayRequest;
import com.baidubce.services.etgateway.model.ListEtGatewayResponse;
import com.baidubce.services.etgateway.model.UnbindEtChannelRequest;
import com.baidubce.services.etgateway.model.UpdateEtGatewayRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtGatewayClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtGatewayClient.class);
    private static final String VERSION = "v1";
    private static final String ETGATEWAY_PREFIX = "etGateway";
    private static final String ETGATEWAY_HEALTH_CHECK_PREFIX = "healthCheck";
    private static final HttpResponseHandler[] ETGATEWAY_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public EtGatewayClient() {
        this(new EtGatewayClientConfiguration());
    }

    public EtGatewayClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, ETGATEWAY_HANDLERS);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public CreateEtGatewayResponse createEtGateway(CreateEtGatewayRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)request.getVpcId(), (Object)"request vpcId should not be null.");
        Preconditions.checkNotNull((Object)request.getName(), (Object)"request name should not be null.");
        Preconditions.checkNotNull((Object)request.getSpeed(), (Object)"request speed should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ETGATEWAY_PREFIX);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateEtGatewayResponse.class);
    }

    public ListEtGatewayResponse listEtGateways(ListEtGatewayRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)request.getVpcId(), (Object)"request vpcId should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ETGATEWAY_PREFIX);
        internalRequest.addParameter("vpcId", request.getVpcId());
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getStatus())) {
            internalRequest.addParameter("status", request.getStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getEtGatewayId())) {
            internalRequest.addParameter("etGatewayId", request.getEtGatewayId());
        }
        return this.invokeHttpClient(internalRequest, ListEtGatewayResponse.class);
    }

    public GetEtGatewayResponse getEtGateway(String etGatewayId) {
        return this.getEtGateway(new GetEtGatewayRequest().setEtGatewayId(etGatewayId));
    }

    private GetEtGatewayResponse getEtGateway(GetEtGatewayRequest request) {
        Preconditions.checkNotNull((Object)request.getEtGatewayId(), (Object)"etGatewayId should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ETGATEWAY_PREFIX, request.getEtGatewayId());
        return this.invokeHttpClient(internalRequest, GetEtGatewayResponse.class);
    }

    public void updateEtGateway(UpdateEtGatewayRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)request.getEtGatewayId(), (Object)"etGatewayId should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ETGATEWAY_PREFIX, request.getEtGatewayId());
        this.fillPayload(internalRequest, request);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteEtGateway(String etGatewayId) {
        this.deleteEtGateway(new DeleteEtGatewayRequest().setEtGatewayId(etGatewayId));
    }

    public void deleteEtGateway(String etGatewayId, String clientToken) {
        this.deleteEtGateway(new DeleteEtGatewayRequest().setEtGatewayId(etGatewayId).setClientToken(clientToken));
    }

    private void deleteEtGateway(DeleteEtGatewayRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)request.getEtGatewayId(), (Object)"etGatewayId should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, ETGATEWAY_PREFIX, request.getEtGatewayId());
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void bindEtChannel(BindEtChannelRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)request.getEtGatewayId(), (Object)"etGatewayId should not be null.");
        Preconditions.checkNotNull((Object)request.getEtId(), (Object)"etGatewayId should not be null.");
        Preconditions.checkNotNull((Object)request.getChannelId(), (Object)"etGatewayId should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ETGATEWAY_PREFIX, request.getEtGatewayId());
        internalRequest.addParameter("clientToken", request.getClientToken());
        internalRequest.addParameter("bind", "");
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unbindEtChannel(UnbindEtChannelRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)request.getEtGatewayId(), (Object)"etGatewayId should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ETGATEWAY_PREFIX, request.getEtGatewayId());
        internalRequest.addParameter("clientToken", request.getClientToken());
        internalRequest.addParameter("unbind", "");
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void createEtGatewayHealthCheck(CreateEtGatewayHealthCheckRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)request.getEtGatewayId(), (Object)"etGatewayId should not be null.");
        Preconditions.checkNotNull((Object)request.getHealthCheckInterval(), (Object)"healthCheckInterval should not be null.");
        Preconditions.checkNotNull((Object)request.getHealthThreshold(), (Object)"healthThreshold should not be null.");
        Preconditions.checkNotNull((Object)request.getUnhealthThreshold(), (Object)"unhealthThreshold should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ETGATEWAY_PREFIX, request.getEtGatewayId(), ETGATEWAY_HEALTH_CHECK_PREFIX);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }
}

