/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.probe;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.probe.ProbeClientConfiguration;
import com.baidubce.services.probe.model.CreateProbeRequest;
import com.baidubce.services.probe.model.CreateProbeResponse;
import com.baidubce.services.probe.model.DeleteProbeRequest;
import com.baidubce.services.probe.model.GetProbeRequest;
import com.baidubce.services.probe.model.GetProbeResponse;
import com.baidubce.services.probe.model.ListProbeRequest;
import com.baidubce.services.probe.model.ListProbeResponse;
import com.baidubce.services.probe.model.UpdateProbeRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbeClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProbeClient.class);
    private static final String VERSION = "v1";
    private static final String PROBE_PREFIX = "probe";
    private static final HttpResponseHandler[] PROBE_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public ProbeClient() {
        this(new ProbeClientConfiguration());
    }

    public ProbeClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, PROBE_HANDLERS);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public CreateProbeResponse createProbe(CreateProbeRequest request) throws BceClientException {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PROBE_PREFIX);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateProbeResponse.class);
    }

    public ListProbeResponse listProbes() {
        return this.listProbes(new ListProbeRequest());
    }

    public ListProbeResponse listProbes(ListProbeRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, PROBE_PREFIX);
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListProbeResponse.class);
    }

    public GetProbeResponse getProbe(String probeId) {
        return this.getProbe(new GetProbeRequest().setProbeId(probeId));
    }

    private GetProbeResponse getProbe(GetProbeRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)request.getProbeId(), (Object)"request probeId should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, PROBE_PREFIX, request.getProbeId());
        return this.invokeHttpClient(internalRequest, GetProbeResponse.class);
    }

    public void updateProbe(UpdateProbeRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PROBE_PREFIX, request.getProbeId());
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteProbe(String probeId) {
        this.deleteProbe(new DeleteProbeRequest().setProbeId(probeId));
    }

    public void deleteProbe(String probeId, String clientToken) {
        this.deleteProbe(new DeleteProbeRequest().setProbeId(probeId).setClientToken(clientToken));
    }

    private void deleteProbe(DeleteProbeRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, PROBE_PREFIX, request.getProbeId());
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }
}

