/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.vca;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.vca.model.AnalyzeCancelRequest;
import com.baidubce.services.vca.model.AnalyzeCancelResponse;
import com.baidubce.services.vca.model.AnalyzeRequest;
import com.baidubce.services.vca.model.AnalyzeResponse;
import com.baidubce.services.vca.model.HighlightAnalyzeRequest;
import com.baidubce.services.vca.model.ImageAnalyzeResponse;
import com.baidubce.services.vca.model.McaEmptyRequest;
import com.baidubce.services.vca.model.McaEmptyResponse;
import com.baidubce.services.vca.model.QueryResultRequest;
import com.baidubce.services.vca.model.QueryResultResponse;
import com.baidubce.services.vca.model.QuerySubTaskRequest;
import com.baidubce.services.vca.model.QuerySubTaskResponse;
import com.baidubce.services.vca.model.StreamAnalyzeRequest;
import com.baidubce.services.vca.model.StreamAnalyzeResponse;
import com.baidubce.services.vca.model.StreamStopResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;

public class VcaClient
extends AbstractBceClient {
    private static final String VERSION = "v2";
    private static final String VERSION_1 = "v1";
    private static final String MEDIA = "media";
    private static final String STREAM = "stream";
    private static final String IMAGE = "image";
    private static final String COVER = "cover";
    private static final String HIGHLIGHT = "highlight";
    private static HttpResponseHandler[] vcaHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public VcaClient() {
        this(new BceClientConfiguration());
    }

    public VcaClient(BceClientConfiguration config) {
        super(config, vcaHandlers);
    }

    public AnalyzeResponse analyze(String source) {
        AnalyzeRequest request = new AnalyzeRequest();
        request.setSource(source);
        return this.analyze(request);
    }

    public AnalyzeResponse analyze(String source, String title) {
        AnalyzeRequest request = new AnalyzeRequest();
        request.setSource(source);
        request.setTitle(title);
        return this.analyze(request);
    }

    public AnalyzeResponse analyze(AnalyzeRequest request) {
        InternalRequest internalRequest = this.createRequest(VERSION, HttpMethodName.PUT, request, MEDIA);
        return this.invokeHttpClient(internalRequest, AnalyzeResponse.class);
    }

    public AnalyzeCancelResponse cancel(AnalyzeCancelRequest request) {
        InternalRequest internalRequest = this.createRequest(VERSION, HttpMethodName.PUT, request, MEDIA);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", request.getSource());
        params.put("cancel", null);
        internalRequest.setParameters(params);
        return this.invokeHttpClient(internalRequest, AnalyzeCancelResponse.class);
    }

    public AnalyzeCancelResponse cancel(String source) {
        AnalyzeCancelRequest request = new AnalyzeCancelRequest();
        request.setSource(source);
        return this.cancel(request);
    }

    public StreamAnalyzeResponse analyzeStream(StreamAnalyzeRequest request) {
        InternalRequest internalRequest = this.createRequest(VERSION, HttpMethodName.PUT, request, STREAM);
        return this.invokeHttpClient(internalRequest, StreamAnalyzeResponse.class);
    }

    public StreamAnalyzeResponse queryStream(String source) {
        QueryResultRequest request = new QueryResultRequest();
        request.withMediaSource(source);
        InternalRequest internalRequest = this.createRequest(VERSION, HttpMethodName.GET, request, STREAM);
        internalRequest.addParameter("source", request.getSource());
        return this.invokeHttpClient(internalRequest, StreamAnalyzeResponse.class);
    }

    public void stopStream(String source) {
        QueryResultRequest request = new QueryResultRequest();
        request.withMediaSource(source);
        InternalRequest internalRequest = this.createRequest(VERSION, HttpMethodName.PUT, request, STREAM);
        internalRequest.addParameter("stop", "");
        this.invokeHttpClient(internalRequest, StreamStopResponse.class);
    }

    public AnalyzeResponse analyzeCover(String source) {
        AnalyzeRequest request = new AnalyzeRequest();
        request.setSource(source);
        InternalRequest internalRequest = this.createRequest(VERSION_1, HttpMethodName.PUT, request, COVER);
        return this.invokeHttpClient(internalRequest, AnalyzeResponse.class);
    }

    public AnalyzeResponse analyzeHighlight(String source) {
        HighlightAnalyzeRequest request = new HighlightAnalyzeRequest();
        request.setSource(source);
        return this.analyzeHighlight(request);
    }

    public AnalyzeResponse analyzeHighlight(HighlightAnalyzeRequest request) {
        InternalRequest internalRequest = this.createRequest(VERSION_1, HttpMethodName.PUT, request, HIGHLIGHT);
        return this.invokeHttpClient(internalRequest, AnalyzeResponse.class);
    }

    public ImageAnalyzeResponse analyzeImage(String source) {
        AnalyzeRequest request = new AnalyzeRequest();
        request.setSource(source);
        return this.analyzeImage(request);
    }

    public ImageAnalyzeResponse analyzeImage(String source, String title) {
        AnalyzeRequest request = new AnalyzeRequest();
        request.setSource(source);
        request.setTitle(title);
        return this.analyzeImage(request);
    }

    public ImageAnalyzeResponse analyzeImage(AnalyzeRequest request) {
        InternalRequest internalRequest = this.createRequest(VERSION, HttpMethodName.PUT, request, IMAGE);
        internalRequest.addParameter("sync", "");
        return this.invokeHttpClient(internalRequest, ImageAnalyzeResponse.class);
    }

    public QueryResultResponse queryResult(String source) {
        QueryResultRequest request = new QueryResultRequest();
        request.setSource(source);
        return this.queryResult(request);
    }

    public QueryResultResponse queryResult(QueryResultRequest request) {
        InternalRequest internalRequest = this.createRequest(VERSION, HttpMethodName.GET, request, MEDIA);
        internalRequest.addParameter("source", request.getSource());
        return this.invokeHttpClient(internalRequest, QueryResultResponse.class);
    }

    public QueryResultResponse queryCoverResult(String source) {
        QueryResultRequest request = new QueryResultRequest();
        request.setSource(source);
        InternalRequest internalRequest = this.createRequest(VERSION_1, HttpMethodName.GET, request, COVER);
        internalRequest.addParameter("source", request.getSource());
        return this.invokeHttpClient(internalRequest, QueryResultResponse.class);
    }

    public QueryResultResponse queryHighlightResult(String source) {
        QueryResultRequest request = new QueryResultRequest();
        request.setSource(source);
        InternalRequest internalRequest = this.createRequest(VERSION_1, HttpMethodName.GET, request, HIGHLIGHT);
        internalRequest.addParameter("source", request.getSource());
        return this.invokeHttpClient(internalRequest, QueryResultResponse.class);
    }

    public McaEmptyResponse cancelHighlightResult(String source) {
        InternalRequest internalRequest = this.createRequest(VERSION_1, HttpMethodName.PUT, new McaEmptyRequest(), HIGHLIGHT);
        internalRequest.addParameter("source", source);
        internalRequest.addParameter("cancel", "");
        return this.invokeHttpClient(internalRequest, McaEmptyResponse.class);
    }

    public QuerySubTaskResponse querySubTask(String source, String type) {
        QuerySubTaskRequest request = new QuerySubTaskRequest();
        request.setSource(source);
        request.setSubTaskType(type);
        return this.querySubTask(request);
    }

    public QuerySubTaskResponse querySubTask(QuerySubTaskRequest request) {
        InternalRequest internalRequest = this.createRequest(VERSION, HttpMethodName.GET, request, MEDIA, request.getSubTaskType());
        internalRequest.addParameter("source", request.getSource());
        return this.invokeHttpClient(internalRequest, QuerySubTaskResponse.class);
    }

    private InternalRequest createRequest(String version, HttpMethodName httpMethod, AbstractBceRequest request, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add(version);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.setCredentials(request.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillRequestPayload(internalRequest, request);
        }
        return internalRequest;
    }

    private InternalRequest fillRequestPayload(InternalRequest internalRequest, AbstractBceRequest request) {
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return internalRequest;
    }
}

