/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.eipgroup;

import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.bcc.model.TagModel;
import com.baidubce.services.eip.model.Billing;
import com.baidubce.services.eipgroup.EipGroupClient;
import com.baidubce.services.eipgroup.EipGroupClientConfiguration;
import com.baidubce.services.eipgroup.model.CreateEipGroupRequest;
import com.baidubce.services.eipgroup.model.IdResponse;
import com.google.common.collect.Lists;

public class ExampleCreateEipGroup {
    public static void main(String[] args) {
        String ak = "Your Ak";
        String sk = "Your Sk";
        String endpoint = "eip.bj.baidubce.com";
        EipGroupClientConfiguration config = new EipGroupClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        EipGroupClient eipGroupClient = new EipGroupClient(config);
        CreateEipGroupRequest request = new CreateEipGroupRequest();
        Billing.Reservation reservation = new Billing.Reservation();
        reservation.setReservationLength(1);
        reservation.setReservationTimeUnit("Month");
        Billing billing = new Billing();
        billing.setPaymentTiming("Prepaid");
        billing.setReservation(reservation);
        request.setBilling(billing);
        request.setName("EipGroupTest");
        request.setEipCount(2);
        request.setBandwidthInMbps(10);
        request.setResourceGroupId("RESG-J7PdULjguvB");
        TagModel tagModel = new TagModel();
        tagModel.setTagKey("tagK");
        tagModel.setTagValue("tagV");
        request.setTags(Lists.newArrayList((Object[])new TagModel[]{tagModel}));
        try {
            IdResponse response = eipGroupClient.createEipGroup(request);
            System.out.println(response);
        }
        catch (BceClientException e) {
            System.out.println(e.getMessage());
        }
    }
}

