/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.rds;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.rds.RdsArgumentUtil;
import com.baidubce.services.rds.RdsClientConfiguration;
import com.baidubce.services.rds.model.DatabaseEntryPort;
import com.baidubce.services.rds.model.DatabasePrivilege;
import com.baidubce.services.rds.model.DatabasePrivilegeList;
import com.baidubce.services.rds.model.PassWord;
import com.baidubce.services.rds.model.RdsAccount;
import com.baidubce.services.rds.model.RdsAccountInfoRequest;
import com.baidubce.services.rds.model.RdsAccountListRequest;
import com.baidubce.services.rds.model.RdsAccountListResponse;
import com.baidubce.services.rds.model.RdsAddress;
import com.baidubce.services.rds.model.RdsAutoRenewRequest;
import com.baidubce.services.rds.model.RdsBackupInfoRequest;
import com.baidubce.services.rds.model.RdsBackupInfoResponse;
import com.baidubce.services.rds.model.RdsBatchScalingRequest;
import com.baidubce.services.rds.model.RdsBatchScalingResponse;
import com.baidubce.services.rds.model.RdsBilling;
import com.baidubce.services.rds.model.RdsBindingTagsRequest;
import com.baidubce.services.rds.model.RdsChangeDatabasePortRequest;
import com.baidubce.services.rds.model.RdsClusterStatusCheckRequest;
import com.baidubce.services.rds.model.RdsClusterStatusCheckResponse;
import com.baidubce.services.rds.model.RdsConnInformationRequest;
import com.baidubce.services.rds.model.RdsCreateAccountRequest;
import com.baidubce.services.rds.model.RdsCreateDatabaseRequest;
import com.baidubce.services.rds.model.RdsCreateInstanceRequest;
import com.baidubce.services.rds.model.RdsCreateInstanceResponse;
import com.baidubce.services.rds.model.RdsCreateProxyInstance;
import com.baidubce.services.rds.model.RdsCreateReadableInstance;
import com.baidubce.services.rds.model.RdsDeleteAccountRequest;
import com.baidubce.services.rds.model.RdsDeleteDatabaseRequest;
import com.baidubce.services.rds.model.RdsDeleteSpecifiedBackUpRequest;
import com.baidubce.services.rds.model.RdsDialingTestRequest;
import com.baidubce.services.rds.model.RdsDialingTestResponse;
import com.baidubce.services.rds.model.RdsEngine;
import com.baidubce.services.rds.model.RdsFullPhysicalBackupRequest;
import com.baidubce.services.rds.model.RdsGetAutoConfigForSpecifiedRequest;
import com.baidubce.services.rds.model.RdsGetAutoConfigForSpecifiedResponse;
import com.baidubce.services.rds.model.RdsGetBackupListRequest;
import com.baidubce.services.rds.model.RdsGetBackupListResponse;
import com.baidubce.services.rds.model.RdsGetBinLogInfoRequest;
import com.baidubce.services.rds.model.RdsGetBinLogInfoRsponse;
import com.baidubce.services.rds.model.RdsGetBinLogListRequest;
import com.baidubce.services.rds.model.RdsGetBinLogListResponse;
import com.baidubce.services.rds.model.RdsGetDatabaseListRequest;
import com.baidubce.services.rds.model.RdsGetDatabaseListResponse;
import com.baidubce.services.rds.model.RdsGetNewPurchasePriceRequest;
import com.baidubce.services.rds.model.RdsGetNewPurchasePriceResponse;
import com.baidubce.services.rds.model.RdsGetOrderStatusRequest;
import com.baidubce.services.rds.model.RdsGetOrderStatusResponse;
import com.baidubce.services.rds.model.RdsGetPGListRequest;
import com.baidubce.services.rds.model.RdsGetPGListResponse;
import com.baidubce.services.rds.model.RdsGetPGLogDetailsRequest;
import com.baidubce.services.rds.model.RdsGetPGLogDetailsResponse;
import com.baidubce.services.rds.model.RdsGetPriceDifferenceRequest;
import com.baidubce.services.rds.model.RdsGetPriceDifferenceResponse;
import com.baidubce.services.rds.model.RdsInstanceDetailRequest;
import com.baidubce.services.rds.model.RdsInstanceDetailResponse;
import com.baidubce.services.rds.model.RdsInstanceListRequest;
import com.baidubce.services.rds.model.RdsInstanceListResponse;
import com.baidubce.services.rds.model.RdsInstanceName;
import com.baidubce.services.rds.model.RdsInstanceResizeRequest;
import com.baidubce.services.rds.model.RdsModifyAccountPasswordRequest;
import com.baidubce.services.rds.model.RdsModifyAccountPermissionRequest;
import com.baidubce.services.rds.model.RdsModifyAccountRemarksRequest;
import com.baidubce.services.rds.model.RdsModifyBackupRequest;
import com.baidubce.services.rds.model.RdsModifyDatabaseDescriptionRequest;
import com.baidubce.services.rds.model.RdsModifyParameterRequest;
import com.baidubce.services.rds.model.RdsNetworkStatusRequest;
import com.baidubce.services.rds.model.RdsParameterListRequest;
import com.baidubce.services.rds.model.RdsParameterListResponse;
import com.baidubce.services.rds.model.RdsPaymentTiming;
import com.baidubce.services.rds.model.RdsPublicAccess;
import com.baidubce.services.rds.model.RdsRecoverForBackUpSetRequest;
import com.baidubce.services.rds.model.RdsRecoverForTimeNodeRequest;
import com.baidubce.services.rds.model.RdsReleaseInstanceRequest;
import com.baidubce.services.rds.model.RdsReleaseInstanceResponse;
import com.baidubce.services.rds.model.RdsRemark;
import com.baidubce.services.rds.model.RdsRenewalRequest;
import com.baidubce.services.rds.model.RdsRenewalResponse;
import com.baidubce.services.rds.model.RdsReservation;
import com.baidubce.services.rds.model.RdsRestartRequest;
import com.baidubce.services.rds.model.RdsSlowLogDownloadDetailRequest;
import com.baidubce.services.rds.model.RdsSlowLogDownloadDetailResponse;
import com.baidubce.services.rds.model.RdsSlowLogDownloadTasksRequest;
import com.baidubce.services.rds.model.RdsSlowLogDownloadTasksResponse;
import com.baidubce.services.rds.model.RdsSlowLogErrorLogDownloadDetailsRequest;
import com.baidubce.services.rds.model.RdsSlowLogErrorLogDownloadDetailsResponse;
import com.baidubce.services.rds.model.RdsSlowLogGetErrorLogDetailsRequest;
import com.baidubce.services.rds.model.RdsSlowLogGetErrorLogDetailsResponse;
import com.baidubce.services.rds.model.RdsSlowLogGetErrorLogListRequest;
import com.baidubce.services.rds.model.RdsSlowLogGetErrorLogListResponse;
import com.baidubce.services.rds.model.RdsSlowLogRequest;
import com.baidubce.services.rds.model.RdsSlowLogResponse;
import com.baidubce.services.rds.model.RdsSubnetRequest;
import com.baidubce.services.rds.model.RdsSubnetResponse;
import com.baidubce.services.rds.model.RdsSupportEnableAutoExpansionRequest;
import com.baidubce.services.rds.model.RdsSupportEnableAutoExpansionResponse;
import com.baidubce.services.rds.model.RdsSupportHotSwappingRequest;
import com.baidubce.services.rds.model.RdsSupportHotSwappingResponse;
import com.baidubce.services.rds.model.RdsSyncMode;
import com.baidubce.services.rds.model.RdsSyncModeRequest;
import com.baidubce.services.rds.model.RdsTag;
import com.baidubce.services.rds.model.RdsUpdateNameRequest;
import com.baidubce.services.rds.model.RdsUpdateStorageAutoExpansionConfigRequest;
import com.baidubce.services.rds.model.RdsUpdateStorageAutoExpansionConfigResPonse;
import com.baidubce.services.rds.model.RdsUpdateTimeWindowRequest;
import com.baidubce.services.rds.model.RdsUpdateWriteListResquest;
import com.baidubce.services.rds.model.RdsViewWriteListRequest;
import com.baidubce.services.rds.model.RdsViewWriteListResponse;
import com.baidubce.services.rds.model.RdsZoneMigrationRequest;
import com.baidubce.services.rds.model.RdsZoneRequest;
import com.baidubce.services.rds.model.RdsZoneResponse;
import com.baidubce.services.rds.model.Resource;
import com.baidubce.services.rds.model.SecurityIps;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class RdsClient
extends AbstractBceClient {
    private static final String X_BCE_IF_MATCH = "x-bce-if-match";
    private static final String X_BCE_ACCESSKEY = "X-Bce-Accesskey";
    private static final HttpResponseHandler[] RDS_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};
    private static final String BCE_HEADER_ETAG = "x-bce-if-match";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final String REQUEST_KEY = "request";
    private static final String INSTANCE_ID_KEY = "instanceId";
    private static final String CLIENT_TOKEN = "clientToken";
    private static final String ACCOUNT_NAME_KEY = "accountName";
    private static final String DESC_KEY = "desc";

    private static void print(String method, Object obj) {
        try {
            String json = JsonUtils.toJsonPrettyString(obj);
            System.out.println(json);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    public RdsClient() {
        this(new RdsClientConfiguration());
    }

    public RdsClient(BceClientConfiguration configuration) {
        this(configuration, RDS_HANDLERS);
    }

    public RdsClient(BceClientConfiguration config, HttpResponseHandler[] responseHandlers) {
        super(config, responseHandlers);
    }

    private InternalRequest createRequest(AbstractBceRequest request, HttpMethodName method, String ... pathVariables) {
        return this.createRequest(null, request, method, pathVariables);
    }

    private InternalRequest createRequest(String version, AbstractBceRequest request, HttpMethodName method, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        if (StringUtils.isEmpty((String)version)) {
            path.add("v1");
        } else {
            path.add(version);
        }
        if (pathVariables != null) {
            Collections.addAll(path, pathVariables);
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[0]));
        InternalRequest internalRequest = new InternalRequest(method, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        internalRequest.setSignOptions(signOptions);
        internalRequest.setCredentials(request.getRequestCredentials());
        return internalRequest;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest request) {
        if (HttpMethodName.POST == internalRequest.getHttpMethod() || HttpMethodName.PUT == internalRequest.getHttpMethod()) {
            byte[] requestJson;
            String strJson = JsonUtils.toJsonString(request);
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String aes128WithFirst16Char(String content, String privateKey) throws GeneralSecurityException {
        byte[] crypted = null;
        SecretKeySpec skey = new SecretKeySpec(privateKey.substring(0, 16).getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, skey);
        crypted = cipher.doFinal(content.getBytes());
        return new String(Hex.encodeHex((byte[])crypted));
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    private RdsBilling generateDefaultBilling() {
        RdsBilling billing = new RdsBilling();
        billing.setPaymentTiming(RdsPaymentTiming.Postpaid);
        return billing;
    }

    private RdsBilling generateDefaultBillingWithReservation() {
        RdsBilling billing = new RdsBilling();
        billing.setPaymentTiming(RdsPaymentTiming.Prepaid);
        RdsReservation reservation = new RdsReservation();
        reservation.setReservationLength(1);
        reservation.setReservationTimeUnit("month");
        return billing;
    }

    public RdsInstanceListResponse getRdsInstanceList(RdsInstanceListRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkMaxKeys(request.getMaxKeys());
        String[] paths = new String[]{"instance"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsInstanceListResponse.class);
    }

    public RdsInstanceDetailResponse getRdsInstanceDetail(RdsInstanceDetailRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsInstanceDetailResponse.class);
    }

    public AbstractBceResponse createAccount(RdsCreateAccountRequest request) throws GeneralSecurityException {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getDesc(), DESC_KEY);
        RdsInstanceDetailRequest detailRequest = new RdsInstanceDetailRequest();
        detailRequest.setInstanceId(request.getInstanceId());
        RdsInstanceDetailResponse detailResponse = this.getRdsInstanceDetail(detailRequest);
        if (RdsEngine.MySQL != detailResponse.getEngine() && RdsEngine.SQLServer != detailResponse.getEngine() && CollectionUtils.isNotEmpty(request.getDatabasePrivileges())) {
            throw new BceClientException("Rds databasePrivileges only support the engine mySql or SQLServer");
        }
        String clientToken = request.getClientToken();
        if (StringUtils.isEmpty((String)clientToken)) {
            request.setClientToken(this.generateClientToken());
        }
        String[] paths = new String[]{"instance", request.getInstanceId(), "account"};
        String sourcePassword = request.getPassword();
        String signedPassword = this.aes128WithFirst16Char(sourcePassword, this.config.getCredentials().getSecretKey());
        request.setPassword(signedPassword);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        RdsClient.print("", internalRequest);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public RdsAccountListResponse getAccountList(RdsAccountListRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId, "account"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsAccountListResponse.class);
    }

    public RdsAccount getSpecificAccountInfo(RdsAccountInfoRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getAccountName(), ACCOUNT_NAME_KEY);
        String instanceId = request.getInstanceId();
        String accountName = request.getAccountName();
        String[] paths = new String[]{"instance", instanceId, "account", accountName};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsAccount.class);
    }

    public AbstractBceResponse modifyAccountRemark(RdsModifyAccountRemarksRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getAccountName(), ACCOUNT_NAME_KEY);
        RdsArgumentUtil.checkNull(request.getRemark(), "remark");
        String instanceId = request.getInstanceId();
        String accountName = request.getAccountName();
        RdsRemark remark = new RdsRemark();
        remark.setRemark(request.getRemark());
        String[] paths = new String[]{"instance", instanceId, "account", accountName, DESC_KEY};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        this.fillPayload(internalRequest, remark);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse modifyAccountPermissions(RdsModifyAccountPermissionRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getAccountName(), ACCOUNT_NAME_KEY);
        RdsArgumentUtil.checkNull(request.getDatabasePrivileges(), "databasePrivileges");
        RdsInstanceDetailRequest detailRequest = new RdsInstanceDetailRequest();
        detailRequest.setInstanceId(request.getInstanceId());
        RdsInstanceDetailResponse detailResponse = this.getRdsInstanceDetail(detailRequest);
        if (RdsEngine.MySQL != detailResponse.getEngine() && RdsEngine.SQLServer != detailResponse.getEngine() && CollectionUtils.isNotEmpty(request.getDatabasePrivileges())) {
            throw new BceClientException("Rds databasePrivileges only support the engine mySql or SQLServer");
        }
        String instanceId = request.getInstanceId();
        String accountName = request.getAccountName();
        String[] paths = new String[]{"instance", instanceId, "account", accountName, "privileges"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        internalRequest.addHeader("x-bce-if-match", "v1");
        internalRequest.addHeader(X_BCE_ACCESSKEY, this.config.getCredentials().getAccessKeyId());
        ArrayList<DatabasePrivilege> privileges = new ArrayList<DatabasePrivilege>();
        privileges.add(request.getDatabasePrivileges().get(0));
        DatabasePrivilegeList list = new DatabasePrivilegeList();
        list.setDatabasePrivileges(privileges);
        this.fillPayload(internalRequest, list);
        RdsClient.print("", internalRequest);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse modifyAccountPassword(RdsModifyAccountPasswordRequest request) throws GeneralSecurityException {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getAccountName(), ACCOUNT_NAME_KEY);
        String sourcePassword = request.getPassword();
        String signedPassword = this.aes128WithFirst16Char(sourcePassword, this.config.getCredentials().getSecretKey());
        request.setPassword(signedPassword);
        String instanceId = request.getInstanceId();
        String accountName = request.getAccountName();
        String[] paths = new String[]{"instance", instanceId, "account", accountName, "password"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        internalRequest.addHeader(X_BCE_ACCESSKEY, this.config.getCredentials().getAccessKeyId());
        PassWord passWord = new PassWord();
        passWord.setPassword(request.getPassword());
        this.fillPayload(internalRequest, passWord);
        RdsClient.print("", internalRequest);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse deleteAccount(RdsDeleteAccountRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getAccountName(), ACCOUNT_NAME_KEY);
        String instanceId = request.getInstanceId();
        String accountName = request.getAccountName();
        String[] paths = new String[]{"instance", instanceId, "account", accountName};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, paths);
        return this.invokeHttpClient(internalRequest, RdsAccount.class);
    }

    public AbstractBceResponse resizeInstance(RdsInstanceResizeRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        Integer cpuCount = request.getCpuCount();
        Integer memoryCapacity = request.getMemoryCapacity();
        Integer volumeCapacity = request.getVolumeCapacity();
        if (cpuCount == null && memoryCapacity == null && volumeCapacity == null) {
            String msg = "Please set one of cpuCount,memoryCapacity,volumeCapacity when resize instance";
            throw new BceClientException(msg);
        }
        RdsArgumentUtil.checkVolumeCapacity(volumeCapacity);
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        internalRequest.addParameter("resize", null);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public RdsCreateInstanceResponse createInstance(RdsCreateInstanceRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        if (StringUtils.isEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (request.getBilling() == null) {
            request.setBilling(this.generateDefaultBilling());
        }
        RdsArgumentUtil.checkPurchaseCount(request.getPurchaseCount());
        RdsArgumentUtil.checkEngine(request.getEngine());
        RdsArgumentUtil.checkEngineVersion(request.getEngineVersion());
        RdsArgumentUtil.checkCpuCount(request.getCpuCount());
        RdsArgumentUtil.checkMemoryCapacity(request.getMemoryCapacity());
        RdsArgumentUtil.checkVolumeCapacity(request.getVolumeCapacity());
        RdsArgumentUtil.checkCharacterSetName(request.getCharacterSetName());
        RdsArgumentUtil.checkAutoRenew(request);
        String[] paths = new String[]{"instance"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, RdsCreateInstanceResponse.class);
    }

    public RdsSlowLogResponse getSlowLog(RdsSlowLogRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsArgumentUtil.checkString(instanceId, INSTANCE_ID_KEY);
        RdsArgumentUtil.checkNull(request.getStartTime(), "startTime");
        RdsArgumentUtil.checkNull(request.getEndTime(), "endTime");
        RdsArgumentUtil.checkPage(request.getPageNo(), request.getPageSize());
        String[] paths = new String[]{"instance", instanceId, "slowlogs", "details"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, RdsSlowLogResponse.class);
    }

    public AbstractBceResponse autoRenew(RdsAutoRenewRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        if (CollectionUtils.isEmpty(request.getInstanceIds())) {
            throw new BceClientException("Please set instanceIds");
        }
        RdsArgumentUtil.checkAutoRenew(request.getAutoRenewTimeUnit(), request.getAutoRenewTime());
        String[] paths = new String[]{"instance"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        internalRequest.addParameter("autoRenew", null);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public RdsCreateInstanceResponse createInstanceReadableReplica(RdsCreateReadableInstance request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getSourceInstanceId(), "sourceInstanceId");
        if (StringUtils.isEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (request.getBilling() == null) {
            request.setBilling(this.generateDefaultBilling());
        } else if (request.getBilling().getPaymentTiming() == RdsPaymentTiming.Prepaid) {
            throw new BceClientException("Prepaid is not support for rds read replica instance");
        }
        Integer purchaseCount = request.getPurchaseCount();
        if (purchaseCount != null && purchaseCount != 1) {
            throw new BceClientException("Currently only supported purchaseCount 1");
        }
        RdsArgumentUtil.checkCpuCount(request.getCpuCount());
        RdsArgumentUtil.checkMemoryCapacity(request.getMemoryCapacity());
        RdsArgumentUtil.checkVolumeCapacity(request.getVolumeCapacity());
        String[] paths = new String[]{"instance"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        internalRequest.addParameter("readReplica", null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, RdsCreateInstanceResponse.class);
    }

    public RdsCreateInstanceResponse createInstanceProxy(RdsCreateProxyInstance request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getSourceInstanceId(), "sourceInstanceId");
        if (StringUtils.isEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (request.getBilling() == null) {
            request.setBilling(this.generateDefaultBilling());
        } else if (request.getBilling().getPaymentTiming() == RdsPaymentTiming.Prepaid) {
            throw new BceClientException("Prepaid is not support for rds proxy instance");
        }
        Integer nodeAmount = request.getNodeAmount();
        RdsArgumentUtil.checkNodeAmount(nodeAmount);
        String[] paths = new String[]{"instance"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        internalRequest.addParameter("rdsproxy", null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, RdsCreateInstanceResponse.class);
    }

    public RdsZoneResponse getZoneList() {
        String[] paths = new String[]{"zone"};
        InternalRequest internalRequest = this.createRequest(new RdsZoneRequest(), HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsZoneResponse.class);
    }

    public RdsSubnetResponse getSubnetList(RdsSubnetRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String[] paths = new String[]{"subnet"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        if (StringUtils.isNotEmpty((String)request.getVpcId())) {
            internalRequest.addParameter("vpcId", request.getVpcId());
        }
        if (StringUtils.isNotEmpty((String)request.getZoneName())) {
            internalRequest.addParameter("zoneName", request.getZoneName());
        }
        return this.invokeHttpClient(internalRequest, RdsSubnetResponse.class);
    }

    public RdsViewWriteListResponse viewWriteList(RdsViewWriteListRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId, "securityIp"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsViewWriteListResponse.class);
    }

    public AbstractBceResponse updateWriteList(RdsUpdateWriteListResquest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId, "securityIp"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        internalRequest.addHeader("x-bce-if-match", "v1");
        SecurityIps securityIps = new SecurityIps();
        securityIps.setSecurityIps(request.getSecurityIps());
        this.fillPayload(internalRequest, securityIps);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public RdsGetOrderStatusResponse getOrderStatus(RdsGetOrderStatusRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String orderId = request.getOrderId();
        String[] paths = new String[]{"instance", "order", orderId};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsGetOrderStatusResponse.class);
    }

    public RdsReleaseInstanceResponse releaseInstance(RdsReleaseInstanceRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        if (CollectionUtils.isEmpty(request.getInstanceIds())) {
            throw new BceClientException("instanceIds can not be empty");
        }
        if (request.getInstanceIds().size() > 10) {
            throw new BceClientException("instanceIds can not be greater than 10");
        }
        String[] paths = new String[]{"instance"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, paths);
        internalRequest.addParameter("instanceIds", this.convertInstanceIds(request.getInstanceIds()));
        return this.invokeHttpClient(internalRequest, RdsReleaseInstanceResponse.class);
    }

    private String convertInstanceIds(List<String> instanceIds) {
        StringBuilder builder = new StringBuilder();
        for (String instanceId : instanceIds) {
            if (builder.length() == 0) {
                builder.append(instanceId);
                continue;
            }
            builder.append(",").append(instanceId);
        }
        return builder.toString();
    }

    public AbstractBceResponse createDatabase(RdsCreateDatabaseRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsArgumentUtil.checkString(instanceId, INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getDbName(), "dbName");
        if (request.getRemark() == null) {
            request.setRemark("");
        }
        RdsArgumentUtil.checkNull((Object)request.getCharacterSetName(), "characterSetName");
        RdsInstanceDetailRequest detailRequest = new RdsInstanceDetailRequest();
        detailRequest.setInstanceId(request.getInstanceId());
        RdsInstanceDetailResponse detailResponse = this.getRdsInstanceDetail(detailRequest);
        if (detailResponse.getEngine() == RdsEngine.PostgreSQL) {
            throw new BceClientException("can not create database for engine " + (Object)((Object)RdsEngine.PostgreSQL));
        }
        String[] paths = new String[]{"instance", instanceId, "databases"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse deleteDatabase(RdsDeleteDatabaseRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsArgumentUtil.checkString(instanceId, INSTANCE_ID_KEY);
        String dbName = request.getDbName();
        RdsArgumentUtil.checkString(dbName, "dbName");
        String[] paths = new String[]{"instance", instanceId, "databases", dbName};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, paths);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse changeDatabasePort(RdsChangeDatabasePortRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkNull(request.getEntryPort(), "entryPort");
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId, "port"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        DatabaseEntryPort entryPort = new DatabaseEntryPort();
        entryPort.setEntryPort(request.getEntryPort());
        this.fillPayload(internalRequest, entryPort);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public RdsGetDatabaseListResponse getDatabaseList(RdsGetDatabaseListRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId, "databases"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsGetDatabaseListResponse.class);
    }

    public AbstractBceResponse modifyDatabaseDescription(RdsModifyDatabaseDescriptionRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getDbName(), "dbName");
        RdsArgumentUtil.checkString(request.getRemark(), "remark");
        String instanceId = request.getInstanceId();
        String dbName = request.getDbName();
        String[] paths = new String[]{"instance", instanceId, "databases", dbName, "remark"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse modifyBackup(RdsModifyBackupRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsArgumentUtil.checkString(instanceId, INSTANCE_ID_KEY);
        String backupDays = request.getBackupDays();
        RdsArgumentUtil.checkString(backupDays, "backupDays");
        String[] days = backupDays.split(",");
        if (days.length == 0) {
            throw new BceClientException("backupDays must be split by ','");
        }
        RdsArgumentUtil.checkString(request.getBackupTime(), "backupTime");
        Integer expireInDays = request.getExpireInDays();
        if (expireInDays != null && (expireInDays < 7 || expireInDays > 730)) {
            throw new BceClientException("expireInDays must range in [7,730]");
        }
        String[] paths = new String[]{"instance", instanceId};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        request.setInstanceId(null);
        this.fillPayload(internalRequest, request);
        internalRequest.addParameter("modifyBackupPolicy", null);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public RdsGetBackupListResponse getBackupList(RdsGetBackupListRequest request) {
        Integer maxKeys;
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsArgumentUtil.checkString(instanceId, INSTANCE_ID_KEY);
        String[] paths = new String[]{"instance", instanceId, "backup"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        if (StringUtils.isNotEmpty((String)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if ((maxKeys = request.getMaxKeys()) != null) {
            if (maxKeys > 1000) {
                throw new BceClientException("maxKeys can not be greater than 1000");
            }
            internalRequest.addParameter("maxKeys", String.valueOf(maxKeys));
        }
        return this.invokeHttpClient(internalRequest, RdsGetBackupListResponse.class);
    }

    public RdsBackupInfoResponse getBackupInfo(RdsBackupInfoRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsArgumentUtil.checkString(instanceId, INSTANCE_ID_KEY);
        String backupId = request.getBackupId();
        RdsArgumentUtil.checkString(backupId, "backupId");
        String[] paths = new String[]{"instance", instanceId, "backup", backupId};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsBackupInfoResponse.class);
    }

    public AbstractBceResponse manuallyInitiateFullPhysicalBackup(RdsFullPhysicalBackupRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getEffectiveTime(), "effectiveTime");
        RdsArgumentUtil.checkString(request.getDataBackupType(), "dataBackupType");
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId, "backup"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse deleteTheSpecifiedBackupSet(RdsDeleteSpecifiedBackUpRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getSnapshotId(), "snapshotId");
        String instanceId = request.getInstanceId();
        String snapshotId = request.getSnapshotId();
        String[] paths = new String[]{"instance", instanceId, "backup", snapshotId};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, paths);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public RdsGetBinLogListResponse getBinLogList(RdsGetBinLogListRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getDatetime(), "datetime");
        String instanceId = request.getInstanceId();
        String datetime = request.getDatetime();
        String[] paths = new String[]{"instance", instanceId, "binlogs", datetime};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsGetBinLogListResponse.class);
    }

    public RdsGetBinLogInfoRsponse getBinLogInfo(RdsGetBinLogInfoRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getLogId(), "logId");
        RdsArgumentUtil.checkString(request.getDownloadValidTimeInSec(), "downloadValidTimeInSec");
        String instanceId = request.getInstanceId();
        String logId = request.getLogId();
        String downloadValidTimeInSec = request.getDownloadValidTimeInSec();
        String[] paths = new String[]{"instance", instanceId, "binlogs", logId, downloadValidTimeInSec};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsGetBinLogInfoRsponse.class);
    }

    public AbstractBceResponse recoverForTimeNode(RdsRecoverForTimeNodeRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getDatetime(), "datetime");
        RdsArgumentUtil.checkNull(request.getData(), "data");
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId, "recoveryToSourceInstanceByDatetime"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse recoverForBackUpSet(RdsRecoverForBackUpSetRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getSnapshotId(), "snapshotId");
        RdsArgumentUtil.checkNull(request.getData(), "data");
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId, "recoveryToSourceInstanceBySnapshot"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public RdsSlowLogDownloadTasksResponse getSlowLogDownloadTaskList(RdsSlowLogDownloadTasksRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsArgumentUtil.checkString(instanceId, INSTANCE_ID_KEY);
        String datetime = request.getDatetime();
        RdsArgumentUtil.checkString(datetime, "datetime");
        String[] paths = new String[]{"instance", instanceId, "slowlogs", "logList", datetime};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsSlowLogDownloadTasksResponse.class);
    }

    public RdsSlowLogDownloadDetailResponse getSlowLogDownloadDetail(RdsSlowLogDownloadDetailRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsArgumentUtil.checkString(instanceId, INSTANCE_ID_KEY);
        String logId = request.getLogId();
        RdsArgumentUtil.checkString(logId, "logId");
        Integer time = request.getDownloadValidTimeInSec();
        RdsArgumentUtil.checkNull(time, "downloadValidTimeInSec");
        String[] paths = new String[]{"instance", instanceId, "slowlogs", "download_url", logId, time.toString()};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsSlowLogDownloadDetailResponse.class);
    }

    public RdsSlowLogGetErrorLogDetailsResponse getSlowLogGetErrorLogDetails(RdsSlowLogGetErrorLogDetailsRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsArgumentUtil.checkString(instanceId, INSTANCE_ID_KEY);
        String[] paths = new String[]{"instance", instanceId, "errorlogs", "details"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, RdsSlowLogGetErrorLogDetailsResponse.class);
    }

    public RdsSlowLogErrorLogDownloadDetailsResponse getSlowLogErrorLogDownloadDetails(RdsSlowLogErrorLogDownloadDetailsRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getLogId(), "logId");
        RdsArgumentUtil.checkNull(request.getDownloadValidTimeInSec(), "downloadValidTimeInSec");
        String instanceId = request.getInstanceId();
        String logId = request.getLogId();
        Integer downloadValidTimeInSec = request.getDownloadValidTimeInSec();
        String[] paths = new String[]{"instance", instanceId, "errorlogs", "download_url", logId, downloadValidTimeInSec.toString()};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsSlowLogErrorLogDownloadDetailsResponse.class);
    }

    public RdsSlowLogGetErrorLogListResponse slowLogGetErrorLogList(RdsSlowLogGetErrorLogListRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsArgumentUtil.checkString(instanceId, INSTANCE_ID_KEY);
        String datetime = request.getDatetime();
        RdsArgumentUtil.checkString(datetime, "datetime");
        String[] paths = new String[]{"instance", instanceId, "errorlogs", "logList", datetime};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsSlowLogGetErrorLogListResponse.class);
    }

    public RdsGetPGLogDetailsResponse getPGLogDetails(RdsGetPGLogDetailsRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkString(request.getPglogId(), "pglogId");
        RdsArgumentUtil.checkNull(request.getDownloadValidTimeInSec(), "downloadValidTimeInSec");
        String instanceId = request.getInstanceId();
        String pglogId = request.getPglogId();
        Integer downloadValidTimeInSec = request.getDownloadValidTimeInSec();
        String[] paths = new String[]{"instance", instanceId, "pg", "download"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        internalRequest.addParameter("pglogId", pglogId);
        internalRequest.addParameter("downloadValidTimeInSec", downloadValidTimeInSec.toString());
        return this.invokeHttpClient(internalRequest, RdsGetPGLogDetailsResponse.class);
    }

    public RdsGetPGListResponse getPGList(RdsGetPGListRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        String date = request.getDate();
        RdsArgumentUtil.checkString(date, "date");
        RdsArgumentUtil.checkString(instanceId, INSTANCE_ID_KEY);
        String[] paths = new String[]{"instance", instanceId, "pg", "list"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        internalRequest.addParameter("date", date);
        return this.invokeHttpClient(internalRequest, RdsGetPGListResponse.class);
    }

    public RdsParameterListResponse getParameterList(RdsParameterListRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsArgumentUtil.checkString(instanceId, INSTANCE_ID_KEY);
        String[] paths = new String[]{"instance", instanceId, "parameter"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, RdsParameterListResponse.class);
    }

    public AbstractBceResponse modifyParameter(RdsModifyParameterRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsArgumentUtil.checkString(instanceId, INSTANCE_ID_KEY);
        String etag = request.getEtag();
        RdsArgumentUtil.checkString(etag, "etag");
        if (CollectionUtils.isEmpty(request.getParameters())) {
            throw new BceClientException("The parameters can not be null or empty");
        }
        String[] paths = new String[]{"instance", instanceId, "parameter"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        request.setInstanceId(null);
        internalRequest.addHeader("x-bce-if-match", etag);
        request.setEtag(null);
        this.fillPayload(internalRequest, request);
        AbstractBceResponse response = this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
        request.setInstanceId(instanceId);
        request.setEtag(etag);
        return response;
    }

    public AbstractBceResponse updateRdsPublicNetworkAccessStatus(RdsNetworkStatusRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsPublicAccess rdsPublicAccess = new RdsPublicAccess();
        rdsPublicAccess.setPublicAccess(request.isPublicAccess());
        String[] paths = new String[]{"instance", instanceId};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        internalRequest.addParameter("modifyPublicAccess", null);
        this.fillPayload(internalRequest, rdsPublicAccess);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse updateRdsSyncMode(RdsSyncModeRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsSyncMode rdsSyncMode = new RdsSyncMode();
        rdsSyncMode.setSyncMode(request.getSyncMode());
        String[] paths = new String[]{"instance", instanceId};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        internalRequest.addParameter("modifySyncMode", null);
        this.fillPayload(internalRequest, rdsSyncMode);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse updateRdsName(RdsUpdateNameRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId};
        RdsInstanceName instanceName = new RdsInstanceName();
        instanceName.setInstanceName(request.getInstanceName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        internalRequest.addParameter("rename", null);
        this.fillPayload(internalRequest, instanceName);
        AbstractBceResponse response = this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
        return response;
    }

    public AbstractBceResponse updateRdsConnectionInformation(RdsConnInformationRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        internalRequest.addParameter("modifyEndpoint", null);
        RdsAddress address = new RdsAddress();
        address.setAddress(request.getAddress());
        this.fillPayload(internalRequest, address);
        AbstractBceResponse response = this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
        return response;
    }

    public AbstractBceResponse rdsRestart(RdsRestartRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        String effectiveTime = request.geteffectiveTime();
        String[] paths = new String[]{"instance", instanceId};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        internalRequest.addParameter("reboot", null);
        AbstractBceResponse response = this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
        return response;
    }

    public RdsRenewalResponse rdsRenewal(RdsRenewalRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkNull(request.getDuration(), "duration");
        String[] paths = new String[]{"instance", "renew"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        this.fillPayload(internalRequest, request);
        RdsRenewalResponse response = this.invokeHttpClient(internalRequest, RdsRenewalResponse.class);
        return response;
    }

    public AbstractBceResponse rdsUpdateTimeWindow(RdsUpdateTimeWindowRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsArgumentUtil.checkNull(request.getMaintainStartTime(), "maintainStartTime");
        RdsArgumentUtil.checkNull(request.getMaintainDuration(), "maintainDuration");
        String[] paths = new String[]{"instance", instanceId, "maintaintime"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        this.fillPayload(internalRequest, request);
        AbstractBceResponse response = this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
        return response;
    }

    public RdsUpdateStorageAutoExpansionConfigResPonse updateRdsStorageAutoExpansionConfig(RdsUpdateStorageAutoExpansionConfigRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        String action = request.getAction();
        String[] paths = new String[]{"instance", instanceId, "diskAutoResize", "config", action};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        this.fillPayload(internalRequest, request);
        RdsUpdateStorageAutoExpansionConfigResPonse resPonse = this.invokeHttpClient(internalRequest, RdsUpdateStorageAutoExpansionConfigResPonse.class);
        return resPonse;
    }

    public RdsGetAutoConfigForSpecifiedResponse getAutoConfigForSpecified(RdsGetAutoConfigForSpecifiedRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId, "autoResizeConfig"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        RdsGetAutoConfigForSpecifiedResponse response = this.invokeHttpClient(internalRequest, RdsGetAutoConfigForSpecifiedResponse.class);
        return response;
    }

    public RdsSupportEnableAutoExpansionResponse supportEnableAutoExpansion(RdsSupportEnableAutoExpansionRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId, "autoExpansion"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        RdsSupportEnableAutoExpansionResponse response = this.invokeHttpClient(internalRequest, RdsSupportEnableAutoExpansionResponse.class);
        return response;
    }

    public AbstractBceResponse availableZoneMigration(RdsZoneMigrationRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsArgumentUtil.checkNull(request.getMasterAzone(), "master_azone");
        RdsArgumentUtil.checkNull(request.getBackupAzone(), "backup_azone");
        if (CollectionUtils.isEmpty(request.getZoneNames())) {
            throw new BceClientException("Please set ZoneNames in request.");
        }
        if (CollectionUtils.isEmpty(request.getSubnets())) {
            throw new BceClientException("Please set subNets in request.");
        }
        RdsArgumentUtil.checkNull(request.getEffectiveTime(), "effectiveTime");
        String[] paths = new String[]{"instance", instanceId, "azoneMigration"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        this.fillPayload(internalRequest, request);
        AbstractBceResponse response = this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
        return response;
    }

    public AbstractBceResponse bindingTags(RdsBindingTagsRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkNull(request.getResources(), "resources");
        Resource resource = request.getResources().get(0);
        resource.getInstanceId();
        RdsTag tag = resource.getTags().get(0);
        tag.getTagKey();
        tag.getTagValue();
        String[] paths = new String[]{"instance", "tags"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        this.fillPayload(internalRequest, request);
        AbstractBceResponse response = this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
        return response;
    }

    public RdsClusterStatusCheckResponse clusterStatusCheck(RdsClusterStatusCheckRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId, "status"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        RdsClusterStatusCheckResponse response = this.invokeHttpClient(internalRequest, RdsClusterStatusCheckResponse.class);
        return response;
    }

    public RdsBatchScalingResponse batchScaling(RdsBatchScalingRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID_KEY);
        String instanceId = request.getInstanceId();
        Integer cpuCount = request.getCpuCount();
        Integer memoryCapacity = request.getMemoryCapacity();
        Integer volumeCapacity = request.getVolumeCapacity();
        if (cpuCount == null && memoryCapacity == null && volumeCapacity == null) {
            String msg = "Please set one of cpuCount,memoryCapacity,volumeCapacity when resize instance";
            throw new BceClientException(msg);
        }
        RdsArgumentUtil.checkVolumeCapacity(volumeCapacity);
        String[] paths = new String[]{"instance", instanceId};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        internalRequest.addParameter("resize", null);
        this.fillPayload(internalRequest, request);
        RdsBatchScalingResponse response = this.invokeHttpClient(internalRequest, RdsBatchScalingResponse.class);
        return response;
    }

    public RdsDialingTestResponse dialingTest(RdsDialingTestRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        String[] paths = new String[]{"instance", instanceId, "probe"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        RdsDialingTestResponse response = this.invokeHttpClient(internalRequest, RdsDialingTestResponse.class);
        return response;
    }

    public RdsGetPriceDifferenceResponse getPriceDifference(RdsGetPriceDifferenceRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkNull(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkNull(request.getCpuCount(), "cpuCount");
        RdsArgumentUtil.checkNull(request.getAllocatedMemoryInGB(), "allocatedMemoryInGB");
        RdsArgumentUtil.checkNull(request.getAllocatedStorageInGB(), "allocatedStorageInGB");
        RdsArgumentUtil.checkNull(request.getDiskIoType(), "diskIoType");
        String[] paths = new String[]{"instance", "price", "diff"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        this.fillPayload(internalRequest, request);
        RdsGetPriceDifferenceResponse response = this.invokeHttpClient(internalRequest, RdsGetPriceDifferenceResponse.class);
        return response;
    }

    public RdsGetNewPurchasePriceResponse getNewPurchasePrice(RdsGetNewPurchasePriceRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        RdsArgumentUtil.checkNull(request.getProductType(), "productType");
        RdsGetNewPurchasePriceRequest.Instance instance = request.getInstance();
        if (instance != null) {
            RdsArgumentUtil.checkNull(instance.getEngine(), "engine");
            RdsArgumentUtil.checkNull(instance.getDiskIoType(), "diskIoType");
            RdsArgumentUtil.checkNull(instance.getCpuCount(), "cpuCount");
            RdsArgumentUtil.checkNull(instance.getAllocatedMemoryInGB(), "allocatedMemoryInGB");
            RdsArgumentUtil.checkNull(instance.getAllocatedStorageInGB(), "allocatedStorageInGB");
        } else {
            RdsArgumentUtil.checkNull(instance, "Instance cannot be null");
        }
        String[] paths = new String[]{"instance", "price"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        this.fillPayload(internalRequest, request);
        RdsGetNewPurchasePriceResponse response = this.invokeHttpClient(internalRequest, RdsGetNewPurchasePriceResponse.class);
        return response;
    }

    public RdsSupportHotSwappingResponse supportHotSwapping(RdsSupportHotSwappingRequest request) {
        RdsArgumentUtil.checkNull(request, REQUEST_KEY);
        String instanceId = request.getInstanceId();
        RdsArgumentUtil.checkNull(request.getInstanceId(), INSTANCE_ID_KEY);
        RdsArgumentUtil.checkNull(request.getCpuCount(), "cpuCount");
        RdsArgumentUtil.checkNull(request.getAllocatedMemoryInMB(), "allocatedMemoryInMB");
        RdsArgumentUtil.checkNull(request.getAllocatedStorageInGB(), "allocatedStorageInGB");
        RdsArgumentUtil.checkNull(request.getMasterAzone(), "masterAzone");
        RdsArgumentUtil.checkNull(request.getSubnetId(), "subnetId");
        String[] paths = new String[]{"instance", instanceId, "checkHotUpgrade"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        this.fillPayload(internalRequest, request);
        RdsSupportHotSwappingResponse response = this.invokeHttpClient(internalRequest, RdsSupportHotSwappingResponse.class);
        return response;
    }
}

