/*
 * Copyright (C) 2020 Baidu, Inc. All Rights Reserved.
 */
package com.baidubce.services.eipbp.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bcc.model.TagModel;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * The request for creating a newly eipBp.
 */
@Getter
@Setter
public class CreateEipBpRequest extends AbstractBceRequest {
    /**
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/EIP/API.html#.E9.80.9A.E7.94.A8.E8.AF.B4.E6.98.8E">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;
    /**
     * The name of eipBp. The optional parameter.
     */
    private String name;
    /**
     * The eip address that the eipBp attach. Param "eip" and "eipGroupId" will have only one param take effect.
     */
    private String eip;
    /**
     * The eipGroupId that the eipBp attach. Param "eip" and "eipGroupId" will have only one param take effect.
     */
    private String eipGroupId;
    /**
     * The bandwidth of eipBp in Mbps.
     */
    private Integer bandwidthInMbps;
    /**
     * The eipBp autoReleaseTime. Format is "yyyy-MM-ddTHH:mm:ssZ". The optional parameter.
     */
    private String autoReleaseTime;

    /**
     * The tags which will be bound to eipBp.
     */
    private List<TagModel> tags;

    /**
     * The ID of resourceGroup which will be bound to eipBp.
     */
    private String resourceGroupId;

    public CreateEipBpRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public CreateEipBpRequest withName(String name) {
        this.name = name;
        return this;
    }

    public CreateEipBpRequest withEip(String eip) {
        this.eip = eip;
        return this;
    }

    public CreateEipBpRequest withEipGroupId(String eipGroupId) {
        this.eipGroupId = eipGroupId;
        return this;
    }

    public CreateEipBpRequest withBandwidthInMbps(Integer bandwidthInMbps) {
        this.bandwidthInMbps = bandwidthInMbps;
        return this;
    }


    public CreateEipBpRequest withAutoReleaseTime(String autoReleaseTime) {
        this.autoReleaseTime = autoReleaseTime;
        return this;
    }

    public CreateEipBpRequest withTags(List<TagModel> tags) {
        this.tags = tags;
        return this;
    }

    public CreateEipBpRequest withResourceGroupId(String resourceGroupId) {
        this.resourceGroupId = resourceGroupId;
        return this;
    }

    public CreateEipBpRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
