package com.baidubce.services.vod.v2.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonProperty;

public class MediaUploadRequest extends AbstractBceRequest {
    private String name;
    private String container;
    @JsonProperty("isMultipartUpload")
    private boolean isMultipartUpload = false;
    private Integer numParts = 1;
    private String description;

    public MediaUploadRequest() {
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContainer() {
        return container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public boolean isMultipartUpload() {
        return isMultipartUpload;
    }

    public void setMultipartUpload(boolean multipartUpload) {
        this.isMultipartUpload = multipartUpload;
    }

    public Integer getNumParts() {
        return numParts;
    }

    public void setNumParts(Integer numParts) {
        this.numParts = numParts;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
