package com.baidubce.services.vod.v2;

import com.baidubce.BceClientConfiguration;
import com.baidubce.auth.DefaultBceCredentials;

public class VodClientConfiguration extends BceClientConfiguration {

    /**
     * Set vod credentials.
     *
     * @param credentials The default credentials
     * @return A VodClientConfiguration instance.
     */
    public VodClientConfiguration withCredentials(DefaultBceCredentials credentials) {
        this.setCredentials(credentials);
        return this;
    }

    /**
     * Set vod endpoint.
     * @param endpoint The service endpoint URL to which the client will connect.
     * @return A VodClientConfiguration instance.
     */
    public VodClientConfiguration withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

}
