package com.baidubce.services.vod.v2.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DagInfo {

    private Map<String, WorkflowNodeInfo> nodes = new HashMap<>();
    private Map<String, List<String>> dependencies;

    public DagInfo() {
    }

    public Map<String, WorkflowNodeInfo> getNodes() {
        return nodes;
    }

    public void setNodes(Map<String, WorkflowNodeInfo> nodes) {
        this.nodes = nodes;
    }

    public Map<String, List<String>> getDependencies() {
        return dependencies;
    }

    public void setDependencies(Map<String, List<String>> dependencies) {
        this.dependencies = dependencies;
    }


    public static class WorkflowNodeInfo {
        private String nodeId;
        private String name;
        private NodeConfigInfo nodeConfig;

        private String type;

        public WorkflowNodeInfo() {
        }

        public String getNodeId() {
            return nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public NodeConfigInfo getNodeConfig() {
            return nodeConfig;
        }

        public void setNodeConfig(NodeConfigInfo nodeConfig) {
            this.nodeConfig = nodeConfig;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class NodeConfigInfo {
        private String input;
        private String output;
        private String dynamicParams;

        public NodeConfigInfo() {
        }

        public String getInput() {
            return input;
        }

        public void setInput(String input) {
            this.input = input;
        }

        public String getOutput() {
            return output;
        }

        public void setOutput(String output) {
            this.output = output;
        }

        public String getDynamicParams() {
            return dynamicParams;
        }

        public void setDynamicParams(String dynamicParams) {
            this.dynamicParams = dynamicParams;
        }
    }

}
