package com.baidubce.services.vod.v2.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;

import java.util.List;
import java.util.Map;


public class MediaProcessRequest extends AbstractBceRequest {

    private String mediaId;

    private MediaProcessByWorkflow workflow;

    private MediaProcessByPreset preset;

    public MediaProcessByWorkflow getWorkflow() {
        return workflow;
    }

    public void setWorkflow(MediaProcessByWorkflow workflow) {
        this.workflow = workflow;
    }

    public MediaProcessByPreset getPreset() {
        return preset;
    }

    public void setPreset(MediaProcessByPreset preset) {
        this.preset = preset;
    }

    public MediaProcessRequest() {
    }

    public String getMediaId() {
        return mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    public static class MediaProcessByWorkflow {

        private String workflowId;
        private Map<String, String> dynamicParams;

        public MediaProcessByWorkflow() {
        }

        public String getWorkflowId() {
            return workflowId;
        }

        public void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public Map<String, String> getDynamicParams() {
            return dynamicParams;
        }

        public void setDynamicParams(Map<String, String> dynamicParams) {
            this.dynamicParams = dynamicParams;
        }
    }

    public static class MediaProcessByPreset {
        private List<String> presetIds;

        public MediaProcessByPreset() {
        }

        public List<String> getPresetIds() {
            return presetIds;
        }

        public void setPresetIds(List<String> presetIds) {
            this.presetIds = presetIds;
        }
    }
}
