/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.lbdc;

import com.baidubce.BceClientConfiguration;
import com.baidubce.common.ApiInfo;
import com.baidubce.common.BaseBceClient;
import com.baidubce.common.BaseBceResponse;
import com.baidubce.common.BceRegion;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.lbdc.api.LbdcApi;
import com.baidubce.services.lbdc.model.CreateLbdcRequest;
import com.baidubce.services.lbdc.model.CreateLbdcResponse;
import com.baidubce.services.lbdc.model.GetBoundBlBListOfLbdcResponse;
import com.baidubce.services.lbdc.model.GetLbdcResponse;
import com.baidubce.services.lbdc.model.ListLbdcResponse;
import com.baidubce.services.lbdc.model.RenewLbdcRequest;
import com.baidubce.services.lbdc.model.UpdateLbdcRequest;
import com.baidubce.services.lbdc.model.UpgradeLbdcRequest;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class LbdcClient
extends BaseBceClient {
    private static final Map<BceRegion, String> ENDPOINTS = ImmutableMap.builder().put((Object)BceRegion.BJ, (Object)"http://blb.bj.baidubce.com").build();
    private static final String SERVICE_ID = "Lbdc";
    private static final Map<String, ApiInfo> LBDC_APIS = LbdcApi.getApis();

    public LbdcClient(String ak, String sk, BceRegion region) {
        super(SERVICE_ID, ak, sk, ENDPOINTS.get((Object)region));
    }

    public LbdcClient(String ak, String sk) {
        super(SERVICE_ID, ak, sk, ENDPOINTS.get((Object)BceRegion.DEFAULT));
    }

    public LbdcClient(BceClientConfiguration configuration) {
        super(configuration);
    }

    public CreateLbdcResponse createLbdc(CreateLbdcRequest body, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(LBDC_APIS.get("createLbdc"));
        String apiPath = apiInfo.getPath().get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, CreateLbdcResponse.class);
    }

    public GetBoundBlBListOfLbdcResponse getBoundBlBListOfLbdc(String id) {
        ApiInfo apiInfo = new ApiInfo(LBDC_APIS.get("getBoundBlBListOfLbdc"));
        String apiPath = apiInfo.getPath().withPathParameter("id", id).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, GetBoundBlBListOfLbdcResponse.class);
    }

    public GetLbdcResponse getLbdc(String id) {
        ApiInfo apiInfo = new ApiInfo(LBDC_APIS.get("getLbdc"));
        String apiPath = apiInfo.getPath().withPathParameter("id", id).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, GetLbdcResponse.class);
    }

    public ListLbdcResponse listLbdc(String id, String name) {
        ApiInfo apiInfo = new ApiInfo(LBDC_APIS.get("listLbdc"));
        String apiPath = apiInfo.getPath().get();
        apiInfo.getQueries().put("id", id);
        apiInfo.getQueries().put("name", name);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListLbdcResponse.class);
    }

    public void renewLbdc(String id, RenewLbdcRequest body, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(LBDC_APIS.get("renewLbdc"));
        String apiPath = apiInfo.getPath().withPathParameter("id", id).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void updateLbdc(String id, UpdateLbdcRequest body, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(LBDC_APIS.get("updateLbdc"));
        String apiPath = apiInfo.getPath().withPathParameter("id", id).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void upgradeLbdc(String id, UpgradeLbdcRequest body, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(LBDC_APIS.get("upgradeLbdc"));
        String apiPath = apiInfo.getPath().withPathParameter("id", id).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }
}

