/*
 * Copyright 2020 Baidu, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.as.model.zone;

/**
 * Availability zone and subnet info
 */
public class ZoneInfo {

    private String zone;

    /**
     * The id of subnet.
     */
    private String subnetId;

    private String subnetUuid;
    private String subnetName;
    private Short subnetType;

    public String getSubnetUuid() {
        return subnetUuid;
    }

    public void setSubnetUuid(String subnetUuid) {
        this.subnetUuid = subnetUuid;
    }

    public String getSubnetName() {
        return subnetName;
    }

    public void setSubnetName(String subnetName) {
        this.subnetName = subnetName;
    }

    public Short getSubnetType() {
        return subnetType;
    }

    public void setSubnetType(Short subnetType) {
        this.subnetType = subnetType;
    }

    public String getZone() {
        return zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getSubnetId() {
        return subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    @Override
    public String toString() {
        return "ZoneInfo{" +
                "zone='" + zone + '\'' +
                ", subnetId='" + subnetId + '\'' +
                ", subnetUuid='" + subnetUuid + '\'' +
                ", subnetName='" + subnetName + '\'' +
                ", subnetType=" + subnetType +
                '}';
    }
}
