/*
 * Copyright (C) 2020 Baidu, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.iotdmp.model.ota.product;

import com.baidubce.model.AbstractBceResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class OtaProductConfig extends AbstractBceResponse {
    private Integer pid;
    private String name;
    private String status;
    private String company;
    private Integer groupId;
    private String chipType;
    private String deviceType;
    private String remark;
    private String os;
    private Integer combinePid;
    private String priceType;
    private String discount;
    private Integer exclusive;
    private Boolean enableService;
    private Integer servicePrice;
    private List<String> ability;
    private Integer activeDevAmount;
    private String createdAt;
    private String updatedAt;
    private Boolean isAiotProduct;
    private String productSecret;
    private Boolean enableResToken;
    private Boolean enableAdvance;
    private Boolean enableAuthDev;
    private Boolean enableGrayRelease;
    private Integer enableChannel;
    private Boolean enableDiffLimit;
    @JsonProperty("threshold_pcdn")
    private Integer thresholdPcdn;
    private TaskConfig taskConfig;
}
