package com.baidubce.services.vod.v2.model;

import java.util.List;

public class MediaOutput {

    public static class TranscodeOutputInfo {

        private String id;
        private String url;
        private String workflowName;
        private String transcodeNodeName;
        private TranscodeMetaInfo meta;

        public static class TranscodeMetaInfo {

            private Video video;
            private Audio audio;

            public static class Video {

                private Integer durationInSeconds;

                private Integer durationInMilliSeconds;

                private Double sizeInKiloByte;

                private Integer widthInPixel;

                private Integer heightInPixel;

                private Integer frameRate;

                private Boolean gopAlign = false;

                private Integer mp4MoovSize = -1;

                public Integer getDurationInSeconds() {
                    return durationInSeconds;
                }

                public void setDurationInSeconds(Integer durationInSeconds) {
                    this.durationInSeconds = durationInSeconds;
                }

                public Integer getDurationInMilliSeconds() {
                    return durationInMilliSeconds;
                }

                public void setDurationInMilliSeconds(Integer durationInMilliSeconds) {
                    this.durationInMilliSeconds = durationInMilliSeconds;
                }

                public Double getSizeInKiloByte() {
                    return sizeInKiloByte;
                }

                public void setSizeInKiloByte(Double sizeInKiloByte) {
                    this.sizeInKiloByte = sizeInKiloByte;
                }

                public Integer getWidthInPixel() {
                    return widthInPixel;
                }

                public void setWidthInPixel(Integer widthInPixel) {
                    this.widthInPixel = widthInPixel;
                }

                public Integer getHeightInPixel() {
                    return heightInPixel;
                }

                public void setHeightInPixel(Integer heightInPixel) {
                    this.heightInPixel = heightInPixel;
                }

                public Integer getFrameRate() {
                    return frameRate;
                }

                public void setFrameRate(Integer frameRate) {
                    this.frameRate = frameRate;
                }

                public Boolean getGopAlign() {
                    return gopAlign;
                }

                public void setGopAlign(Boolean gopAlign) {
                    this.gopAlign = gopAlign;
                }

                public Integer getMp4MoovSize() {
                    return mp4MoovSize;
                }

                public void setMp4MoovSize(Integer mp4MoovSize) {
                    this.mp4MoovSize = mp4MoovSize;
                }
            }

            public static class Audio {

                private Integer sampleRateInHz;

                private Integer channels;

                public Integer getSampleRateInHz() {
                    return sampleRateInHz;
                }

                public void setSampleRateInHz(Integer sampleRateInHz) {
                    this.sampleRateInHz = sampleRateInHz;
                }

                public Integer getChannels() {
                    return channels;
                }

                public void setChannels(Integer channels) {
                    this.channels = channels;
                }
            }

        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getWorkflowName() {
            return workflowName;
        }

        public void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        public String getTranscodeNodeName() {
            return transcodeNodeName;
        }

        public void setTranscodeNodeName(String transcodeNodeName) {
            this.transcodeNodeName = transcodeNodeName;
        }

        public TranscodeMetaInfo getMeta() {
            return meta;
        }

        public void setMeta(TranscodeMetaInfo meta) {
            this.meta = meta;
        }
    }

    public static class ThumbnailOutputInfo {

        private String id;
        private List<String> urls;
        private String workflowName;
        private String thumbnailNodeName;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public List<String> getUrls() {
            return urls;
        }

        public void setUrls(List<String> urls) {
            this.urls = urls;
        }

        public String getWorkflowName() {
            return workflowName;
        }

        public void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        public String getThumbnailNodeName() {
            return thumbnailNodeName;
        }

        public void setThumbnailNodeName(String thumbnailNodeName) {
            this.thumbnailNodeName = thumbnailNodeName;
        }
    }

    public static class SubtitleOutputInfo {

        private String id;
        private List<String> urls;
        private String workflowName;
        private String subtitleNodeName;
        private List<String> formats;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public List<String> getUrls() {
            return urls;
        }

        public void setUrls(List<String> urls) {
            this.urls = urls;
        }

        public String getWorkflowName() {
            return workflowName;
        }

        public void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        public String getSubtitleNodeName() {
            return subtitleNodeName;
        }

        public void setSubtitleNodeName(String subtitleNodeName) {
            this.subtitleNodeName = subtitleNodeName;
        }

        public List<String> getFormats() {
            return formats;
        }

        public void setFormats(List<String> formats) {
            this.formats = formats;
        }
    }

    public static class VcaOutputInfo {

        private String id;
        private String workflowName;
        private String vcaNodeName;
        private List<VcaTagsResult> results;

        public static class VcaTagsResult {

            private String type;
            private List<VcaResultItem> result;

            public static class VcaResultItem {

                private String attribute;
                private String source;

                public String getAttribute() {
                    return attribute;
                }

                public void setAttribute(String attribute) {
                    this.attribute = attribute;
                }

                public String getSource() {
                    return source;
                }

                public void setSource(String source) {
                    this.source = source;
                }
            }

            public String getType() {
                return type;
            }

            public void setType(String type) {
                this.type = type;
            }

            public List<VcaResultItem> getResult() {
                return result;
            }

            public void setResult(List<VcaResultItem> result) {
                this.result = result;
            }
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getWorkflowName() {
            return workflowName;
        }

        public void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        public String getVcaNodeName() {
            return vcaNodeName;
        }

        public void setVcaNodeName(String vcaNodeName) {
            this.vcaNodeName = vcaNodeName;
        }

        public List<VcaTagsResult> getResults() {
            return results;
        }

        public void setResults(List<VcaTagsResult> results) {
            this.results = results;
        }
    }

    public static class VcrOutputInfo {

        private String id;
        private String workflowName;
        private String vcrNodeName;
        private String label;
        private List<VcrCheckResult> results;

        public static class VcrCheckResult {

            private String type;
            private List<VcrResultItem> items;

            public static class VcrResultItem {

                private String subType;
                private Integer timeInSeconds;
                private Integer startTimeInSeconds;
                private Integer endTimeInSeconds;
                private Double confidence;
                private String label;
                private String extra;
                private Evidence evidence;

                public static class Evidence {

                    private Location location;

                    public static class Location {

                        private Integer leftOffsetInPixel;
                        private Integer topOffsetInPixel;
                        private Integer widthInPixel;
                        private Integer heightInPixel;

                        public Integer getLeftOffsetInPixel() {
                            return leftOffsetInPixel;
                        }

                        public void setLeftOffsetInPixel(Integer leftOffsetInPixel) {
                            this.leftOffsetInPixel = leftOffsetInPixel;
                        }

                        public Integer getTopOffsetInPixel() {
                            return topOffsetInPixel;
                        }

                        public void setTopOffsetInPixel(Integer topOffsetInPixel) {
                            this.topOffsetInPixel = topOffsetInPixel;
                        }

                        public Integer getWidthInPixel() {
                            return widthInPixel;
                        }

                        public void setWidthInPixel(Integer widthInPixel) {
                            this.widthInPixel = widthInPixel;
                        }

                        public Integer getHeightInPixel() {
                            return heightInPixel;
                        }

                        public void setHeightInPixel(Integer heightInPixel) {
                            this.heightInPixel = heightInPixel;
                        }
                    }

                    public Location getLocation() {
                        return location;
                    }

                    public void setLocation(Location location) {
                        this.location = location;
                    }
                }

                public String getSubType() {
                    return subType;
                }

                public void setSubType(String subType) {
                    this.subType = subType;
                }

                public Integer getTimeInSeconds() {
                    return timeInSeconds;
                }

                public void setTimeInSeconds(Integer timeInSeconds) {
                    this.timeInSeconds = timeInSeconds;
                }

                public Integer getStartTimeInSeconds() {
                    return startTimeInSeconds;
                }

                public void setStartTimeInSeconds(Integer startTimeInSeconds) {
                    this.startTimeInSeconds = startTimeInSeconds;
                }

                public Integer getEndTimeInSeconds() {
                    return endTimeInSeconds;
                }

                public void setEndTimeInSeconds(Integer endTimeInSeconds) {
                    this.endTimeInSeconds = endTimeInSeconds;
                }

                public Double getConfidence() {
                    return confidence;
                }

                public void setConfidence(Double confidence) {
                    this.confidence = confidence;
                }

                public String getLabel() {
                    return label;
                }

                public void setLabel(String label) {
                    this.label = label;
                }

                public String getExtra() {
                    return extra;
                }

                public void setExtra(String extra) {
                    this.extra = extra;
                }

                public Evidence getEvidence() {
                    return evidence;
                }

                public void setEvidence(Evidence evidence) {
                    this.evidence = evidence;
                }
            }

            public String getType() {
                return type;
            }

            public void setType(String type) {
                this.type = type;
            }

            public List<VcrResultItem> getItems() {
                return items;
            }

            public void setItems(List<VcrResultItem> items) {
                this.items = items;
            }
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getWorkflowName() {
            return workflowName;
        }

        public void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        public String getVcrNodeName() {
            return vcrNodeName;
        }

        public void setVcrNodeName(String vcrNodeName) {
            this.vcrNodeName = vcrNodeName;
        }

        public String getLabel() {
            return label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public List<VcrCheckResult> getResults() {
            return results;
        }

        public void setResults(List<VcrCheckResult> results) {
            this.results = results;
        }
    }

}
