package com.baidubce.services.vod.v2.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;


public class MediaUploadDoneRequest extends AbstractBceRequest {
    @JsonProperty("isMultipartUpload")
    private boolean isMultipartUpload;
    private List<String> etags;
    private String sessionKey;
    private boolean autoExtractCover;

    public boolean isAutoExtractCover() {
        return autoExtractCover;
    }

    public void setAutoExtractCover(boolean autoExtractCover) {
        this.autoExtractCover = autoExtractCover;
    }

    public MediaUploadDoneRequest() {
    }

    public boolean isMultipartUpload() {
        return isMultipartUpload;
    }

    public void setMultipartUpload(boolean multipartUpload) {
        isMultipartUpload = multipartUpload;
    }

    public List<String> getEtags() {
        return etags;
    }

    public void setEtags(List<String> etags) {
        this.etags = etags;
    }

    public String getSessionKey() {
        return sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
